/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ComplexityHolder;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractableExpressionPart {
    final PsiExpression myUsage;
    final PsiVariable myVariable;
    final Object myValue;
    final PsiType myType;

    private ExtractableExpressionPart(@NotNull PsiExpression usage, PsiVariable variable, Object value, @NotNull PsiType type) {
        if (usage == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(1);
        }
        this.myUsage = usage;
        this.myVariable = variable;
        this.myValue = value;
        this.myType = type;
    }

    @Nullable
    static PsiType commonType(@NotNull ExtractableExpressionPart part1, @NotNull ExtractableExpressionPart part2) {
        if (part1 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(2);
        }
        if (part2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(3);
        }
        return ExtractableExpressionPart.commonType(part1.myType, part2.myType);
    }

    @Nullable
    private static PsiType commonType(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(5);
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return null;
    }

    boolean isEquivalent(@NotNull ExtractableExpressionPart part) {
        if (part == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(6);
        }
        if (this.myVariable != null && this.myVariable.equals(part.myVariable)) {
            return true;
        }
        if (this.myValue != null && this.myValue.equals(part.myValue)) {
            return true;
        }
        return JavaPsiEquivalenceUtil.areExpressionsEquivalent(PsiUtil.skipParenthesizedExprDown(this.myUsage), PsiUtil.skipParenthesizedExprDown(part.myUsage));
    }

    @Nullable
    static ExtractableExpressionPart match(@NotNull PsiExpression expression, @NotNull List<PsiElement> scope, @Nullable ComplexityHolder complexityHolder) {
        PsiType type;
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(8);
        }
        if (expression instanceof PsiReferenceExpression) {
            return ExtractableExpressionPart.matchVariable((PsiReferenceExpression)expression, scope);
        }
        boolean isConstant = PsiUtil.isConstantExpression(expression);
        if (isConstant && PsiTreeUtil.findChildOfType(expression, PsiJavaCodeReferenceElement.class) == null) {
            return ExtractableExpressionPart.matchConstant(expression);
        }
        if (complexityHolder != null && (isConstant || complexityHolder.isAcceptableExpression(expression)) && (type = expression.getType()) != null && !PsiType.VOID.equals(type)) {
            return new ExtractableExpressionPart(expression, null, null, type);
        }
        return null;
    }

    @Nullable
    private static ExtractableExpressionPart matchConstant(@NotNull PsiExpression expression) {
        PsiType type;
        PsiConstantEvaluationHelper constantHelper;
        Object value;
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(9);
        }
        if ((value = (constantHelper = JavaPsiFacade.getInstance(expression.getProject()).getConstantEvaluationHelper()).computeConstantExpression(expression, false)) != null && (type = expression.getType()) != null) {
            return new ExtractableExpressionPart(expression, null, value, type);
        }
        return null;
    }

    @Nullable
    static ExtractableExpressionPart matchVariable(@NotNull PsiReferenceExpression expression, @Nullable List<PsiElement> scope) {
        PsiElement resolved;
        if (expression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(10);
        }
        if ((resolved = expression.resolve()) instanceof PsiVariable && (scope == null || !DuplicatesFinder.isUnder(resolved, scope))) {
            PsiVariable variable = (PsiVariable)resolved;
            return new ExtractableExpressionPart(expression, variable, null, variable.getType());
        }
        return null;
    }

    @NotNull
    public PsiExpression getUsage() {
        PsiExpression psiExpression = this.myUsage;
        if (psiExpression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(11);
        }
        return psiExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/ExtractableExpressionPart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/ExtractableExpressionPart";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commonType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchConstant";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchVariable";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

