/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityClassCanBeEnumInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("utility.class.can.be.enum.display.name", new Object[0]);
        if (string == null) {
            UtilityClassCanBeEnumInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.code.can.be.enum.problem.descriptor", new Object[0]);
        if (string == null) {
            UtilityClassCanBeEnumInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UtilityClassCanBeEnumFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassCanBeEnumVisitor();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/UtilityClassCanBeEnumInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UtilityClassCanBeEnumVisitor
    extends BaseInspectionVisitor {
        private UtilityClassCanBeEnumVisitor() {
        }

        @Override
        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (aClass.isEnum()) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(aClass) || !UtilityClassUtil.hasPrivateEmptyOrNoConstructor(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }

    private static class UtilityClassCanBeEnumFix
    extends InspectionGadgetsFix {
        private UtilityClassCanBeEnumFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("utility.class.code.can.be.enum.quickfix", new Object[0]);
            if (string == null) {
                UtilityClassCanBeEnumFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!PsiUtil.isLanguageLevel5OrHigher(element)) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            for (PsiMethod constructor : aClass.getConstructors()) {
                constructor.delete();
            }
            List<PsiKeyword> keywords = PsiTreeUtil.getChildrenOfTypeAsList(aClass, PsiKeyword.class);
            if (keywords.isEmpty()) {
                return;
            }
            PsiModifierList modifierList = aClass.getModifierList();
            if (modifierList != null) {
                modifierList.setModifierProperty("final", false);
                modifierList.setModifierProperty("abstract", false);
                modifierList.setModifierProperty("static", false);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiStatement statement = factory.createStatementFromText(";", element);
            PsiElement token = statement.getChildren()[0];
            aClass.addAfter(token, aClass.getLBrace());
            PsiKeyword newKeyword = factory.createKeyword("enum");
            keywords.get(0).replace(newKeyword);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassCanBeEnumInspection$UtilityClassCanBeEnumFix", "getFamilyName"));
        }
    }
}

