/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class CallToSimpleGetterInClassInspectionBase
extends BaseInspection {
    public boolean ignoreGetterCallsOnOtherObjects = false;
    public boolean onlyReportPrivateGetter = false;

    @Override
    @NotNull
    public String getID() {
        if ("CallToSimpleGetterFromWithinClass" == null) {
            CallToSimpleGetterInClassInspectionBase.$$$reportNull$$$0(0);
        }
        return "CallToSimpleGetterFromWithinClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.display.name", new Object[0]);
        if (string == null) {
            CallToSimpleGetterInClassInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToSimpleGetterInClassInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleGetterInClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/CallToSimpleGetterInClassInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CallToSimpleGetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleGetterInClassVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                CallToSimpleGetterInClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiClass containingClass = ClassUtils.getContainingClass(call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleGetterInClassInspectionBase.this.ignoreGetterCallsOnOtherObjects) {
                    return;
                }
                PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly(qualifier.getType());
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if (!PropertyUtil.isSimpleGetter(method)) {
                return;
            }
            if (CallToSimpleGetterInClassInspectionBase.this.onlyReportPrivateGetter && !method.hasModifierProperty("private")) {
                return;
            }
            Query<PsiMethod> query = OverridingMethodsSearch.search(method);
            PsiMethod overridingMethod = query.findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspectionBase$CallToSimpleGetterInClassVisitor", "visitMethodCallExpression"));
        }
    }
}

