/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LeafElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.impl.source.tree.LeafElement");
    private static final Key<SoftReference<String>> CACHED_TEXT = Key.create("CACHED_TEXT");
    private static final int TEXT_MATCHES_THRESHOLD = 5;
    private final CharSequence myText;

    protected LeafElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            LeafElement.$$$reportNull$$$0(0);
        }
        super(type);
        this.myText = text;
    }

    @Override
    @NotNull
    public LeafElement clone() {
        LeafElement clone = (LeafElement)super.clone();
        clone.clearCaches();
        LeafElement leafElement = clone;
        if (leafElement == null) {
            LeafElement.$$$reportNull$$$0(1);
        }
        return leafElement;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            LeafElement.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText;
        if (text.length() > 1000 && !(text instanceof String)) {
            String cachedText = (String)SoftReference.dereference(this.getUserData(CACHED_TEXT));
            if (cachedText == null) {
                cachedText = text.toString();
                this.putUserData(CACHED_TEXT, new SoftReference<String>(cachedText));
            }
            String string = cachedText;
            if (string == null) {
                LeafElement.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text.toString();
        if (string == null) {
            LeafElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    public char charAt(int position) {
        return this.myText.charAt(position);
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        int length = this.myText.length();
        if (buffer != null) {
            CharArrayUtil.getChars(this.myText, buffer, start, length);
        }
        return start + length;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.myText.length()];
        CharArrayUtil.getChars(this.myText, buffer, 0);
        if (buffer == null) {
            LeafElement.$$$reportNull$$$0(5);
        }
        return buffer;
    }

    @Override
    public boolean textContains(char c) {
        char[] chars;
        CharSequence text = this.myText;
        int len = text.length();
        if (len > 5 && (chars = CharArrayUtil.fromSequenceWithoutCopying(text)) != null) {
            for (char aChar : chars) {
                if (aChar != c) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (c != text.charAt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            LeafElement.$$$reportNull$$$0(6);
        }
        assert (start >= 0) : start;
        return LeafElement.leafTextMatches(this.myText, buffer, start);
    }

    static int leafTextMatches(@NotNull CharSequence text, @NotNull CharSequence buffer, int start) {
        if (text == null) {
            LeafElement.$$$reportNull$$$0(7);
        }
        if (buffer == null) {
            LeafElement.$$$reportNull$$$0(8);
        }
        assert (start >= 0) : start;
        int length = text.length();
        if (buffer.length() - start < length) {
            return start == 0 ? Integer.MIN_VALUE : -start;
        }
        for (int i = 0; i < length; ++i) {
            int k = i + start;
            if (text.charAt(i) == buffer.charAt(k)) continue;
            return k == 0 ? Integer.MIN_VALUE : -k;
        }
        return start + length;
    }

    @NotNull
    public LeafElement rawReplaceWithText(@NotNull String newText) {
        if (newText == null) {
            LeafElement.$$$reportNull$$$0(9);
        }
        LeafElement newLeaf = ASTFactory.leaf(this.getElementType(), newText);
        this.copyUserDataTo(newLeaf);
        this.rawReplaceWithList(newLeaf);
        newLeaf.clearCaches();
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            LeafElement.$$$reportNull$$$0(10);
        }
        return leafElement;
    }

    @NotNull
    public LeafElement replaceWithText(@NotNull String newText) {
        if (newText == null) {
            LeafElement.$$$reportNull$$$0(11);
        }
        LeafElement newLeaf = ChangeUtil.copyLeafWithText(this, newText);
        this.getTreeParent().replaceChild(this, newLeaf);
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            LeafElement.$$$reportNull$$$0(12);
        }
        return leafElement;
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        return this;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence buf, int start, int end) {
        CharSequence text;
        int len;
        if (buf == null) {
            LeafElement.$$$reportNull$$$0(13);
        }
        if (end - start != (len = (text = this.getChars()).length())) {
            return false;
        }
        if (buf == text) {
            return true;
        }
        if (len > 5 && text instanceof String && buf instanceof String) {
            return ((String)text).regionMatches(0, (String)buf, start, len);
        }
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) == buf.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public ASTNode findChildByType(IElementType type) {
        return null;
    }

    @Override
    public ASTNode findChildByType(IElementType type, @Nullable ASTNode anchor) {
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            LeafElement.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor) {
        if (typesSet == null) {
            LeafElement.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Override
    public int hc() {
        return LeafElement.leafHC(this.getChars());
    }

    static int leafHC(CharSequence text) {
        int len = text.length();
        int hc = 0;
        for (int i = 0; i < len; ++i) {
            hc += text.charAt(i);
        }
        return hc;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return null;
    }

    @Override
    public TreeElement getLastChildNode() {
        return null;
    }

    @Override
    public int getNotCachedLength() {
        return this.myText.length();
    }

    @Override
    public int getCachedLength() {
        return this.getNotCachedLength();
    }

    @Override
    @NotNull
    public ASTNode[] getChildren(TokenSet filter) {
        if (EMPTY_ARRAY == null) {
            LeafElement.$$$reportNull$$$0(16);
        }
        return EMPTY_ARRAY;
    }

    @Override
    public void addChild(@NotNull ASTNode child, ASTNode anchorBefore) {
        if (child == null) {
            LeafElement.$$$reportNull$$$0(17);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            LeafElement.$$$reportNull$$$0(18);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            LeafElement.$$$reportNull$$$0(19);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            LeafElement.$$$reportNull$$$0(20);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            LeafElement.$$$reportNull$$$0(21);
        }
        if (newChild == null) {
            LeafElement.$$$reportNull$$$0(22);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void replaceAllChildrenToChildrenOf(ASTNode anotherParent) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            LeafElement.$$$reportNull$$$0(23);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public PsiElement getPsi() {
        return null;
    }

    @Override
    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            LeafElement.$$$reportNull$$$0(24);
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    static <T extends PsiElement> T getPsi(@NotNull Class<T> clazz, PsiElement element, Logger log) {
        if (clazz == null) {
            LeafElement.$$$reportNull$$$0(25);
        }
        log.assertTrue(clazz.isInstance(element), "unexpected psi class. expected: " + clazz + " got: " + (element == null ? null : element.getClass()));
        return (T)element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/LeafElement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/LeafElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "rawReplaceWithText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: {
                break;
            }
            case 6: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "leafTextMatches";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rawReplaceWithText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

