/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveArrayArgumentToVariableArgMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("PrimitiveArrayArgumentToVarargsMethod" == null) {
            PrimitiveArrayArgumentToVariableArgMethodInspection.$$$reportNull$$$0(0);
        }
        return "PrimitiveArrayArgumentToVarargsMethod";
    }

    @Override
    @Nullable
    public String getAlternativeID() {
        return "PrimitiveArrayArgumentToVariableArgMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("primitive.array.argument.to.var.arg.method.display.name", new Object[0]);
        if (string == null) {
            PrimitiveArrayArgumentToVariableArgMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("primitive.array.argument.to.var.arg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            PrimitiveArrayArgumentToVariableArgMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        PsiType type = (PsiType)infos[1];
        return new DelegatingFix(new AddTypeCastFix(type, argument));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrimitiveArrayArgumentToVariableArgVisitor();
    }

    static boolean isPrimitiveArrayType(PsiType type) {
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        return TypeConversionUtil.isPrimitiveAndNotNull(componentType);
    }

    static boolean isDeepPrimitiveArrayType(PsiType type, PsiSubstitutor substitutor) {
        if (!(type instanceof PsiEllipsisType)) {
            return false;
        }
        PsiType componentType = type.getDeepComponentType();
        PsiType substitute = substitutor.substitute(componentType);
        return TypeConversionUtil.isPrimitiveAndNotNull(substitute.getDeepComponentType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PrimitiveArrayArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private PrimitiveArrayArgumentToVariableArgVisitor() {
        }

        @Override
        public void visitEnumConstant(PsiEnumConstant enumConstant) {
            super.visitEnumConstant(enumConstant);
            this.visitCall(enumConstant);
        }

        @Override
        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            this.visitCall(callExpression);
        }

        private void visitCall(@NotNull PsiCall call) {
            PsiExpressionList argumentList;
            if (call == null) {
                PrimitiveArrayArgumentToVariableArgVisitor.$$$reportNull$$$0(0);
            }
            if ((argumentList = call.getArgumentList()) == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            PsiType argumentType = lastArgument.getType();
            if (!PrimitiveArrayArgumentToVariableArgMethodInspection.isPrimitiveArrayType(argumentType)) {
                return;
            }
            JavaResolveResult result = call.resolveMethodGenerics();
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null || AnnotationUtil.isAnnotated(method, Collections.singletonList("java.lang.invoke.MethodHandle.PolymorphicSignature"))) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != arguments.length) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiEllipsisType parameterType = (PsiEllipsisType)lastParameter.getType();
            if (PrimitiveArrayArgumentToVariableArgMethodInspection.isDeepPrimitiveArrayType(parameterType, result.getSubstitutor())) {
                return;
            }
            this.registerError((PsiElement)lastArgument, lastArgument, parameterType.getComponentType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection$PrimitiveArrayArgumentToVariableArgVisitor", "visitCall"));
        }
    }
}

