/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendsUtilityClassInspection
extends BaseInspection {
    public boolean ignoreUtilityClasses = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.extends.utility.class.display.name", new Object[0]);
        if (string == null) {
            ExtendsUtilityClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        String superClassName = superClass.getName();
        String string = InspectionGadgetsBundle.message("class.extends.utility.class.problem.descriptor", superClassName);
        if (string == null) {
            ExtendsUtilityClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.extends.utility.class.ignore.utility.class.option", new Object[0]), this, "ignoreUtilityClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassExtendsUtilityClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/ExtendsUtilityClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassExtendsUtilityClassVisitor
    extends BaseInspectionVisitor {
        private ClassExtendsUtilityClassVisitor() {
        }

        @Override
        public void visitClass(PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (superClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(superClass)) {
                return;
            }
            if (ExtendsUtilityClassInspection.this.ignoreUtilityClasses && UtilityClassUtil.isUtilityClass(aClass, false)) {
                return;
            }
            this.registerClassError(aClass, superClass);
        }
    }
}

