/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverlyLargePrimitiveArrayInitializerInspection
extends BaseInspection {
    public int m_limit = 64;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("large.initializer.primitive.type.array.display.name", new Object[0]);
        if (string == null) {
            OverlyLargePrimitiveArrayInitializerInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer numElements = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("large.initializer.primitive.type.array.problem.descriptor", numElements);
        if (string == null) {
            OverlyLargePrimitiveArrayInitializerInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("large.initializer.primitive.type.array.maximum.number.of.elements.option", new Object[0]), this, "m_limit");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyLargePrimitiveArrayInitializerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/OverlyLargePrimitiveArrayInitializerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OverlyLargePrimitiveArrayInitializerVisitor
    extends BaseInspectionVisitor {
        private OverlyLargePrimitiveArrayInitializerVisitor() {
        }

        @Override
        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiPrimitiveType)) {
                return;
            }
            int numElements = this.calculateNumElements(expression);
            if (numElements <= OverlyLargePrimitiveArrayInitializerInspection.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression, numElements);
        }

        private int calculateNumElements(PsiExpression expression) {
            if (expression instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayExpression = (PsiArrayInitializerExpression)expression;
                PsiExpression[] initializers = arrayExpression.getInitializers();
                return Arrays.stream(initializers).mapToInt(this::calculateNumElements).sum();
            }
            return 1;
        }
    }
}

