/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.JavaModuleSystemEx;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtilBase;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsConditionalFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeNewOperatorTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteRepeatedInterfaceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.FlipIntersectionSidesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyWithThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.EnclosingLoopMatcherExpression;
import com.intellij.psi.util.EnclosingLoopOrSwitchMatcherExpression;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUtil
extends HighlightUtilBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil");
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final Map<String, Set<String>> ourInterfaceIncompatibleModifiers = new THashMap(7);
    private static final Map<String, Set<String>> ourMethodIncompatibleModifiers = new THashMap(11);
    private static final Map<String, Set<String>> ourFieldIncompatibleModifiers = new THashMap(8);
    private static final Map<String, Set<String>> ourClassIncompatibleModifiers = new THashMap(8);
    private static final Map<String, Set<String>> ourClassInitializerIncompatibleModifiers = new THashMap(1);
    private static final Map<String, Set<String>> ourModuleIncompatibleModifiers = new THashMap(1);
    private static final Map<String, Set<String>> ourRequiresIncompatibleModifiers = new THashMap(2);
    private static final Set<String> ourConstructorNotAllowedModifiers = ContainerUtil.newTroveSet("abstract", "static", "native", "final", "strictfp", "synchronized");
    private static final String SERIAL_PERSISTENT_FIELDS_FIELD_NAME = "serialPersistentFields";
    private static final Pattern FP_LITERAL_PARTS;

    private HighlightUtil() {
    }

    @Nullable
    private static String getIncompatibleModifier(String modifier, @Nullable PsiModifierList modifierList, @NotNull Map<String, Set<String>> incompatibleModifiersHash) {
        if (incompatibleModifiersHash == null) {
            HighlightUtil.$$$reportNull$$$0(0);
        }
        if (modifierList == null) {
            return null;
        }
        PsiElement[] modifiers = modifierList.getChildren();
        int modifierCount = 0;
        for (PsiElement otherModifier : modifiers) {
            if (!Comparing.equal(modifier, otherModifier.getText(), true)) continue;
            ++modifierCount;
        }
        if (modifierCount > 1) {
            return modifier;
        }
        Set<String> incompatibles = incompatibleModifiersHash.get(modifier);
        if (incompatibles == null) {
            return null;
        }
        PsiElement parent = modifierList.getParent();
        boolean level8OrHigher = PsiUtil.isLanguageLevel8OrHigher(modifierList);
        boolean level9OrHigher = PsiUtil.isLanguageLevel9OrHigher(modifierList);
        for (String incompatible : incompatibles) {
            PsiClass containingClass;
            if (level8OrHigher && modifier.equals("static") && incompatible.equals("abstract") || parent instanceof PsiMethod && (level9OrHigher && modifier.equals("private") && incompatible.equals("public") || modifier.equals("static") && incompatible.equals("final") && ((containingClass = ((PsiMethod)parent).getContainingClass()) == null || !containingClass.isInterface()))) continue;
            if (modifierList.hasModifierProperty(incompatible)) {
                return incompatible;
            }
            if (!"abstract".equals(incompatible) || !modifierList.hasExplicitModifier(incompatible)) continue;
            return incompatible;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInstanceOfApplicable(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(1);
        }
        PsiExpression operand = expression.getOperand();
        PsiTypeElement typeElement = expression.getCheckType();
        if (typeElement == null) {
            return null;
        }
        PsiType checkType = typeElement.getType();
        PsiType operandType = operand.getType();
        if (operandType == null) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(operandType) || TypeConversionUtil.isPrimitiveAndNotNull(checkType) || !TypeConversionUtil.areTypesConvertible(operandType, checkType)) {
            String message = JavaErrorMessages.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(checkType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIntersectionInTypeCast(@NotNull PsiTypeCastExpression expression, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        PsiTypeElement castTypeElement;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(2);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            HighlightUtil.$$$reportNull$$$0(4);
        }
        if ((castTypeElement = expression.getCastType()) != null && HighlightUtil.isIntersection(castTypeElement, castTypeElement.getType())) {
            HighlightInfo info = HighlightUtil.checkFeature(expression, Feature.INTERSECTION_CASTS, languageLevel, file);
            if (info != null) {
                return info;
            }
            PsiTypeElement[] conjuncts = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class);
            if (conjuncts != null) {
                Ref differentArgumentsMessage;
                com.intellij.util.containers.hash.HashSet<PsiType> erasures = new com.intellij.util.containers.hash.HashSet<PsiType>(conjuncts.length);
                erasures.add(TypeConversionUtil.erasure(conjuncts[0].getType()));
                ArrayList<PsiTypeElement> conjList = new ArrayList<PsiTypeElement>(Arrays.asList(conjuncts));
                for (int i = 1; i < conjuncts.length; ++i) {
                    PsiTypeElement conjunct = conjuncts[i];
                    PsiType conjType = conjunct.getType();
                    if (conjType instanceof PsiClassType) {
                        PsiClass aClass = ((PsiClassType)conjType).resolve();
                        if (aClass != null && !aClass.isInterface()) {
                            HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(conjunct).descriptionAndTooltip(JavaErrorMessages.message("interface.expected", new Object[0])).create();
                            QuickFixAction.registerQuickFixAction(errorResult, new FlipIntersectionSidesFix(aClass.getName(), conjList, conjunct, castTypeElement), null);
                            return errorResult;
                        }
                    } else {
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(conjunct).descriptionAndTooltip("Unexpected type: class is expected").create();
                    }
                    if (erasures.add(TypeConversionUtil.erasure(conjType))) continue;
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(conjunct).descriptionAndTooltip("Repeated interface").create();
                    QuickFixAction.registerQuickFixAction(highlightInfo, new DeleteRepeatedInterfaceFix(conjunct, conjList), null);
                    return highlightInfo;
                }
                List<PsiType> typeList = ContainerUtil.map(conjList, PsiTypeElement::getType);
                PsiClass sameGenericParameterization = InferenceSession.findParameterizationOfTheSameGenericClass(typeList, arg_0 -> HighlightUtil.lambda$checkIntersectionInTypeCast$0(differentArgumentsMessage = new Ref(), arg_0));
                if (sameGenericParameterization != null) {
                    String message = HighlightUtil.formatClass(sameGenericParameterization) + " cannot be inherited with different arguments: " + (String)differentArgumentsMessage.get();
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
            }
        }
        return null;
    }

    private static boolean isIntersection(PsiTypeElement castTypeElement, PsiType castType) {
        if (castType instanceof PsiIntersectionType) {
            return true;
        }
        return castType instanceof PsiClassType && PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class) != null;
    }

    @Nullable
    static HighlightInfo checkInconvertibleTypeCast(@NotNull PsiTypeCastExpression expression) {
        PsiTypeElement castTypeElement;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(5);
        }
        if ((castTypeElement = expression.getCastType()) == null) {
            return null;
        }
        PsiType castType = castTypeElement.getType();
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            return null;
        }
        PsiType operandType = operand.getType();
        if (operandType != null && !TypeConversionUtil.areTypesConvertible(operandType, castType, PsiUtil.getLanguageLevel(expression)) && !RedundantCastUtil.isInPolymorphicCall(expression)) {
            String message = JavaErrorMessages.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(castType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkVariableExpected(@NotNull PsiExpression expression) {
        PsiExpression lValue;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(6);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            lValue = assignment.getLExpression();
        } else {
            lValue = PsiUtil.isIncrementDecrementOperation(expression) ? ((PsiUnaryExpression)expression).getOperand() : null;
        }
        HighlightInfo errorResult = null;
        if (lValue != null && !TypeConversionUtil.isLValue(lValue)) {
            String description = JavaErrorMessages.message("variable.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(lValue).descriptionAndTooltip(description).create();
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentOperatorApplicable(@NotNull PsiAssignmentExpression assignment) {
        PsiJavaToken operationSign;
        IElementType eqOpSign;
        IElementType opSign;
        if (assignment == null) {
            HighlightUtil.$$$reportNull$$$0(7);
        }
        if ((opSign = TypeConversionUtil.convertEQtoOperation(eqOpSign = (operationSign = assignment.getOperationSign()).getTokenType())) == null) {
            return null;
        }
        PsiType lType = assignment.getLExpression().getType();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return null;
        }
        PsiType rType = rExpression.getType();
        HighlightInfo errorResult = null;
        if (!TypeConversionUtil.isBinaryOperatorApplicable(opSign, lType, rType, true)) {
            String operatorText = operationSign.getText().substring(0, operationSign.getText().length() - 1);
            String message = JavaErrorMessages.message("binary.operator.not.applicable", operatorText, JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(assignment).descriptionAndTooltip(message).create();
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentCompatibleTypes(@NotNull PsiAssignmentExpression assignment) {
        HighlightInfo highlightInfo;
        if (assignment == null) {
            HighlightUtil.$$$reportNull$$$0(8);
        }
        PsiExpression lExpr = assignment.getLExpression();
        PsiExpression rExpr = assignment.getRExpression();
        if (rExpr == null) {
            return null;
        }
        PsiType lType = lExpr.getType();
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return null;
        }
        IElementType sign = assignment.getOperationTokenType();
        if (JavaTokenType.EQ.equals(sign)) {
            highlightInfo = HighlightUtil.checkAssignability(lType, rType, rExpr, assignment);
        } else {
            IElementType opSign = TypeConversionUtil.convertEQtoOperation(sign);
            PsiType type = TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, opSign, true);
            if (type == null || lType == null || TypeConversionUtil.areTypesConvertible(type, lType)) {
                return null;
            }
            highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, type, assignment.getTextRange(), 0);
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createChangeToAppendFix(sign, lType, assignment));
        }
        if (highlightInfo == null) {
            return null;
        }
        HighlightFixUtil.registerChangeVariableTypeFixes(lExpr, rType, rExpr, highlightInfo);
        if (lType != null) {
            HighlightFixUtil.registerChangeVariableTypeFixes(rExpr, lType, lExpr, highlightInfo);
        }
        return highlightInfo;
    }

    private static boolean isCastIntentionApplicable(@NotNull PsiExpression expression, @Nullable PsiType toType) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(9);
        }
        while (expression instanceof PsiTypeCastExpression || expression instanceof PsiParenthesizedExpression) {
            if (expression instanceof PsiTypeCastExpression) {
                expression = ((PsiTypeCastExpression)expression).getOperand();
            }
            if (!(expression instanceof PsiParenthesizedExpression)) continue;
            expression = ((PsiParenthesizedExpression)expression).getExpression();
        }
        if (expression == null) {
            return false;
        }
        PsiType rType = expression.getType();
        return rType != null && toType != null && TypeConversionUtil.areTypesConvertible(rType, toType);
    }

    @Nullable
    static HighlightInfo checkVariableInitializerType(@NotNull PsiVariable variable) {
        int end;
        PsiTypeElement typeElement;
        int start;
        PsiType rType;
        PsiExpression initializer;
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(10);
        }
        if ((initializer = variable.getInitializer()) == null || initializer instanceof PsiArrayInitializerExpression) {
            return null;
        }
        PsiType lType = variable.getType();
        HighlightInfo highlightInfo = HighlightUtil.checkAssignability(lType, rType = initializer.getType(), initializer, new TextRange(start = (typeElement = variable.getTypeElement()) != null ? typeElement.getTextRange().getStartOffset() : variable.getTextRange().getStartOffset(), end = variable.getTextRange().getEndOffset()), 0);
        if (highlightInfo != null) {
            HighlightFixUtil.registerChangeVariableTypeFixes(variable, rType, variable.getInitializer(), highlightInfo);
            HighlightFixUtil.registerChangeVariableTypeFixes(initializer, lType, null, highlightInfo);
        }
        return highlightInfo;
    }

    static HighlightInfo checkVarTypeApplicability(@NotNull PsiVariable variable) {
        PsiTypeElement typeElement;
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(11);
        }
        if ((typeElement = variable.getTypeElement()) != null && typeElement.isInferredType()) {
            PsiElement parent = variable.getParent();
            if (variable instanceof PsiLocalVariable) {
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Cannot infer type: 'var' on variable without initializer").range(typeElement).create();
                }
                if (initializer instanceof PsiFunctionalExpression) {
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Cannot infer type: " + (initializer instanceof PsiLambdaExpression ? "lambda expression" : "method reference") + " requires an explicit target type").range(typeElement).create();
                }
                if (parent instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent).getDeclaredElements().length > 1) {
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("'var' is not allowed in a compound declaration").range(variable).create();
                }
                PsiType lType = variable.getType();
                if (lType instanceof PsiArrayType && !lType.equals(typeElement.getType())) {
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("'var' is not allowed as an element type of an array").range(typeElement).create();
                }
                if (PsiType.NULL.equals(lType)) {
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Cannot infer type: variable initializer is 'null'").range(typeElement).create();
                }
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression, @NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            HighlightUtil.$$$reportNull$$$0(12);
        }
        TextRange textRange = elementToHighlight.getTextRange();
        return HighlightUtil.checkAssignability(lType, rType, expression, textRange, 0);
    }

    @Nullable
    private static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression, @NotNull TextRange textRange, int navigationShift) {
        if (textRange == null) {
            HighlightUtil.$$$reportNull$$$0(13);
        }
        if (lType == rType) {
            return null;
        }
        if (expression == null ? rType == null || lType == null || TypeConversionUtil.isAssignable(lType, rType) : TypeConversionUtil.areTypesAssignmentCompatible(lType, expression)) {
            return null;
        }
        if (rType == null) {
            rType = expression.getType();
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, rType, textRange, navigationShift);
        if (rType != null && expression != null && HighlightUtil.isCastIntentionApplicable(expression, lType)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddTypeCastFix(lType, expression));
        }
        if (expression != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createWrapWithOptionalFix(lType, expression));
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createWrapExpressionFix(lType, expression));
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createWrapWithAdapterFix(lType, expression));
            AddTypeArgumentsConditionalFix.register(highlightInfo, expression, lType);
            HighlightFixUtil.registerCollectionToArrayFixAction(highlightInfo, rType, lType, expression);
            HighlightFixUtil.registerChangeReturnTypeFix(highlightInfo, expression, lType);
        }
        ChangeNewOperatorTypeFix.register(highlightInfo, expression, lType);
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkReturnStatementType(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(14);
        }
        PsiMethod method = null;
        PsiLambdaExpression lambda2 = null;
        PsiElement parent = statement.getParent();
        while (!(parent instanceof PsiFile) && !(parent instanceof PsiClassInitializer)) {
            if (parent instanceof PsiLambdaExpression) {
                lambda2 = (PsiLambdaExpression)parent;
                break;
            }
            if (parent instanceof PsiMethod) {
                method = (PsiMethod)parent;
                break;
            }
            parent = parent.getParent();
        }
        if (parent instanceof PsiCodeFragment) {
            return null;
        }
        HighlightInfo errorResult = null;
        if (method != null || lambda2 == null) {
            if (method == null && !(parent instanceof ServerPageFile)) {
                String description = JavaErrorMessages.message("return.outside.method", new Object[0]);
                errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
            } else {
                PsiType returnType = method != null ? method.getReturnType() : null;
                boolean isMethodVoid = returnType == null || PsiType.VOID.equals(returnType);
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    PsiType valueType = RefactoringChangeUtil.getTypeByExpression(returnValue);
                    if (isMethodVoid) {
                        String description = JavaErrorMessages.message("return.from.void.method", new Object[0]);
                        errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
                        if (valueType != null && method != null) {
                            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true));
                        }
                    } else {
                        TextRange textRange = statement.getTextRange();
                        errorResult = HighlightUtil.checkAssignability(returnType, valueType, returnValue, textRange, returnValue.getStartOffsetInParent());
                        if (errorResult != null && valueType != null) {
                            PsiType erasedValueType;
                            if (!PsiType.VOID.equals(valueType)) {
                                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true));
                            }
                            HighlightFixUtil.registerChangeParameterClassFix(returnType, valueType, errorResult);
                            if (returnType instanceof PsiArrayType && (erasedValueType = TypeConversionUtil.erasure(valueType)) != null && TypeConversionUtil.isAssignable(((PsiArrayType)returnType).getComponentType(), erasedValueType)) {
                                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createSurroundWithArrayFix(null, returnValue));
                            }
                            HighlightFixUtil.registerCollectionToArrayFixAction(errorResult, valueType, returnType, returnValue);
                        }
                    }
                } else if (!isMethodVoid) {
                    String description = JavaErrorMessages.message("missing.return.value", new Object[0]);
                    errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).navigationShift("return".length()).create();
                    QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMethodReturnFix(method, PsiType.VOID, true));
                }
            }
        }
        return errorResult;
    }

    @NotNull
    public static String getUnhandledExceptionsDescriptor(@NotNull Collection<PsiClassType> unhandled) {
        if (unhandled == null) {
            HighlightUtil.$$$reportNull$$$0(15);
        }
        String string = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, null);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getUnhandledExceptionsDescriptor(@NotNull Collection<PsiClassType> unhandled, @Nullable String source) {
        if (unhandled == null) {
            HighlightUtil.$$$reportNull$$$0(17);
        }
        String exceptions = HighlightUtil.formatTypes(unhandled);
        String string = source != null ? JavaErrorMessages.message("unhandled.close.exceptions", exceptions, unhandled.size(), source) : JavaErrorMessages.message("unhandled.exceptions", exceptions, unhandled.size());
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String formatTypes(@NotNull Collection<PsiClassType> unhandled) {
        if (unhandled == null) {
            HighlightUtil.$$$reportNull$$$0(19);
        }
        String string = StringUtil.join(unhandled, JavaHighlightUtil::formatType, ", ");
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    static HighlightInfo checkVariableAlreadyDefined(@NotNull PsiVariable variable) {
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(21);
        }
        if (variable instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        PsiVariable oldVariable = null;
        PsiElement declarationScope = null;
        if (variable instanceof PsiLocalVariable || variable instanceof PsiParameter && ((declarationScope = ((PsiParameter)variable).getDeclarationScope()) instanceof PsiCatchSection || declarationScope instanceof PsiForeachStatement || declarationScope instanceof PsiLambdaExpression)) {
            Object scope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiFile.class, PsiMethod.class, PsiClassInitializer.class, PsiResourceList.class);
            VariablesNotProcessor proc = new VariablesNotProcessor(variable, false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return (var instanceof PsiLocalVariable || var instanceof PsiParameter) && super.check(var, state);
                }
            };
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            PsiScopesUtil.treeWalkUp(proc, identifier, scope);
            if (scope instanceof PsiResourceList && proc.size() == 0) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiFile.class, PsiMethod.class, PsiClassInitializer.class);
                PsiScopesUtil.treeWalkUp(proc, identifier, scope);
            }
            if (proc.size() > 0) {
                oldVariable = proc.getResult(0);
            } else if (declarationScope instanceof PsiLambdaExpression) {
                oldVariable = HighlightUtil.checkSameNames(variable);
            }
        } else if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField fieldByName = aClass.findFieldByName(variable.getName(), false);
            if (fieldByName != null && fieldByName != field) {
                oldVariable = fieldByName;
            }
        } else {
            oldVariable = HighlightUtil.checkSameNames(variable);
        }
        if (oldVariable != null) {
            String description = JavaErrorMessages.message("variable.already.defined", variable.getName());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            VirtualFile vFile = PsiUtilCore.getVirtualFile(identifier);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(identifier);
            if (vFile != null) {
                String path = FileUtil.toSystemIndependentName(vFile.getPath());
                String linkText = "<a href=\"#navigation/" + path + ":" + oldVariable.getTextOffset() + "\">" + variable.getName() + "</a>";
                builder = builder.description(description).escapedToolTip("<html>" + JavaErrorMessages.message("variable.already.defined", linkText) + "</html>");
            } else {
                builder = builder.descriptionAndTooltip(description);
            }
            HighlightInfo highlightInfo = builder.create();
            if (variable instanceof PsiLocalVariable) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createReuseVariableDeclarationFix((PsiLocalVariable)variable));
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createNavigateToAlreadyDeclaredVariableFix((PsiLocalVariable)variable));
            }
            return highlightInfo;
        }
        return null;
    }

    private static PsiVariable checkSameNames(@NotNull PsiVariable variable) {
        PsiElement[] children;
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(22);
        }
        PsiElement scope = variable.getParent();
        for (PsiElement child : children = scope.getChildren()) {
            if (!(child instanceof PsiVariable) || child.equals(variable) || !Objects.equals(variable.getName(), ((PsiVariable)child).getName())) continue;
            return (PsiVariable)child;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnderscore(@NotNull PsiIdentifier identifier, @NotNull LanguageLevel languageLevel) {
        if (identifier == null) {
            HighlightUtil.$$$reportNull$$$0(23);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(24);
        }
        if ("_".equals(identifier.getText())) {
            PsiElement parent;
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                String text2 = JavaErrorMessages.message("underscore.identifier.error", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(identifier).descriptionAndTooltip(text2).create();
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (parent = identifier.getParent()) instanceof PsiParameter && ((PsiParameter)parent).getDeclarationScope() instanceof PsiLambdaExpression) {
                String text3 = JavaErrorMessages.message("underscore.lambda.identifier", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(identifier).descriptionAndTooltip(text3).create();
            }
        }
        return null;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(25);
        }
        String string = HighlightUtil.formatClass(aClass, true);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, boolean fqn) {
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(27);
        }
        String string = PsiFormatUtil.formatClass(aClass, 0x8001 | (fqn ? 2048 : 0));
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String formatField(@NotNull PsiField field) {
        if (field == null) {
            HighlightUtil.$$$reportNull$$$0(29);
        }
        String string = PsiFormatUtil.formatVariable(field, 4097, PsiSubstitutor.EMPTY);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    static HighlightInfo checkUnhandledExceptions(@NotNull PsiElement element, @Nullable TextRange textRange) {
        List<PsiClassType> unhandledExceptions;
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(31);
        }
        if ((unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element)).isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType(element);
        if (highlightType == null) {
            return null;
        }
        if (textRange == null) {
            textRange = element.getTextRange();
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandledExceptions);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(highlightType).range(textRange).descriptionAndTooltip(description).create();
        HighlightFixUtil.registerUnhandledExceptionFixes(element, errorResult, unhandledExceptions);
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkUnhandledCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> unhandled;
        if (resource == null) {
            HighlightUtil.$$$reportNull$$$0(32);
        }
        if ((unhandled = ExceptionUtil.getUnhandledCloserExceptions(resource, null)).isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType(resource);
        if (highlightType == null) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, "auto-closeable resource");
        HighlightInfo highlight = HighlightInfo.newHighlightInfo(highlightType).range(resource).descriptionAndTooltip(description).create();
        HighlightFixUtil.registerUnhandledExceptionFixes(resource, highlight, unhandled);
        return highlight;
    }

    @Nullable
    private static HighlightInfoType getUnhandledExceptionHighlightType(PsiElement element) {
        PsiMethod targetMethod;
        if (FileTypeUtils.isInServerPageFile(element) && (targetMethod = PsiTreeUtil.getParentOfType(element, PsiMethod.class, true, PsiLambdaExpression.class)) instanceof SyntheticElement) {
            return null;
        }
        return HighlightInfoType.UNHANDLED_EXCEPTION;
    }

    @Nullable
    static HighlightInfo checkBreakOutsideLoop(@NotNull PsiBreakStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(33);
        }
        if (statement.getLabelIdentifier() == null && new PsiMatcherImpl(statement).ancestor(EnclosingLoopOrSwitchMatcherExpression.INSTANCE).getElement() == null) {
            String description = JavaErrorMessages.message("break.outside.switch.or.loop", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkContinueOutsideLoop(@NotNull PsiContinueStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(34);
        }
        if (statement.getLabelIdentifier() == null) {
            if (new PsiMatcherImpl(statement).ancestor(EnclosingLoopMatcherExpression.INSTANCE).getElement() == null) {
                String description = JavaErrorMessages.message("continue.outside.loop", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
            }
        } else {
            PsiStatement exitedStatement = statement.findContinuedStatement();
            if (exitedStatement == null) {
                return null;
            }
            if (!(exitedStatement instanceof PsiForStatement || exitedStatement instanceof PsiWhileStatement || exitedStatement instanceof PsiDoWhileStatement || exitedStatement instanceof PsiForeachStatement)) {
                String description = JavaErrorMessages.message("not.loop.label", statement.getLabelIdentifier().getText());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalModifierCombination(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        String modifier;
        String incompatible;
        if (keyword == null) {
            HighlightUtil.$$$reportNull$$$0(35);
        }
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(36);
        }
        if ((incompatible = HighlightUtil.getIncompatibleModifier(modifier = keyword.getText(), modifierList)) != null) {
            String message = JavaErrorMessages.message("incompatible.modifiers", modifier, incompatible);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    @Contract(value="null -> null")
    private static Map<String, Set<String>> getIncompatibleModifierMap(@Nullable PsiElement modifierListOwner) {
        if (modifierListOwner == null || PsiUtilCore.hasErrorElementChild(modifierListOwner)) {
            return null;
        }
        if (modifierListOwner instanceof PsiClass) {
            return ((PsiClass)modifierListOwner).isInterface() ? ourInterfaceIncompatibleModifiers : ourClassIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiMethod) {
            return ourMethodIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiVariable) {
            return ourFieldIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiClassInitializer) {
            return ourClassInitializerIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiJavaModule) {
            return ourModuleIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiRequiresStatement) {
            return ourRequiresIncompatibleModifiers;
        }
        return null;
    }

    @Nullable
    static String getIncompatibleModifier(String modifier, @NotNull PsiModifierList modifierList) {
        Map<String, Set<String>> incompatibleModifierMap;
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(37);
        }
        return (incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierList.getParent())) != null ? HighlightUtil.getIncompatibleModifier(modifier, modifierList, incompatibleModifierMap) : null;
    }

    @Nullable
    static HighlightInfo checkNotAllowedModifier(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        PsiElement modifierOwnerParent;
        PsiElement modifierOwner;
        Map<String, Set<String>> incompatibleModifierMap;
        if (keyword == null) {
            HighlightUtil.$$$reportNull$$$0(38);
        }
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(39);
        }
        if ((incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierOwner = modifierList.getParent())) == null) {
            return null;
        }
        String modifier = keyword.getText();
        Set<String> incompatibles = incompatibleModifierMap.get(modifier);
        PsiElement psiElement = modifierOwnerParent = modifierOwner instanceof PsiMember ? ((PsiMember)modifierOwner).getContainingClass() : modifierOwner.getParent();
        if (modifierOwnerParent == null) {
            modifierOwnerParent = modifierOwner.getParent();
        }
        boolean isAllowed = true;
        if (modifierOwner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)modifierOwner;
            if (aClass.isInterface()) {
                if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiClass;
                }
            } else {
                if ("public".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiJavaFile || modifierOwnerParent instanceof PsiClass && (modifierOwnerParent instanceof PsiSyntheticClass || ((PsiClass)modifierOwnerParent).getQualifiedName() != null);
                } else if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    boolean bl = isAllowed = modifierOwnerParent instanceof PsiClass && ((PsiClass)modifierOwnerParent).getQualifiedName() != null || FileTypeUtils.isInServerPageFile(modifierOwnerParent);
                }
                if (aClass.isEnum()) {
                    isAllowed &= !"final".equals(modifier) && !"abstract".equals(modifier);
                }
                if (aClass.getContainingClass() instanceof PsiAnonymousClass) {
                    isAllowed &= !"private".equals(modifier) && !"protected".equals(modifier);
                }
            }
        } else if (modifierOwner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)modifierOwner;
            isAllowed = !method.isConstructor() || !ourConstructorNotAllowedModifiers.contains(modifier);
            PsiClass containingClass = method.getContainingClass();
            if ((method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && method.isConstructor() && containingClass != null && containingClass.isEnum()) {
                isAllowed = false;
            }
            if ("private".equals(modifier)) {
                isAllowed &= modifierOwnerParent instanceof PsiClass && (!((PsiClass)modifierOwnerParent).isInterface() || PsiUtil.isLanguageLevel9OrHigher(modifierOwner) && !((PsiClass)modifierOwnerParent).isAnnotationType());
            } else if ("strictfp".equals(modifier)) {
                isAllowed &= modifierOwnerParent instanceof PsiClass && (!((PsiClass)modifierOwnerParent).isInterface() || PsiUtil.isLanguageLevel8OrHigher(modifierOwner));
            } else if ("protected".equals(modifier) || "transient".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed &= modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
            if (containingClass != null && containingClass.isInterface()) {
                isAllowed &= !"native".equals(modifier);
            }
            if (containingClass != null && containingClass.isAnnotationType()) {
                isAllowed &= !"static".equals(modifier);
                isAllowed &= !"default".equals(modifier);
            }
        } else if (modifierOwner instanceof PsiField) {
            if ("private".equals(modifier) || "protected".equals(modifier) || "transient".equals(modifier) || "strictfp".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed = modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
        } else if (modifierOwner instanceof PsiClassInitializer) {
            isAllowed = "static".equals(modifier);
        } else if (modifierOwner instanceof PsiLocalVariable || modifierOwner instanceof PsiParameter) {
            isAllowed = "final".equals(modifier);
        } else if (modifierOwner instanceof PsiReceiverParameter) {
            isAllowed = false;
        }
        if (!(isAllowed &= incompatibles != null)) {
            String message = JavaErrorMessages.message("modifier.not.allowed", modifier);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkLiteralExpressionParsingError(@NotNull PsiLiteralExpression expression, LanguageLevel level, PsiFile file) {
        Number number;
        int success;
        Object chars;
        String cleanText;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(40);
        }
        PsiElement literal = expression.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type = ((PsiJavaToken)literal).getTokenType();
        if (type == JavaTokenType.TRUE_KEYWORD || type == JavaTokenType.FALSE_KEYWORD || type == JavaTokenType.NULL_KEYWORD) {
            return null;
        }
        boolean isInt = PsiLiteralExpressionImpl.INTEGER_LITERALS.contains(type);
        boolean isFP = PsiLiteralExpressionImpl.REAL_LITERALS.contains(type);
        String text2 = isInt || isFP ? literal.getText().toLowerCase() : literal.getText();
        Object value = expression.getValue();
        if (level != null && file != null) {
            HighlightInfo info;
            if (isFP && text2.startsWith("0x") && (info = HighlightUtil.checkFeature(expression, Feature.HEX_FP_LITERALS, level, file)) != null) {
                return info;
            }
            if (isInt && text2.startsWith("0b") && (info = HighlightUtil.checkFeature(expression, Feature.BIN_LITERALS, level, file)) != null) {
                return info;
            }
            if ((isInt || isFP) && text2.contains("_")) {
                info = HighlightUtil.checkFeature(expression, Feature.UNDERSCORES, level, file);
                if (info != null) {
                    return info;
                }
                info = HighlightUtil.checkUnderscores(expression, text2, isInt);
                if (info != null) {
                    return info;
                }
            }
        }
        PsiElement parent = expression.getParent();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            cleanText = StringUtil.replace(text2, "_", "");
            if (!cleanText.equals(PsiLiteralExpressionImpl._2_IN_31) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    String message = JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
                if (cleanText.equals("0b")) {
                    String message = JavaErrorMessages.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
                if (value == null || cleanText.equals(PsiLiteralExpressionImpl._2_IN_31)) {
                    String message = JavaErrorMessages.message("integer.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
            }
        } else if (type == JavaTokenType.LONG_LITERAL) {
            cleanText = StringUtil.replace(StringUtil.trimEnd(text2, 'l'), "_", "");
            if (!cleanText.equals(PsiLiteralExpressionImpl._2_IN_63) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    String message = JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
                if (cleanText.equals("0b")) {
                    String message = JavaErrorMessages.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
                if (value == null || cleanText.equals(PsiLiteralExpressionImpl._2_IN_63)) {
                    String message = JavaErrorMessages.message("long.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
            }
        } else if (isFP) {
            if (value == null) {
                String message = JavaErrorMessages.message("malformed.floating.point.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            }
        } else if (type == JavaTokenType.CHARACTER_LITERAL) {
            if (value != null) {
                if (!StringUtil.endsWithChar(text2, '\'')) {
                    String message = JavaErrorMessages.message("unclosed.char.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
            } else {
                if (!StringUtil.startsWithChar(text2, '\'')) {
                    return null;
                }
                if (StringUtil.endsWithChar(text2, '\'')) {
                    if (text2.length() == 1) {
                        String message = JavaErrorMessages.message("illegal.line.end.in.character.literal", new Object[0]);
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                    }
                } else {
                    String message = JavaErrorMessages.message("illegal.line.end.in.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
                text2 = text2.substring(1, text2.length() - 1);
                chars = new StringBuilder();
                success = PsiLiteralExpressionImpl.parseStringCharacters(text2, (StringBuilder)chars, null) ? 1 : 0;
                if (success == 0) {
                    String message = JavaErrorMessages.message("illegal.escape.character.in.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
                int length = ((StringBuilder)chars).length();
                if (length > 1) {
                    String message = JavaErrorMessages.message("too.many.characters.in.character.literal", new Object[0]);
                    HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createConvertToStringLiteralAction());
                    return info;
                }
                if (length == 0) {
                    String message = JavaErrorMessages.message("empty.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
            }
        } else if (type == JavaTokenType.STRING_LITERAL && value == null) {
            String message;
            for (PsiElement element : expression.getChildren()) {
                if (!(element instanceof OuterLanguageElement)) continue;
                return null;
            }
            if (!StringUtil.startsWithChar(text2, '\"')) {
                return null;
            }
            if (StringUtil.endsWithChar(text2, '\"')) {
                if (text2.length() == 1) {
                    message = JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
                }
            } else {
                message = JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            }
            text2 = text2.substring(1, text2.length() - 1);
            chars = new StringBuilder();
            success = PsiLiteralExpressionImpl.parseStringCharacters(text2, (StringBuilder)chars, null) ? 1 : 0;
            if (success == 0) {
                String message2 = JavaErrorMessages.message("illegal.escape.character.in.string.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message2).create();
            }
        }
        if (value instanceof Float) {
            number = (Float)value;
            if (((Float)number).isInfinite()) {
                String message = JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            }
            if (((Float)number).floatValue() == 0.0f && !TypeConversionUtil.isFPZero(text2)) {
                String message = JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            }
        } else if (value instanceof Double) {
            number = (Double)value;
            if (((Double)number).isInfinite()) {
                String message = JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            }
            if ((Double)number == 0.0 && !TypeConversionUtil.isFPZero(text2)) {
                String message = JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkUnderscores(PsiElement expression, String text2, boolean isInt) {
        String[] parts = ArrayUtil.EMPTY_STRING_ARRAY;
        if (isInt) {
            int start = 0;
            if (text2.startsWith("0x") || text2.startsWith("0b")) {
                start += 2;
            }
            int end = text2.length();
            if (StringUtil.endsWithChar(text2, 'l')) {
                --end;
            }
            parts = new String[]{text2.substring(start, end)};
        } else {
            Matcher matcher = FP_LITERAL_PARTS.matcher(text2);
            if (matcher.matches()) {
                parts = new String[matcher.groupCount()];
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    parts[i] = matcher.group(i + 1);
                }
            }
        }
        for (String part : parts) {
            if (part == null || !StringUtil.startsWithChar(part, '_') && !StringUtil.endsWithChar(part, '_')) continue;
            String message = JavaErrorMessages.message("illegal.underscore", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMustBeBoolean(@NotNull PsiExpression expr, PsiType type) {
        PsiElement parent;
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(41);
        }
        if ((parent = expr.getParent()) instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement && expr.equals(((PsiForStatement)parent).getCondition()) || parent instanceof PsiDoWhileStatement && expr.equals(((PsiDoWhileStatement)parent).getCondition())) {
            if (expr.getNextSibling() instanceof PsiErrorElement) {
                return null;
            }
            if (!TypeConversionUtil.isBooleanType(type)) {
                HighlightInfo info = HighlightUtil.createIncompatibleTypeHighlightInfo(PsiType.BOOLEAN, type, expr.getTextRange(), 0);
                if (expr instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expr;
                    PsiMethod method = methodCall.resolveMethod();
                    if (method != null && PsiType.VOID.equals(method.getReturnType())) {
                        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createMethodReturnFix(method, PsiType.BOOLEAN, true));
                    }
                } else if (expr instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expr).getOperationTokenType() == JavaTokenType.EQ) {
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAssignmentToComparisonFix((PsiAssignmentExpression)expr));
                }
                return info;
            }
        }
        return null;
    }

    @NotNull
    static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiTryStatement statement) {
        PsiResourceList resources;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(42);
        }
        HashSet<PsiClassType> thrownTypes = ContainerUtil.newHashSet();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions(tryBlock, tryBlock));
        }
        if ((resources = statement.getResourceList()) != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions(resources, resources));
        }
        HashSet<PsiClassType> hashSet = thrownTypes;
        if (hashSet == null) {
            HighlightUtil.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    @Nullable
    static List<HighlightInfo> checkExceptionThrownInTry(@NotNull PsiParameter parameter, @NotNull Set<PsiClassType> thrownTypes) {
        PsiElement declarationScope;
        if (parameter == null) {
            HighlightUtil.$$$reportNull$$$0(44);
        }
        if (thrownTypes == null) {
            HighlightUtil.$$$reportNull$$$0(45);
        }
        if (!((declarationScope = parameter.getDeclarationScope()) instanceof PsiCatchSection)) {
            return null;
        }
        PsiType caughtType = parameter.getType();
        if (caughtType instanceof PsiClassType) {
            HighlightInfo info = HighlightUtil.checkSimpleCatchParameter(parameter, thrownTypes, (PsiClassType)caughtType);
            return info == null ? null : Collections.singletonList(info);
        }
        if (caughtType instanceof PsiDisjunctionType) {
            return HighlightUtil.checkMultiCatchParameter(parameter, thrownTypes);
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkSimpleCatchParameter(@NotNull PsiParameter parameter, @NotNull Collection<PsiClassType> thrownTypes, @NotNull PsiClassType caughtType) {
        if (parameter == null) {
            HighlightUtil.$$$reportNull$$$0(46);
        }
        if (thrownTypes == null) {
            HighlightUtil.$$$reportNull$$$0(47);
        }
        if (caughtType == null) {
            HighlightUtil.$$$reportNull$$$0(48);
        }
        if (ExceptionUtil.isUncheckedExceptionOrSuperclass(caughtType)) {
            return null;
        }
        for (PsiClassType exceptionType : thrownTypes) {
            if (!exceptionType.isAssignableFrom(caughtType) && !caughtType.isAssignableFrom(exceptionType)) continue;
            return null;
        }
        String description = JavaErrorMessages.message("exception.never.thrown.try", JavaHighlightUtil.formatType(caughtType));
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parameter).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createDeleteCatchFix(parameter));
        return errorResult;
    }

    @NotNull
    private static List<HighlightInfo> checkMultiCatchParameter(@NotNull PsiParameter parameter, @NotNull Collection<PsiClassType> thrownTypes) {
        if (parameter == null) {
            HighlightUtil.$$$reportNull$$$0(49);
        }
        if (thrownTypes == null) {
            HighlightUtil.$$$reportNull$$$0(50);
        }
        List<PsiTypeElement> typeElements = PsiUtil.getParameterTypeElements(parameter);
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(typeElements.size());
        for (PsiTypeElement typeElement : typeElements) {
            PsiType catchType = typeElement.getType();
            if (catchType instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)catchType)) continue;
            boolean used = false;
            for (PsiClassType exceptionType : thrownTypes) {
                if (!exceptionType.isAssignableFrom(catchType) && !catchType.isAssignableFrom(exceptionType)) continue;
                used = true;
                break;
            }
            if (used) continue;
            String description = JavaErrorMessages.message("exception.never.thrown.try", JavaHighlightUtil.formatType(catchType));
            HighlightInfo highlight = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlight, QUICK_FIX_FACTORY.createDeleteMultiCatchFix(typeElement));
            highlights.add(highlight);
        }
        ArrayList<HighlightInfo> arrayList = highlights;
        if (arrayList == null) {
            HighlightUtil.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @Nullable
    static Collection<HighlightInfo> checkWithImprovedCatchAnalysis(@NotNull PsiParameter parameter, @NotNull Collection<PsiClassType> thrownInTryStatement, @NotNull PsiFile containingFile) {
        PsiElement scope;
        if (parameter == null) {
            HighlightUtil.$$$reportNull$$$0(52);
        }
        if (thrownInTryStatement == null) {
            HighlightUtil.$$$reportNull$$$0(53);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(54);
        }
        if (!((scope = parameter.getDeclarationScope()) instanceof PsiCatchSection)) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        PsiCatchSection[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int idx = ArrayUtilRt.find(allCatchSections, catchSection);
        if (idx <= 0) {
            return null;
        }
        HashSet<PsiClassType> thrownTypes = ContainerUtil.newHashSet(thrownInTryStatement);
        PsiManager manager = containingFile.getManager();
        GlobalSearchScope parameterResolveScope = parameter.getResolveScope();
        thrownTypes.add(PsiType.getJavaLangError(manager, parameterResolveScope));
        thrownTypes.add(PsiType.getJavaLangRuntimeException(manager, parameterResolveScope));
        ArrayList<HighlightInfo> result = ContainerUtil.newArrayList();
        List<PsiTypeElement> parameterTypeElements = PsiUtil.getParameterTypeElements(parameter);
        boolean isMultiCatch = parameterTypeElements.size() > 1;
        for (PsiTypeElement catchTypeElement : parameterTypeElements) {
            List<PsiClassType> caught;
            PsiType catchType = catchTypeElement.getType();
            if (ExceptionUtil.isGeneralExceptionType(catchType) || (caught = ContainerUtil.findAll(thrownTypes, type -> catchType.isAssignableFrom((PsiType)type) || type.isAssignableFrom(catchType))).isEmpty()) continue;
            HashSet<PsiClassType> caughtCopy = ContainerUtil.newHashSet(caught);
            block1: for (int i = 0; i < idx; ++i) {
                PsiParameter prevCatchParameter = allCatchSections[i].getParameter();
                if (prevCatchParameter == null) continue;
                for (PsiTypeElement prevCatchTypeElement : PsiUtil.getParameterTypeElements(prevCatchParameter)) {
                    PsiType prevCatchType = prevCatchTypeElement.getType();
                    caught.removeIf(prevCatchType::isAssignableFrom);
                    if (!caught.isEmpty()) continue;
                    continue block1;
                }
            }
            if (!caught.isEmpty()) continue;
            String message = JavaErrorMessages.message("exception.already.caught.warn", HighlightUtil.formatTypes(caughtCopy), caughtCopy.size());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(catchSection).descriptionAndTooltip(message).create();
            if (isMultiCatch) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteMultiCatchFix(catchTypeElement));
            } else {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteCatchFix(parameter));
            }
            result.add(highlightInfo);
        }
        return result;
    }

    @Nullable
    static HighlightInfo checkNotAStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(55);
        }
        if (!PsiUtil.isStatement(statement) && !PsiUtilCore.hasErrorElementChild(statement)) {
            boolean isDeclarationNotAllowed = false;
            if (statement instanceof PsiDeclarationStatement) {
                PsiElement parent = statement.getParent();
                isDeclarationNotAllowed = parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement;
            }
            String description = JavaErrorMessages.message(isDeclarationNotAllowed ? "declaration.not.allowed" : "not.a.statement", new Object[0]);
            HighlightInfo error = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
            if (statement instanceof PsiExpressionStatement) {
                QuickFixAction.registerQuickFixAction(error, QuickFixFactory.getInstance().createDeleteSideEffectAwareFix((PsiExpressionStatement)statement));
            }
            return error;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkSwitchSelectorType(@NotNull PsiSwitchStatement statement, @NotNull LanguageLevel level) {
        PsiExpression expression;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(56);
        }
        if (level == null) {
            HighlightUtil.$$$reportNull$$$0(57);
        }
        if ((expression = statement.getExpression()) == null) {
            return null;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return null;
        }
        SelectorKind kind = HighlightUtil.getSwitchSelectorKind(type);
        if (kind == SelectorKind.INT) {
            return null;
        }
        LanguageLevel requiredLevel = null;
        if (kind == SelectorKind.ENUM) {
            requiredLevel = LanguageLevel.JDK_1_5;
        }
        if (kind == SelectorKind.STRING) {
            requiredLevel = LanguageLevel.JDK_1_7;
        }
        if (kind == null || requiredLevel != null && !level.isAtLeast(requiredLevel)) {
            boolean is7 = level.isAtLeast(LanguageLevel.JDK_1_7);
            String expected = JavaErrorMessages.message(is7 ? "valid.switch.17.selector.types" : "valid.switch.selector.types", new Object[0]);
            String message = JavaErrorMessages.message("incompatible.types", expected, JavaHighlightUtil.formatType(type));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createConvertSwitchToIfIntention(statement));
            if (PsiType.LONG.equals(type) || PsiType.FLOAT.equals(type) || PsiType.DOUBLE.equals(type)) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddTypeCastFix(PsiType.INT, expression));
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createWrapWithAdapterFix(PsiType.INT, expression));
            }
            if (requiredLevel != null) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(requiredLevel));
            }
            return info;
        }
        PsiClass member = PsiUtil.resolveClassInClassTypeOnly(type);
        if (member != null && !PsiUtil.isAccessible(member.getProject(), member, expression, null)) {
            String className = PsiFormatUtil.formatClass(member, 2049);
            String message = JavaErrorMessages.message("inaccessible.type", className);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    private static SelectorKind getSwitchSelectorKind(@NotNull PsiType type) {
        if (type == null) {
            HighlightUtil.$$$reportNull$$$0(58);
        }
        if (TypeConversionUtil.getTypeRank(type) <= 4) {
            return SelectorKind.INT;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                return SelectorKind.ENUM;
            }
            if (Comparing.strEqual(psiClass.getQualifiedName(), "java.lang.String")) {
                return SelectorKind.STRING;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPolyadicOperatorApplicable(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(59);
        }
        PsiExpression[] operands = expression.getOperands();
        PsiType lType = operands[0].getType();
        IElementType operationSign = expression.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            PsiType rType = operand.getType();
            if (!TypeConversionUtil.isBinaryOperatorApplicable(operationSign, lType, rType, false)) {
                PsiJavaToken token = expression.getTokenBeforeOperand(operand);
                assert (token != null) : expression;
                String message = JavaErrorMessages.message("binary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, operationSign, true);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnaryOperatorApplicable(@Nullable PsiJavaToken token, @Nullable PsiExpression expression) {
        if (token != null && expression != null && !TypeConversionUtil.isUnaryOperatorApplicable(token, expression)) {
            PsiType type = expression.getType();
            if (type == null) {
                return null;
            }
            String message = JavaErrorMessages.message("unary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(type));
            PsiElement parentExpr = token.getParent();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parentExpr).descriptionAndTooltip(message).create();
            if (parentExpr instanceof PsiPrefixExpression && token.getTokenType() == JavaTokenType.EXCL) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createNegationBroadScopeFix((PsiPrefixExpression)parentExpr));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkThisOrSuperExpressionInIllegalContext(@NotNull PsiExpression expr, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull LanguageLevel languageLevel) {
        PsiMethod psiMethod;
        PsiClass classT;
        PsiClass aClass;
        PsiElement resolved;
        PsiElement parent;
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(60);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(61);
        }
        if (expr instanceof PsiSuperExpression && !((parent = expr.getParent()) instanceof PsiReferenceExpression)) {
            int o = expr.getTextRange().getEndOffset();
            String description = JavaErrorMessages.message("dot.expected.after.super.or.this", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(o, o + 1).descriptionAndTooltip(description).create();
        }
        if (qualifier != null) {
            resolved = qualifier.advancedResolve(true).getElement();
            if (resolved != null && !(resolved instanceof PsiClass)) {
                String description = JavaErrorMessages.message("class.expected", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(description).create();
            }
            aClass = (PsiClass)resolved;
        } else {
            aClass = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class);
            if (aClass instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor(((PsiAnonymousClass)aClass).getArgumentList(), expr, false)) {
                aClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, true);
            }
        }
        if (aClass == null) {
            return null;
        }
        if (!InheritanceUtil.hasEnclosingInstanceInScope(aClass, (PsiElement)expr, false, false)) {
            if (!HighlightUtil.resolvesToImmediateSuperInterface(expr, qualifier, aClass, languageLevel)) {
                return HighlightClassUtil.reportIllegalEnclosingUsage(expr, null, aClass, expr);
            }
            if (expr instanceof PsiSuperExpression && (resolved = ((PsiReferenceExpression)expr.getParent()).resolve()) instanceof PsiField) {
                String description = JavaErrorMessages.message("is.not.an.enclosing.class", HighlightUtil.formatClass(aClass));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expr).descriptionAndTooltip(description).create();
            }
        }
        if (qualifier != null && aClass.isInterface() && expr instanceof PsiSuperExpression && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (classT = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class)) != null) {
            PsiElement parent2 = expr.getParent();
            PsiElement resolved2 = parent2 instanceof PsiReferenceExpression ? ((PsiReferenceExpression)parent2).resolve() : null;
            PsiClass containingClass = ObjectUtils.notNull(resolved2 instanceof PsiMethod ? ((PsiMethod)resolved2).getContainingClass() : null, aClass);
            for (PsiClass superClass : classT.getSupers()) {
                if (!superClass.isInheritor(containingClass, true)) continue;
                String cause = null;
                if (superClass.isInheritor(aClass, true) && superClass.isInterface()) {
                    cause = "redundant interface " + HighlightUtil.format(containingClass) + " is extended by ";
                } else if (resolved2 instanceof PsiMethod && MethodSignatureUtil.findMethodBySuperMethod(superClass, (PsiMethod)resolved2, true) != resolved2) {
                    cause = "method " + ((PsiMethod)resolved2).getName() + " is overridden in ";
                }
                if (cause == null) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(JavaErrorMessages.message("bad.qualifier.in.super.method.reference", cause + HighlightUtil.formatClass(superClass))).create();
            }
            if (!classT.isInheritor(aClass, false)) {
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.format(aClass))).create();
            }
        }
        if (expr instanceof PsiThisExpression && ((psiMethod = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class)) == null || psiMethod.getContainingClass() != aClass && !HighlightUtil.isInsideDefaultMethod(psiMethod, aClass))) {
            PsiClass parentClass;
            if (aClass.isInterface()) {
                return HighlightUtil.thisNotFoundInInterfaceInfo(expr);
            }
            if (aClass instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor(((PsiAnonymousClass)aClass).getArgumentList(), expr, true) && (parentClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, true)) != null && parentClass.isInterface()) {
                return HighlightUtil.thisNotFoundInInterfaceInfo(expr);
            }
        }
        return null;
    }

    static HighlightInfo checkUnqualifiedSuperInDefaultMethod(@NotNull LanguageLevel languageLevel, @NotNull PsiReferenceExpression expr, PsiExpression qualifier) {
        PsiMethod method;
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(62);
        }
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(63);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && qualifier instanceof PsiSuperExpression && (method = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class)) != null && method.hasModifierProperty("default") && ((PsiSuperExpression)qualifier).getQualifier() == null) {
            String description = JavaErrorMessages.message("unqualified.super.disallowed", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expr).descriptionAndTooltip(description).create();
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifier, info);
            return info;
        }
        return null;
    }

    private static boolean isInsideDefaultMethod(PsiMethod method, PsiClass aClass) {
        while (method != null && method.getContainingClass() != aClass) {
            method = PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, true);
        }
        return method != null && method.hasModifierProperty("default");
    }

    private static HighlightInfo thisNotFoundInInterfaceInfo(@NotNull PsiExpression expr) {
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(64);
        }
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expr).descriptionAndTooltip("Cannot find symbol variable this").create();
    }

    private static boolean resolvesToImmediateSuperInterface(@NotNull PsiExpression expr, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull PsiClass aClass, @NotNull LanguageLevel languageLevel) {
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(65);
        }
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(66);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(67);
        }
        if (!(expr instanceof PsiSuperExpression) || qualifier == null || !languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        PsiType superType = expr.getType();
        if (!(superType instanceof PsiClassType)) {
            return false;
        }
        PsiClass superClass = ((PsiClassType)superType).resolve();
        return superClass != null && aClass.equals(superClass) && PsiUtil.getEnclosingStaticElement(expr, PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class)) == null;
    }

    @NotNull
    static String staticContextProblemDescription(@NotNull PsiElement refElement) {
        if (refElement == null) {
            HighlightUtil.$$$reportNull$$$0(68);
        }
        String type = ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(JavaLanguage.INSTANCE)).getType(refElement);
        String name = HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY);
        String string = JavaErrorMessages.message("non.static.symbol.referenced.from.static.context", type, name);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    @NotNull
    static String accessProblemDescription(@NotNull PsiElement ref, @NotNull PsiElement resolved, @NotNull JavaResolveResult result) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(70);
        }
        if (resolved == null) {
            HighlightUtil.$$$reportNull$$$0(71);
        }
        if (result == null) {
            HighlightUtil.$$$reportNull$$$0(72);
        }
        String string = (String)HighlightUtil.accessProblemDescriptionAndFixes((PsiElement)ref, (PsiElement)resolved, (JavaResolveResult)result).first;
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    static Pair<String, List<IntentionAction>> accessProblemDescriptionAndFixes(@NotNull PsiElement ref, @NotNull PsiElement resolved, @NotNull JavaResolveResult result) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(74);
        }
        if (resolved == null) {
            HighlightUtil.$$$reportNull$$$0(75);
        }
        if (result == null) {
            HighlightUtil.$$$reportNull$$$0(76);
        }
        assert (resolved instanceof PsiModifierListOwner) : resolved;
        PsiModifierListOwner refElement = (PsiModifierListOwner)resolved;
        String symbolName = HighlightMessageUtil.getSymbolName(refElement, result.getSubstitutor());
        if (refElement.hasModifierProperty("private")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            Pair<String, Object> pair = Pair.pair(JavaErrorMessages.message("private.symbol", symbolName, containerName), null);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(77);
            }
            return pair;
        }
        if (refElement.hasModifierProperty("protected")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            Pair<String, Object> pair = Pair.pair(JavaErrorMessages.message("protected.symbol", symbolName, containerName), null);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(78);
            }
            return pair;
        }
        PsiClass packageLocalClass = HighlightFixUtil.getPackageLocalClassInTheMiddle(ref);
        if (packageLocalClass != null) {
            refElement = packageLocalClass;
            symbolName = HighlightMessageUtil.getSymbolName(refElement, result.getSubstitutor());
        }
        if (refElement.hasModifierProperty("packageLocal") || packageLocalClass != null) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            Pair<String, Object> pair = Pair.pair(JavaErrorMessages.message("package.local.symbol", symbolName, containerName), null);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(79);
            }
            return pair;
        }
        String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
        JavaModuleSystemEx.ErrorWithFixes problem = HighlightUtil.checkModuleAccess(resolved, ref, symbolName, containerName);
        if (problem != null) {
            Pair<String, List<IntentionAction>> pair = Pair.pair(problem.message, problem.fixes);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(80);
            }
            return pair;
        }
        Pair<String, Object> pair = Pair.pair(JavaErrorMessages.message("visibility.access.problem", symbolName, containerName), null);
        if (pair == null) {
            HighlightUtil.$$$reportNull$$$0(81);
        }
        return pair;
    }

    private static JavaModuleSystemEx.ErrorWithFixes checkModuleAccess(PsiElement target, PsiElement place, String symbolName, String containerName) {
        JavaModuleSystemEx.ErrorWithFixes error = null;
        for (JavaModuleSystem moduleSystem : JavaModuleSystem.EP_NAME.getExtensions()) {
            if (moduleSystem instanceof JavaModuleSystemEx) {
                error = HighlightUtil.checkAccess((JavaModuleSystemEx)moduleSystem, target, place);
            } else if (!HighlightUtil.isAccessible(moduleSystem, target, place)) {
                String message = JavaErrorMessages.message("visibility.module.access.problem", symbolName, containerName, moduleSystem.getName());
                error = new JavaModuleSystemEx.ErrorWithFixes(message);
            }
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private static JavaModuleSystemEx.ErrorWithFixes checkAccess(JavaModuleSystemEx system, PsiElement target, PsiElement place) {
        if (target instanceof PsiClass) {
            return system.checkAccess((PsiClass)target, place);
        }
        if (target instanceof PsiPackage) {
            return system.checkAccess((PsiPackage)target, place);
        }
        return null;
    }

    private static boolean isAccessible(JavaModuleSystem system, PsiElement target, PsiElement place) {
        if (target instanceof PsiClass) {
            return system.isAccessible((PsiClass)target, place);
        }
        if (target instanceof PsiPackage) {
            return system.isAccessible((PsiPackage)target, place);
        }
        return true;
    }

    private static PsiElement getContainer(PsiModifierListOwner refElement) {
        for (ContainerProvider provider : ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    private static String getContainerName(PsiModifierListOwner refElement, PsiSubstitutor substitutor) {
        PsiElement container = HighlightUtil.getContainer(refElement);
        return container == null ? "?" : HighlightMessageUtil.getSymbolName(container, substitutor);
    }

    @Nullable
    static HighlightInfo checkValidArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression) {
        PsiExpression arrayExpression;
        PsiType arrayExpressionType;
        if (arrayAccessExpression == null) {
            HighlightUtil.$$$reportNull$$$0(82);
        }
        if ((arrayExpressionType = (arrayExpression = arrayAccessExpression.getArrayExpression()).getType()) != null && !(arrayExpressionType instanceof PsiArrayType)) {
            String description = JavaErrorMessages.message("array.type.expected", JavaHighlightUtil.formatType(arrayExpressionType));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(arrayExpression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createReplaceWithListAccessFix(arrayAccessExpression));
            return info;
        }
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        return indexExpression != null ? HighlightUtil.checkAssignability(PsiType.INT, indexExpression.getType(), indexExpression, indexExpression) : null;
    }

    @Nullable
    static HighlightInfo checkCatchParameterIsThrowable(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            HighlightUtil.$$$reportNull$$$0(83);
        }
        if (parameter.getDeclarationScope() instanceof PsiCatchSection) {
            PsiType type = parameter.getType();
            return HighlightUtil.checkMustBeThrowable(type, parameter, true);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkTryResourceIsAutoCloseable(@NotNull PsiResourceListElement resource) {
        PsiType type;
        if (resource == null) {
            HighlightUtil.$$$reportNull$$$0(84);
        }
        if ((type = resource.getType()) == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(resource.getProject()).getElementFactory();
        PsiClassType autoCloseable = factory.createTypeByFQClassName("java.lang.AutoCloseable", resource.getResolveScope());
        if (TypeConversionUtil.isAssignable(autoCloseable, type)) {
            return null;
        }
        return HighlightUtil.createIncompatibleTypeHighlightInfo(autoCloseable, type, resource.getTextRange(), 0);
    }

    @Nullable
    static HighlightInfo checkResourceVariableIsFinal(@NotNull PsiResourceExpression resource) {
        PsiExpression expression;
        if (resource == null) {
            HighlightUtil.$$$reportNull$$$0(85);
        }
        if ((expression = resource.getExpression()) instanceof PsiThisExpression) {
            return null;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression).resolve();
            if (target == null) {
                return null;
            }
            if (target instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)target;
                PsiModifierList modifierList = variable.getModifierList();
                if (modifierList != null && modifierList.hasModifierProperty("final")) {
                    return null;
                }
                if (!(variable instanceof PsiField) && HighlightControlFlowUtil.isEffectivelyFinal(variable, resource, (PsiJavaCodeReferenceElement)((Object)expression))) {
                    return null;
                }
            }
            String text2 = JavaErrorMessages.message("resource.variable.must.be.final", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(text2).create();
        }
        String text3 = JavaErrorMessages.message("declaration.or.variable.expected", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(text3).create();
    }

    @Nullable
    static Collection<HighlightInfo> checkArrayInitializer(PsiExpression initializer, PsiType type) {
        PsiExpression[] initializers;
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return null;
        }
        if (!(type instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        PsiArrayInitializerExpression arrayInitializer = (PsiArrayInitializerExpression)initializer;
        boolean arrayTypeFixChecked = false;
        VariableArrayTypeFix fix = null;
        ArrayList<HighlightInfo> result = ContainerUtil.newArrayList();
        for (PsiExpression expression : initializers = arrayInitializer.getInitializers()) {
            HighlightInfo info = HighlightUtil.checkArrayInitializerCompatibleTypes(expression, componentType);
            if (info == null) continue;
            result.add(info);
            if (!arrayTypeFixChecked) {
                PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                fix = checkResult != null ? VariableArrayTypeFix.createFix(arrayInitializer, checkResult) : null;
                arrayTypeFixChecked = true;
            }
            if (fix == null) continue;
            QuickFixAction.registerQuickFixAction(info, new LocalQuickFixOnPsiElementAsIntentionAdapter(fix));
        }
        return result;
    }

    @Nullable
    private static HighlightInfo checkArrayInitializerCompatibleTypes(@NotNull PsiExpression initializer, PsiType componentType) {
        PsiType initializerType;
        if (initializer == null) {
            HighlightUtil.$$$reportNull$$$0(86);
        }
        if ((initializerType = initializer.getType()) == null) {
            String description = JavaErrorMessages.message("illegal.initializer", JavaHighlightUtil.formatType(componentType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(initializer).descriptionAndTooltip(description).create();
        }
        PsiExpression expression = initializer instanceof PsiArrayInitializerExpression ? null : initializer;
        return HighlightUtil.checkAssignability(componentType, initializerType, expression, initializer);
    }

    @Nullable
    static HighlightInfo checkExpressionRequired(@NotNull PsiReferenceExpression expression, @NotNull JavaResolveResult resultForIncompleteCode) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(87);
        }
        if (resultForIncompleteCode == null) {
            HighlightUtil.$$$reportNull$$$0(88);
        }
        if (expression.getNextSibling() instanceof PsiErrorElement) {
            return null;
        }
        PsiElement resolved = resultForIncompleteCode.getElement();
        if (resolved == null || resolved instanceof PsiVariable) {
            return null;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression) {
            return null;
        }
        String description = JavaErrorMessages.message("expression.expected", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes(expression, new QuickFixActionRegistrarImpl(info));
        return info;
    }

    @Nullable
    static HighlightInfo checkArrayInitializerApplicable(@NotNull PsiArrayInitializerExpression expression) {
        PsiElement parent;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(89);
        }
        if ((parent = expression.getParent()) instanceof PsiVariable) {
            boolean disabledForInferredType;
            PsiVariable variable = (PsiVariable)parent;
            PsiTypeElement typeElement = variable.getTypeElement();
            boolean bl = disabledForInferredType = typeElement == null || !typeElement.isInferredType();
            if (disabledForInferredType && variable.getType() instanceof PsiArrayType) {
                return null;
            }
        } else if (parent instanceof PsiNewExpression || parent instanceof PsiArrayInitializerExpression) {
            return null;
        }
        String description = JavaErrorMessages.message("array.initializer.not.allowed", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddNewArrayExpressionFix(expression));
        return info;
    }

    @Nullable
    static HighlightInfo checkCaseStatement(@NotNull PsiSwitchLabelStatement statement) {
        PsiStatement[] statements;
        HighlightInfo highlightInfo;
        PsiSwitchStatement switchStatement;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(90);
        }
        if ((switchStatement = statement.getEnclosingSwitchStatement()) == null) {
            String description = JavaErrorMessages.message("case.statement.outside.switch", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
        }
        if (switchStatement.getBody() == null) {
            return null;
        }
        PsiExpression switchExpression = switchStatement.getExpression();
        PsiType switchType = switchExpression == null ? PsiType.INT : switchExpression.getType();
        PsiExpression caseValue = statement.getCaseValue();
        if (caseValue != null && switchExpression != null && (highlightInfo = HighlightUtil.checkAssignability(switchType, caseValue.getType(), caseValue, caseValue)) != null) {
            return highlightInfo;
        }
        Object value = null;
        boolean isEnumSwitch = false;
        if (!statement.isDefaultCase() && caseValue != null) {
            PsiElement element;
            if (caseValue instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)caseValue).resolve()) instanceof PsiEnumConstant) {
                isEnumSwitch = true;
                value = ((PsiEnumConstant)element).getName();
                if (((PsiReferenceExpression)caseValue).getQualifier() != null) {
                    String message = JavaErrorMessages.message("qualified.enum.constant.in.switch", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(caseValue).descriptionAndTooltip(message).create();
                }
            }
            if (!isEnumSwitch) {
                value = ConstantExpressionUtil.computeCastTo(caseValue, switchType);
            }
            if (value == null) {
                String description = JavaErrorMessages.message("constant.expression.required", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(caseValue).descriptionAndTooltip(description).create();
            }
        }
        for (PsiStatement st : statements = switchStatement.getBody().getStatements()) {
            PsiElement element;
            PsiSwitchLabelStatement labelStatement;
            if (st == statement || !(st instanceof PsiSwitchLabelStatement) || (labelStatement = (PsiSwitchLabelStatement)st).isDefaultCase() != statement.isDefaultCase()) continue;
            PsiExpression caseExpr = labelStatement.getCaseValue();
            if (!isEnumSwitch || !(caseExpr instanceof PsiReferenceExpression) ? !TypeConversionUtil.areTypesAssignmentCompatible(switchType, caseExpr) || !Comparing.equal(ConstantExpressionUtil.computeCastTo(caseExpr, switchType), value) : !((element = ((PsiReferenceExpression)caseExpr).resolve()) instanceof PsiEnumConstant) || !Comparing.equal(((PsiEnumConstant)element).getName(), value)) continue;
            String description = statement.isDefaultCase() ? JavaErrorMessages.message("duplicate.default.switch.label", new Object[0]) : JavaErrorMessages.message("duplicate.switch.label", value);
            PsiElement element2 = value == null ? statement : caseValue;
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element2).descriptionAndTooltip(description).create();
        }
        PsiElement lastChild = statement.getLastChild();
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            lastChild = lastChild.getPrevSibling();
        }
        if (!PsiUtil.isJavaToken(lastChild, JavaTokenType.COLON)) {
            int start = statement.getTextRange().getEndOffset();
            int end = statement.getTextRange().getEndOffset() + 1;
            String description = JavaErrorMessages.message("switch.colon.expected.after.case.label", new Object[0]);
            CharSequence chars = statement.getContainingFile().getViewProvider().getContents();
            boolean isAfterEndOfLine = end >= chars.length() || chars.charAt(start) == '\n' || chars.charAt(start) == '\r';
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description);
            if (isAfterEndOfLine) {
                builder.endOfLine();
            }
            return builder.create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression, @NotNull PsiField referencedField) {
        Boolean isIllegalForwardReference;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(91);
        }
        if (referencedField == null) {
            HighlightUtil.$$$reportNull$$$0(92);
        }
        if ((isIllegalForwardReference = HighlightUtil.isIllegalForwardReferenceToField(expression, referencedField, false)) == null) {
            return null;
        }
        String description = JavaErrorMessages.message(isIllegalForwardReference != false ? "illegal.forward.reference" : "illegal.self.reference", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
    }

    public static Boolean isIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression, @NotNull PsiField referencedField, boolean acceptQualified) {
        boolean inStaticContext;
        PsiClass containingClass;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(93);
        }
        if (referencedField == null) {
            HighlightUtil.$$$reportNull$$$0(94);
        }
        if ((containingClass = referencedField.getContainingClass()) == null) {
            return null;
        }
        if (expression.getContainingFile() != referencedField.getContainingFile()) {
            return null;
        }
        if (expression.getTextRange().getStartOffset() >= referencedField.getTextRange().getEndOffset()) {
            return null;
        }
        if (!acceptQualified && expression.getQualifierExpression() != null) {
            return null;
        }
        PsiField initField = HighlightUtil.findEnclosingFieldInitializer(expression);
        PsiClassInitializer classInitializer = HighlightUtil.findParentClassInitializer(expression);
        if (initField == null && classInitializer == null) {
            return null;
        }
        boolean isStaticClassInitializer = classInitializer != null && classInitializer.hasModifierProperty("static");
        boolean isStaticInitField = initField != null && initField.hasModifierProperty("static");
        boolean bl = inStaticContext = isStaticInitField || isStaticClassInitializer;
        if (!inStaticContext && referencedField.hasModifierProperty("static")) {
            return null;
        }
        if (PsiUtil.isOnAssignmentLeftHand(expression) && !PsiUtil.isAccessedForReading(expression)) {
            return null;
        }
        if (!containingClass.getManager().areElementsEquivalent(containingClass, PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class))) {
            return null;
        }
        return initField != referencedField;
    }

    @Nullable
    static PsiField findEnclosingFieldInitializer(@Nullable PsiElement element) {
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                PsiField field = (PsiField)parent;
                if (element == field.getInitializer()) {
                    return field;
                }
                if (field instanceof PsiEnumConstant && element == ((PsiEnumConstant)field).getArgumentList()) {
                    return field;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    @Nullable
    private static PsiClassInitializer findParentClassInitializer(@Nullable PsiElement element) {
        while (element != null) {
            if (element instanceof PsiClassInitializer) {
                return (PsiClassInitializer)element;
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalType(@Nullable PsiTypeElement typeElement) {
        PsiClass aClass;
        if (typeElement == null || typeElement.getParent() instanceof PsiTypeElement) {
            return null;
        }
        if (PsiUtil.isInsideJavadocComment(typeElement)) {
            return null;
        }
        PsiType type = typeElement.getType();
        PsiType componentType = type.getDeepComponentType();
        if (componentType instanceof PsiClassType && (aClass = PsiUtil.resolveClassInType(componentType)) == null) {
            String canonicalText = type.getCanonicalText();
            String description = JavaErrorMessages.message("unknown.class", canonicalText);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalVoidType(@NotNull PsiKeyword type) {
        if (type == null) {
            HighlightUtil.$$$reportNull$$$0(95);
        }
        if (!"void".equals(type.getText())) {
            return null;
        }
        PsiElement parent = type.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiMethod method;
            PsiElement typeOwner = parent.getParent();
            if (typeOwner != null && PsiUtilCore.hasErrorElementChild(typeOwner)) {
                return null;
            }
            if (typeOwner instanceof PsiMethod ? (method = (PsiMethod)typeOwner).getReturnTypeElement() == parent && PsiType.VOID.equals(method.getReturnType()) : (typeOwner instanceof PsiClassObjectAccessExpression ? TypeConversionUtil.isVoidType(((PsiClassObjectAccessExpression)typeOwner).getOperand().getType()) : typeOwner instanceof JavaCodeFragment && typeOwner.getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null)) {
                return null;
            }
        }
        String description = JavaErrorMessages.message("illegal.type.void", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(type).descriptionAndTooltip(description).create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static HighlightInfo checkMemberReferencedBeforeConstructorCalled(@NotNull PsiElement expression, PsiElement resolved, @NotNull PsiFile containingFile) {
        String resolvedName;
        PsiClass referencedClass;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(96);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(97);
        }
        if (expression instanceof PsiJavaCodeReferenceElement) {
            if ("this".equals(((PsiJavaCodeReferenceElement)expression).getReferenceName()) && resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor()) {
                return null;
            }
            PsiElement qualifier = ((PsiJavaCodeReferenceElement)expression).getQualifier();
            PsiType type = qualifier instanceof PsiExpression ? ((PsiExpression)qualifier).getType() : null;
            referencedClass = PsiUtil.resolveClassInType(type);
            boolean isSuperCall = RefactoringChangeUtil.isSuperMethodCall(expression.getParent());
            if (resolved == null && isSuperCall) {
                if (qualifier instanceof PsiReferenceExpression) {
                    resolved = ((PsiReferenceExpression)qualifier).resolve();
                    expression = qualifier;
                    type = ((PsiReferenceExpression)qualifier).getType();
                    referencedClass = PsiUtil.resolveClassInType(type);
                } else if (qualifier == null) {
                    resolved = PsiTreeUtil.getParentOfType(expression, PsiMethod.class, true, PsiMember.class);
                    if (resolved != null) {
                        referencedClass = ((PsiMethod)resolved).getContainingClass();
                    }
                } else if (qualifier instanceof PsiThisExpression) {
                    referencedClass = PsiUtil.resolveClassInType(((PsiThisExpression)qualifier).getType());
                }
            }
            if (resolved instanceof PsiField) {
                PsiField referencedField = (PsiField)resolved;
                if (referencedField.hasModifierProperty("static")) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatVariable(referencedField, 4097, PsiSubstitutor.EMPTY);
                referencedClass = referencedField.getContainingClass();
            } else if (resolved instanceof PsiMethod) {
                String name;
                PsiMethod method = (PsiMethod)resolved;
                if (method.hasModifierProperty("static")) {
                    return null;
                }
                PsiElement nameElement = expression instanceof PsiThisExpression ? expression : ((PsiJavaCodeReferenceElement)expression).getReferenceNameElement();
                String string = name = nameElement == null ? null : nameElement.getText();
                if (isSuperCall) {
                    if (referencedClass == null) {
                        return null;
                    }
                    if (qualifier == null) {
                        PsiClass superClass = referencedClass.getSuperClass();
                        if (superClass == null || !PsiUtil.isInnerClass(superClass) || !InheritanceUtil.isInheritorOrSelf(referencedClass, superClass.getContainingClass(), true)) return null;
                        resolvedName = "this";
                    } else {
                        resolvedName = qualifier.getText();
                    }
                } else if ("this".equals(name)) {
                    resolvedName = "this";
                } else {
                    resolvedName = PsiFormatUtil.formatMethod(method, PsiSubstitutor.EMPTY, 4097, 0);
                    if (referencedClass == null) {
                        referencedClass = method.getContainingClass();
                    }
                }
            } else {
                if (!(resolved instanceof PsiClass)) return null;
                PsiClass aClass = (PsiClass)resolved;
                if (aClass.hasModifierProperty("static")) {
                    return null;
                }
                referencedClass = aClass.getContainingClass();
                if (referencedClass == null) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatClass(aClass, 1);
            }
        } else {
            if (!(expression instanceof PsiThisExpression)) return null;
            PsiThisExpression thisExpression = (PsiThisExpression)expression;
            PsiType type = thisExpression.getType();
            referencedClass = PsiUtil.resolveClassInType(type);
            resolvedName = thisExpression.getQualifier() != null ? (referencedClass == null ? null : PsiFormatUtil.formatClass(referencedClass, 1) + ".this") : "this";
        }
        if (referencedClass != null) return HighlightUtil.checkReferenceToOurInstanceInsideThisOrSuper(expression, referencedClass, resolvedName, containingFile);
        return null;
    }

    @Nullable
    private static HighlightInfo checkReferenceToOurInstanceInsideThisOrSuper(@NotNull PsiElement expression, @NotNull PsiClass referencedClass, String resolvedName, @NotNull PsiFile containingFile) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(98);
        }
        if (referencedClass == null) {
            HighlightUtil.$$$reportNull$$$0(99);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(100);
        }
        if (PsiTreeUtil.getParentOfType(expression, PsiReferenceParameterList.class) != null) {
            return null;
        }
        PsiElement element = expression.getParent();
        while (element != null) {
            PsiReferenceExpressionImpl referenceExpression;
            JavaResolveResult[] results;
            PsiElement resolve;
            if (RefactoringChangeUtil.isSuperOrThisMethodCall(element)) {
                PsiElement parentClass = new PsiMatcherImpl(element).parent(PsiMatchers.hasClass(PsiExpressionStatement.class)).parent(PsiMatchers.hasClass(PsiCodeBlock.class)).parent(PsiMatchers.hasClass(PsiMethod.class)).dot(JavaMatchers.isConstructor(true)).parent(PsiMatchers.hasClass(PsiClass.class)).getElement();
                if (parentClass == null) {
                    return null;
                }
                PsiClass aClass = (PsiClass)parentClass;
                if (PsiUtil.isInnerClass(aClass) && referencedClass == aClass.getContainingClass()) {
                    return null;
                }
                if (!InheritanceUtil.isInheritorOrSelf(aClass, referencedClass, true)) {
                    return null;
                }
                if (expression instanceof PsiReferenceExpression && !HighlightUtil.thisOrSuperReference(((PsiReferenceExpression)expression).getQualifierExpression(), aClass)) {
                    return null;
                }
                if (expression instanceof PsiJavaCodeReferenceElement && !aClass.equals(PsiTreeUtil.getParentOfType(expression, PsiClass.class)) && PsiTreeUtil.getParentOfType(expression, PsiTypeElement.class) != null) {
                    return null;
                }
                if (expression instanceof PsiJavaCodeReferenceElement && PsiTreeUtil.getParentOfType(expression, PsiClassObjectAccessExpression.class) != null) {
                    return null;
                }
                HighlightInfo highlightInfo = HighlightUtil.createMemberReferencedError(resolvedName, expression.getTextRange());
                if (expression instanceof PsiReferenceExpression && PsiUtil.isInnerClass(aClass)) {
                    String referenceName = ((PsiReferenceExpression)expression).getReferenceName();
                    PsiClass containingClass = aClass.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    PsiField fieldInContainingClass = containingClass.findFieldByName(referenceName, true);
                    if (fieldInContainingClass != null && ((PsiReferenceExpression)expression).getQualifierExpression() == null) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, new QualifyWithThisFix(containingClass, expression));
                    }
                }
                return highlightInfo;
            }
            if (element instanceof PsiReferenceExpression && (resolve = element instanceof PsiReferenceExpressionImpl ? ((results = JavaResolveUtil.resolveWithContainingFile(referenceExpression = (PsiReferenceExpressionImpl)element, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE, true, false, containingFile)).length == 1 ? results[0].getElement() : null) : ((PsiReferenceExpression)element).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static")) {
                return null;
            }
            if (!((element = element.getParent()) instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)element, referencedClass, true)) continue;
            return null;
        }
        return null;
    }

    private static HighlightInfo createMemberReferencedError(String resolvedName, @NotNull TextRange textRange) {
        if (textRange == null) {
            HighlightUtil.$$$reportNull$$$0(101);
        }
        String description = JavaErrorMessages.message("member.referenced.before.constructor.called", resolvedName);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
    }

    @Nullable
    static HighlightInfo checkImplicitThisReferenceBeforeSuper(@NotNull PsiClass aClass, @NotNull JavaSdkVersion javaSdkVersion) {
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(102);
        }
        if (javaSdkVersion == null) {
            HighlightUtil.$$$reportNull$$$0(103);
        }
        if (javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiTypeParameter) {
            return null;
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null || !PsiUtil.isInnerClass(superClass)) {
            return null;
        }
        PsiClass outerClass = superClass.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf(aClass, outerClass, true)) {
            return null;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", range);
        }
        for (PsiMethod constructor : constructors) {
            if (HighlightUtil.isSuperCalledInConstructor(constructor)) continue;
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", HighlightNamesUtil.getMethodDeclarationTextRange(constructor));
        }
        return null;
    }

    private static boolean isSuperCalledInConstructor(@NotNull PsiMethod constructor) {
        PsiCodeBlock body;
        if (constructor == null) {
            HighlightUtil.$$$reportNull$$$0(104);
        }
        if ((body = constructor.getBody()) == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        PsiElement element = new PsiMatcherImpl(statement).dot(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).dot(PsiMatchers.hasText("super")).getElement();
        return element != null;
    }

    private static boolean thisOrSuperReference(@Nullable PsiExpression qualifierExpression, PsiClass aClass) {
        PsiJavaCodeReferenceElement qualifier;
        if (qualifierExpression == null) {
            return true;
        }
        if (qualifierExpression instanceof PsiThisExpression) {
            qualifier = ((PsiThisExpression)qualifierExpression).getQualifier();
        } else if (qualifierExpression instanceof PsiSuperExpression) {
            qualifier = ((PsiSuperExpression)qualifierExpression).getQualifier();
        } else {
            return false;
        }
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = qualifier.resolve();
        return resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf(aClass, (PsiClass)resolved, true);
    }

    @Nullable
    static HighlightInfo checkLabelWithoutStatement(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(105);
        }
        if (statement.getStatement() == null) {
            String description = JavaErrorMessages.message("label.without.statement", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkLabelAlreadyInUse(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(106);
        }
        PsiIdentifier identifier = statement.getLabelIdentifier();
        String text2 = identifier.getText();
        for (PsiElement element = statement; element != null && !(element instanceof PsiMethod) && !(element instanceof PsiClass); element = element.getParent()) {
            if (!(element instanceof PsiLabeledStatement) || element == statement || !Comparing.equal(element.getLabelIdentifier().getText(), text2)) continue;
            String description = JavaErrorMessages.message("duplicate.label", text2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(identifier).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnclosedComment(@NotNull PsiComment comment) {
        if (comment == null) {
            HighlightUtil.$$$reportNull$$$0(107);
        }
        if (!(comment instanceof PsiDocComment) && comment.getTokenType() != JavaTokenType.C_STYLE_COMMENT) {
            return null;
        }
        if (!comment.getText().endsWith("*/")) {
            int start = comment.getTextRange().getEndOffset() - 1;
            int end = start + 1;
            String description = JavaErrorMessages.message("unclosed.comment", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static Collection<HighlightInfo> checkCatchTypeIsDisjoint(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            HighlightUtil.$$$reportNull$$$0(108);
        }
        if (!(parameter.getType() instanceof PsiDisjunctionType)) {
            return null;
        }
        ArrayList<HighlightInfo> result = ContainerUtil.newArrayList();
        List<PsiTypeElement> typeElements = PsiUtil.getParameterTypeElements(parameter);
        int size = typeElements.size();
        block0: for (int i = 0; i < size; ++i) {
            PsiClass class1 = PsiUtil.resolveClassInClassTypeOnly(typeElements.get(i).getType());
            if (class1 == null) continue;
            for (int j = i + 1; j < size; ++j) {
                PsiClass class2 = PsiUtil.resolveClassInClassTypeOnly(typeElements.get(j).getType());
                if (class2 == null) continue;
                boolean sub = InheritanceUtil.isInheritorOrSelf(class1, class2, true);
                boolean sup = InheritanceUtil.isInheritorOrSelf(class2, class1, true);
                if (!sub && !sup) continue;
                String name1 = PsiFormatUtil.formatClass(class1, 2049);
                String name2 = PsiFormatUtil.formatClass(class2, 2049);
                String message = JavaErrorMessages.message("exception.must.be.disjoint", sub ? name1 : name2, sub ? name2 : name1);
                PsiTypeElement element = typeElements.get(sub ? i : j);
                HighlightInfo highlight = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(message).create();
                QuickFixAction.registerQuickFixAction(highlight, QUICK_FIX_FACTORY.createDeleteMultiCatchFix(element));
                result.add(highlight);
                continue block0;
            }
        }
        return result;
    }

    @Nullable
    static Collection<HighlightInfo> checkExceptionAlreadyCaught(@NotNull PsiParameter parameter) {
        PsiElement scope;
        if (parameter == null) {
            HighlightUtil.$$$reportNull$$$0(109);
        }
        if (!((scope = parameter.getDeclarationScope()) instanceof PsiCatchSection)) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        PsiCatchSection[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int startFrom = ArrayUtilRt.find(allCatchSections, catchSection) - 1;
        if (startFrom < 0) {
            return null;
        }
        List<PsiTypeElement> typeElements = PsiUtil.getParameterTypeElements(parameter);
        boolean isInMultiCatch = typeElements.size() > 1;
        ArrayList<HighlightInfo> result = ContainerUtil.newArrayList();
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass catchClass = PsiUtil.resolveClassInClassTypeOnly(typeElement.getType());
            if (catchClass == null) continue;
            for (int i = startFrom; i >= 0; --i) {
                boolean highlight;
                PsiCatchSection upperCatchSection = allCatchSections[i];
                PsiType upperCatchType = upperCatchSection.getCatchType();
                boolean bl = highlight = upperCatchType instanceof PsiDisjunctionType ? HighlightUtil.checkMultipleTypes(catchClass, ((PsiDisjunctionType)upperCatchType).getDisjunctions()) : HighlightUtil.checkSingleType(catchClass, upperCatchType);
                if (!highlight) continue;
                String className = PsiFormatUtil.formatClass(catchClass, 2049);
                String description = JavaErrorMessages.message("exception.already.caught", className);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description).create();
                result.add(highlightInfo);
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createMoveCatchUpFix(catchSection, upperCatchSection));
                if (isInMultiCatch) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteMultiCatchFix(typeElement));
                    continue;
                }
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteCatchFix(parameter));
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static boolean checkMultipleTypes(PsiClass catchClass, @NotNull List<PsiType> upperCatchTypes) {
        if (upperCatchTypes == null) {
            HighlightUtil.$$$reportNull$$$0(110);
        }
        for (int i = upperCatchTypes.size() - 1; i >= 0; --i) {
            if (!HighlightUtil.checkSingleType(catchClass, upperCatchTypes.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSingleType(PsiClass catchClass, PsiType upperCatchType) {
        PsiClass upperCatchClass = PsiUtil.resolveClassInType(upperCatchType);
        return upperCatchClass != null && InheritanceUtil.isInheritorOrSelf(catchClass, upperCatchClass, true);
    }

    @Nullable
    static HighlightInfo checkTernaryOperatorConditionIsBoolean(@NotNull PsiExpression expression, PsiType type) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(111);
        }
        if (expression.getParent() instanceof PsiConditionalExpression && ((PsiConditionalExpression)expression.getParent()).getCondition() == expression && !TypeConversionUtil.isBooleanType(type)) {
            return HighlightUtil.createIncompatibleTypeHighlightInfo(PsiType.BOOLEAN, type, expression.getTextRange(), 0);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkStatementPrependedWithCaseInsideSwitch(@NotNull PsiSwitchStatement statement) {
        PsiElement first;
        PsiCodeBlock body;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(112);
        }
        if ((body = statement.getBody()) != null && (first = PsiTreeUtil.skipWhitespacesAndCommentsForward(body.getLBrace())) != null && !(first instanceof PsiSwitchLabelStatement) && !PsiUtil.isJavaToken(first, JavaTokenType.RBRACE)) {
            String description = JavaErrorMessages.message("statement.must.be.prepended.with.case.label", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(first).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkAssertOperatorTypes(@NotNull PsiExpression expression, @Nullable PsiType type) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(113);
        }
        if (type == null) {
            return null;
        }
        if (!(expression.getParent() instanceof PsiAssertStatement)) {
            return null;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)expression.getParent();
        if (expression == assertStatement.getAssertCondition() && !TypeConversionUtil.isBooleanType(type)) {
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(PsiType.BOOLEAN, type, expression.getTextRange(), 0);
            if (expression instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expression).getOperationTokenType() == JavaTokenType.EQ) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAssignmentToComparisonFix((PsiAssignmentExpression)expression));
            }
            return highlightInfo;
        }
        if (expression == assertStatement.getAssertDescription() && TypeConversionUtil.isVoidType(type)) {
            String description = JavaErrorMessages.message("void.type.is.not.allowed", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkSynchronizedExpressionType(@NotNull PsiExpression expression, @Nullable PsiType type, @NotNull PsiFile containingFile) {
        PsiSynchronizedStatement synchronizedStatement;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(114);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(115);
        }
        if (type == null) {
            return null;
        }
        if (expression.getParent() instanceof PsiSynchronizedStatement && expression == (synchronizedStatement = (PsiSynchronizedStatement)expression.getParent()).getLockExpression() && (type instanceof PsiPrimitiveType || TypeConversionUtil.isNullType(type))) {
            PsiClassType objectType = PsiType.getJavaLangObject(containingFile.getManager(), expression.getResolveScope());
            return HighlightUtil.createIncompatibleTypeHighlightInfo(objectType, type, expression.getTextRange(), 0);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkConditionalExpressionBranchTypesMatch(@NotNull PsiExpression expression, PsiType type) {
        PsiElement parent;
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(116);
        }
        if (!((parent = expression.getParent()) instanceof PsiConditionalExpression)) {
            return null;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
        if (conditionalExpression.getElseExpression() != expression) {
            return null;
        }
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        assert (thenExpression != null);
        PsiType thenType = thenExpression.getType();
        if (thenType == null || type == null) {
            return null;
        }
        if (conditionalExpression.getType() == null) {
            if (PsiUtil.isLanguageLevel8OrHigher(conditionalExpression) && PsiPolyExpressionUtil.isPolyExpression(conditionalExpression)) {
                return null;
            }
            return HighlightUtil.createIncompatibleTypeHighlightInfo(thenType, type, expression.getTextRange(), 0);
        }
        return null;
    }

    static HighlightInfo createIncompatibleTypeHighlightInfo(PsiType lType, PsiType rType, @NotNull TextRange textRange, int navigationShift) {
        if (textRange == null) {
            HighlightUtil.$$$reportNull$$$0(117);
        }
        Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> lTypeData = HighlightUtil.typeData(lType);
        Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> rTypeData = HighlightUtil.typeData(rType);
        lType = (PsiType)lTypeData.first;
        rType = (PsiType)rTypeData.first;
        PsiTypeParameter[] lTypeParams = (PsiTypeParameter[])lTypeData.second;
        PsiTypeParameter[] rTypeParams = (PsiTypeParameter[])rTypeData.second;
        int typeParamColumns = Math.max(lTypeParams.length, rTypeParams.length);
        StringBuilder requiredRow = new StringBuilder();
        StringBuilder foundRow = new StringBuilder();
        for (int i = 0; i < typeParamColumns; ++i) {
            PsiTypeParameter lTypeParameter = i >= lTypeParams.length ? null : lTypeParams[i];
            PsiTypeParameter rTypeParameter = i >= rTypeParams.length ? null : rTypeParams[i];
            PsiType lSubstitutedType = lTypeParameter == null ? null : ((PsiSubstitutor)lTypeData.third).substitute(lTypeParameter);
            PsiType rSubstitutedType = rTypeParameter == null ? null : ((PsiSubstitutor)rTypeData.third).substitute(rTypeParameter);
            boolean matches = Comparing.equal(lSubstitutedType, rSubstitutedType);
            String openBrace = i == 0 ? "&lt;" : "";
            String closeBrace = i == typeParamColumns - 1 ? "&gt;" : ",";
            requiredRow.append("<td>").append(lTypeParams.length == 0 ? "" : openBrace).append(HighlightUtil.redIfNotMatch(lSubstitutedType, matches)).append(i < lTypeParams.length ? closeBrace : "").append("</td>");
            foundRow.append("<td>").append(rTypeParams.length == 0 ? "" : openBrace).append(HighlightUtil.redIfNotMatch(rSubstitutedType, matches)).append(i < rTypeParams.length ? closeBrace : "").append("</td>");
        }
        PsiType lRawType = lType instanceof PsiClassType ? ((PsiClassType)lType).rawType() : lType;
        PsiType rRawType = rType instanceof PsiClassType ? ((PsiClassType)rType).rawType() : rType;
        boolean assignable = lRawType == null || rRawType == null || TypeConversionUtil.isAssignable(lRawType, rRawType);
        String toolTip = JavaErrorMessages.message("incompatible.types.html.tooltip", HighlightUtil.redIfNotMatch(lRawType, assignable), requiredRow, HighlightUtil.redIfNotMatch(rRawType, assignable), foundRow);
        String description = JavaErrorMessages.message("incompatible.types", JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).description(description).escapedToolTip(toolTip).navigationShift(navigationShift).create();
    }

    private static Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> typeData(PsiType type) {
        PsiTypeParameter[] parameters = PsiTypeParameter.EMPTY_ARRAY;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            substitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass instanceof PsiAnonymousClass) {
                type = ((PsiAnonymousClass)psiClass).getBaseClassType();
                resolveResult = ((PsiClassType)type).resolveGenerics();
                substitutor = resolveResult.getSubstitutor();
                psiClass = resolveResult.getElement();
            }
            parameters = psiClass == null ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        }
        return Trinity.create(type, parameters, substitutor);
    }

    private static String redIfNotMatch(PsiType type, boolean matches) {
        if (matches) {
            return HighlightUtil.getFQName(type, false);
        }
        String color = UIUtil.isUnderDarcula() ? "FF6B68" : "red";
        return "<font color='" + color + "'><b>" + HighlightUtil.getFQName(type, true) + "</b></font>";
    }

    private static String getFQName(PsiType type, boolean longName) {
        return type != null ? XmlStringUtil.escapeString(longName ? type.getInternalCanonicalText() : type.getPresentableText()) : "";
    }

    @Nullable
    static HighlightInfo checkSingleImportClassConflict(@NotNull PsiImportStatement statement, @NotNull Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> importedClasses, @NotNull PsiFile containingFile) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(118);
        }
        if (importedClasses == null) {
            HighlightUtil.$$$reportNull$$$0(119);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(120);
        }
        if (statement.isOnDemand()) {
            return null;
        }
        PsiElement element = statement.resolve();
        if (element instanceof PsiClass) {
            PsiClass importedClass;
            String name = ((PsiClass)element).getName();
            Pair<PsiImportStaticReferenceElement, PsiClass> imported = importedClasses.get(name);
            PsiClass psiClass = importedClass = imported == null ? null : imported.getSecond();
            if (importedClass != null && !containingFile.getManager().areElementsEquivalent(importedClass, element)) {
                String description = JavaErrorMessages.message("single.import.class.conflict", HighlightUtil.formatClass(importedClass));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(description).create();
            }
            importedClasses.put(name, Pair.pair(null, (PsiClass)element));
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMustBeThrowable(@Nullable PsiType type, @NotNull PsiElement context, boolean addCastIntention) {
        if (context == null) {
            HighlightUtil.$$$reportNull$$$0(121);
        }
        if (type == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(context.getProject()).getElementFactory();
        PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", context.getResolveScope());
        if (!TypeConversionUtil.isAssignable(throwable, type)) {
            PsiClass aClass;
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(throwable, type, context.getTextRange(), 0);
            if (addCastIntention && TypeConversionUtil.areTypesConvertible(type, throwable) && context instanceof PsiExpression) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddTypeCastFix(throwable, (PsiExpression)context));
            }
            if ((aClass = PsiUtil.resolveClassInClassTypeOnly(type)) != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createExtendsListFix(aClass, throwable, true));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkMustBeThrowable(@Nullable PsiClass aClass, @NotNull PsiElement context) {
        if (context == null) {
            HighlightUtil.$$$reportNull$$$0(122);
        }
        if (aClass == null) {
            return null;
        }
        PsiClassType type = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory().createType(aClass);
        return HighlightUtil.checkMustBeThrowable(type, context, false);
    }

    @Nullable
    static HighlightInfo checkLabelDefined(@Nullable PsiIdentifier labelIdentifier, @Nullable PsiStatement exitedStatement) {
        if (labelIdentifier == null) {
            return null;
        }
        String label = labelIdentifier.getText();
        if (label == null) {
            return null;
        }
        if (exitedStatement == null) {
            String message = JavaErrorMessages.message("unresolved.label", label);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(labelIdentifier).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull JavaResolveResult result, @NotNull PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        String description;
        boolean skipValidityChecks;
        PsiElement granny;
        PsiElement refName;
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(123);
        }
        if (result == null) {
            HighlightUtil.$$$reportNull$$$0(124);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(125);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(126);
        }
        if (!((refName = ref.getReferenceNameElement()) instanceof PsiIdentifier) && !(refName instanceof PsiKeyword)) {
            return null;
        }
        PsiElement resolved = result.getElement();
        HighlightInfo highlightInfo = HighlightUtil.checkMemberReferencedBeforeConstructorCalled(ref, resolved, containingFile);
        if (highlightInfo != null) {
            return highlightInfo;
        }
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && (granny = refParent.getParent()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression referenceToMethod = ((PsiMethodCallExpression)granny).getMethodExpression();
            PsiExpression qualifierExpression = referenceToMethod.getQualifierExpression();
            if (qualifierExpression == ref && resolved != null && !(resolved instanceof PsiClass) && !(resolved instanceof PsiVariable)) {
                String message = JavaErrorMessages.message("qualifier.must.be.expression", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(qualifierExpression).descriptionAndTooltip(message).create();
            }
        } else if (refParent instanceof PsiMethodCallExpression) {
            return null;
        }
        if (resolved == null) {
            String description2;
            PsiJavaCodeReferenceElement parent = HighlightUtil.getOuterReferenceParent(ref);
            PsiElement outerParent = parent.getParent();
            if (outerParent instanceof PsiPackageStatement || result.isPackagePrefixPackageReference() || PsiUtil.isInsideJavadocComment(ref) || parent.resolve() instanceof PsiMember || outerParent instanceof PsiPackageAccessibilityStatement) {
                return null;
            }
            JavaResolveResult[] results = ref.multiResolve(true);
            if (results.length > 1) {
                String t1 = HighlightUtil.format(ObjectUtils.notNull(results[0].getElement()));
                String t2 = HighlightUtil.format(ObjectUtils.notNull(results[1].getElement()));
                description2 = JavaErrorMessages.message("ambiguous.reference", refName.getText(), t1, t2);
            } else {
                description2 = JavaErrorMessages.message("cannot.resolve.symbol", refName.getText());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description2).create();
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(ref, new QuickFixActionRegistrarImpl(info));
            return info;
        }
        boolean bl = skipValidityChecks = PsiUtil.isInsideJavadocComment(ref) || PsiTreeUtil.getParentOfType((PsiElement)ref, PsiPackageStatement.class, true) != null || resolved instanceof PsiPackage && ref.getParent() instanceof PsiJavaCodeReferenceElement;
        if (!skipValidityChecks && !result.isValidResult()) {
            if (!result.isAccessible()) {
                Pair<String, List<IntentionAction>> problem = HighlightUtil.accessProblemDescriptionAndFixes(ref, resolved, result);
                boolean moduleAccessProblem = problem.second != null;
                PsiElement range = moduleAccessProblem ? HighlightUtil.findPackagePrefix(ref) : refName;
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(range).descriptionAndTooltip((String)problem.first).create();
                if (moduleAccessProblem) {
                    ((List)problem.second).forEach(fix -> QuickFixAction.registerQuickFixAction(info, fix));
                } else if (result.isStaticsScopeCorrect() && resolved instanceof PsiMember) {
                    HighlightFixUtil.registerAccessQuickFixAction((PsiMember)resolved, ref, info, result.getCurrentFileResolveScope());
                    if (ref instanceof PsiReferenceExpression) {
                        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRenameWrongRefFix((PsiReferenceExpression)ref));
                    }
                }
                UnresolvedReferenceQuickFixProvider.registerReferenceFixes(ref, new QuickFixActionRegistrarImpl(info));
                return info;
            }
            if (!result.isStaticsScopeCorrect()) {
                description = HighlightUtil.staticContextProblemDescription(resolved);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description).create();
                HighlightFixUtil.registerStaticProblemQuickFixAction(resolved, info, ref);
                if (ref instanceof PsiReferenceExpression) {
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRenameWrongRefFix((PsiReferenceExpression)ref));
                }
                return info;
            }
        }
        if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !(resolved instanceof ImplicitVariable)) {
            return HighlightControlFlowUtil.checkVariableMustBeFinal((PsiVariable)resolved, ref, languageLevel);
        }
        if (resolved instanceof PsiClass && ((PsiClass)resolved).getContainingClass() == null && PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStatementBase.class) != null && PsiUtil.isFromDefaultPackage((PsiClass)resolved)) {
            description = JavaErrorMessages.message("cannot.resolve.symbol", refName.getText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static PsiElement findPackagePrefix(PsiJavaCodeReferenceElement ref) {
        PsiElement candidate = ref;
        while (candidate instanceof PsiJavaCodeReferenceElement) {
            if (candidate.resolve() instanceof PsiPackage) {
                return candidate;
            }
            candidate = candidate.getQualifier();
        }
        return ref;
    }

    @NotNull
    private static String format(@NotNull PsiElement element) {
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(127);
        }
        if (element instanceof PsiClass) {
            String string = HighlightUtil.formatClass((PsiClass)element);
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(128);
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            String string = JavaHighlightUtil.formatMethod((PsiMethod)element);
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(129);
            }
            return string;
        }
        if (element instanceof PsiField) {
            String string = HighlightUtil.formatField((PsiField)element);
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(130);
            }
            return string;
        }
        String string = ElementDescriptionUtil.getElementDescription(element, HighlightUsagesDescriptionLocation.INSTANCE);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(131);
        }
        return string;
    }

    @NotNull
    private static PsiJavaCodeReferenceElement getOuterReferenceParent(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(132);
        }
        PsiJavaCodeReferenceElement element = ref;
        while ((parent = element.getParent()) instanceof PsiJavaCodeReferenceElement) {
            element = (PsiJavaCodeReferenceElement)parent;
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = element;
        if (psiJavaCodeReferenceElement == null) {
            HighlightUtil.$$$reportNull$$$0(133);
        }
        return psiJavaCodeReferenceElement;
    }

    @Nullable
    static HighlightInfo checkPackageAndClassConflict(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        Module module;
        VirtualFile file;
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(134);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(135);
        }
        if (ref.isQualified() && HighlightUtil.getOuterReferenceParent(ref).getParent() instanceof PsiPackageStatement && (file = containingFile.getVirtualFile()) != null && (module = ProjectFileIndex.SERVICE.getInstance(ref.getProject()).getModuleForFile(file)) != null) {
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            PsiClass aClass = JavaPsiFacade.getInstance(ref.getProject()).findClass(ref.getCanonicalText(), scope);
            if (aClass != null) {
                String message = JavaErrorMessages.message("package.clashes.with.class", ref.getText());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkElementInReferenceList(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiReferenceList referenceList, @NotNull JavaResolveResult resolveResult) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(136);
        }
        if (referenceList == null) {
            HighlightUtil.$$$reportNull$$$0(137);
        }
        if (resolveResult == null) {
            HighlightUtil.$$$reportNull$$$0(138);
        }
        PsiElement resolved = resolveResult.getElement();
        HighlightInfo highlightInfo = null;
        PsiElement refGrandParent = referenceList.getParent();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (refGrandParent instanceof PsiClass) {
                if (refGrandParent instanceof PsiTypeParameter) {
                    highlightInfo = GenericsHighlightUtil.checkElementInTypeParameterExtendsList(referenceList, (PsiClass)refGrandParent, resolveResult, ref);
                } else {
                    highlightInfo = HighlightClassUtil.checkExtendsClassAndImplementsInterface(referenceList, resolveResult, ref);
                    if (highlightInfo == null) {
                        highlightInfo = HighlightClassUtil.checkCannotInheritFromFinal(aClass, ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromEnum(aClass, ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromTypeParameter(aClass, ref);
                    }
                }
            } else if (refGrandParent instanceof PsiMethod && ((PsiMethod)refGrandParent).getThrowsList() == referenceList) {
                highlightInfo = HighlightUtil.checkMustBeThrowable(aClass, ref);
            }
        } else if (refGrandParent instanceof PsiMethod && referenceList == ((PsiMethod)refGrandParent).getThrowsList()) {
            String description = JavaErrorMessages.message("class.name.expected", new Object[0]);
            highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(description).create();
        }
        return highlightInfo;
    }

    public static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        String name;
        if (field == null) {
            HighlightUtil.$$$reportNull$$$0(139);
        }
        if (!"serialVersionUID".equals(name = field.getName()) && !SERIAL_PERSISTENT_FIELDS_FIELD_NAME.equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || JavaHighlightUtil.isSerializable(aClass);
    }

    @Nullable
    static HighlightInfo checkClassReferenceAfterQualifier(@NotNull PsiReferenceExpression expression, PsiElement resolved) {
        if (expression == null) {
            HighlightUtil.$$$reportNull$$$0(140);
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            PsiElement qualifierResolved = ((PsiReferenceExpression)qualifier).resolve();
            if (qualifierResolved instanceof PsiClass || qualifierResolved instanceof PsiPackage) {
                return null;
            }
            if (qualifierResolved == null) {
                PsiElement qResolve;
                PsiReferenceExpression qExpression = (PsiReferenceExpression)qualifier;
                while ((qResolve = qExpression.resolve()) == null || qResolve instanceof PsiClass || qResolve instanceof PsiPackage) {
                    PsiExpression qualifierExpression = qExpression.getQualifierExpression();
                    if (qualifierExpression == null) {
                        return null;
                    }
                    if (!(qualifierExpression instanceof PsiReferenceExpression)) break;
                    qExpression = (PsiReferenceExpression)qualifierExpression;
                }
            }
        }
        String description = JavaErrorMessages.message("expected.class.or.package", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveQualifierFix(qualifier, expression, (PsiClass)resolved));
        return info;
    }

    @Nullable
    static HighlightInfo checkAnnotationMethodParameters(@NotNull PsiParameterList list) {
        PsiElement parent;
        if (list == null) {
            HighlightUtil.$$$reportNull$$$0(141);
        }
        if (PsiUtil.isAnnotationMethod(parent = list.getParent()) && list.getParametersCount() > 0) {
            String message = JavaErrorMessages.message("annotation.interface.members.may.not.have.parameters", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createRemoveParameterListFix((PsiMethod)parent));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkForStatement(@NotNull PsiForStatement statement) {
        PsiStatement init;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(142);
        }
        if ((init = statement.getInitialization()) == null || init instanceof PsiEmptyStatement || init instanceof PsiDeclarationStatement && ArrayUtil.getFirstElement(((PsiDeclarationStatement)init).getDeclaredElements()) instanceof PsiLocalVariable || init instanceof PsiExpressionStatement || init instanceof PsiExpressionListStatement) {
            return null;
        }
        String message = JavaErrorMessages.message("invalid.statement", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(init).descriptionAndTooltip(message).create();
    }

    @Nullable
    static HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull Feature feature, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(143);
        }
        if (feature == null) {
            HighlightUtil.$$$reportNull$$$0(144);
        }
        if (level == null) {
            HighlightUtil.$$$reportNull$$$0(145);
        }
        if (file == null) {
            HighlightUtil.$$$reportNull$$$0(146);
        }
        if (file.getManager().isInProject(file) && !level.isAtLeast(feature.level)) {
            String message = HighlightUtil.getUnsupportedFeatureMessage(element, feature, level, file);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(feature.level));
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createShowModulePropertiesFix(element));
            return info;
        }
        return null;
    }

    private static String getUnsupportedFeatureMessage(PsiElement element, Feature feature, LanguageLevel level, PsiFile file) {
        LanguageLevel moduleLanguageLevel;
        String name = JavaErrorMessages.message(feature.key, new Object[0]);
        String message = JavaErrorMessages.message("insufficient.language.level", name, level.getCompilerComplianceDefaultOption());
        Module module = ModuleUtilCore.findModuleForPsiElement(element);
        if (module != null && (moduleLanguageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel(module)).isAtLeast(feature.level)) {
            for (FilePropertyPusher pusher : FilePropertyPusher.EP_NAME.getExtensions()) {
                String newMessage;
                if (!(pusher instanceof JavaLanguageLevelPusher) || (newMessage = ((JavaLanguageLevelPusher)pusher).getInconsistencyLanguageLevelMessage(message, element, level, file)) == null) continue;
                return newMessage;
            }
        }
        return message;
    }

    @Deprecated
    @NotNull
    public static List<IntentionAction> getChangeVariableTypeFixes(@NotNull PsiVariable variable, PsiType itemType) {
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(147);
        }
        List<IntentionAction> list = HighlightFixUtil.getChangeVariableTypeFixes(variable, itemType);
        if (list == null) {
            HighlightUtil.$$$reportNull$$$0(148);
        }
        return list;
    }

    private static /* synthetic */ boolean lambda$checkIntersectionInTypeCast$0(Ref differentArgumentsMessage, Pair pair) {
        if (!TypesDistinctProver.provablyDistinct((PsiType)pair.first, (PsiType)pair.second)) {
            return true;
        }
        differentArgumentsMessage.set(((PsiType)pair.first).getPresentableText() + " and " + ((PsiType)pair.second).getPresentableText());
        return false;
    }

    static {
        ourClassIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet("final"));
        ourClassIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet("abstract"));
        ourClassIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet("private", "public", "protected"));
        ourClassIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "protected"));
        ourClassIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "private", "protected"));
        ourClassIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "private"));
        ourClassIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourClassIncompatibleModifiers.put("static", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("abstract", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet("private", "public", "protected"));
        ourInterfaceIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "protected"));
        ourInterfaceIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "private", "protected"));
        ourInterfaceIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "private"));
        ourInterfaceIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("static", Collections.emptySet());
        ourMethodIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet("native", "static", "final", "private", "strictfp", "synchronized", "default"));
        ourMethodIncompatibleModifiers.put("native", (Set<String>)ContainerUtil.newTroveSet("abstract", "strictfp"));
        ourMethodIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet("private", "public", "protected"));
        ourMethodIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "protected"));
        ourMethodIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "private", "protected"));
        ourMethodIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "private"));
        ourMethodIncompatibleModifiers.put("static", (Set<String>)ContainerUtil.newTroveSet("abstract", "default", "final"));
        ourMethodIncompatibleModifiers.put("default", (Set<String>)ContainerUtil.newTroveSet("abstract", "static", "final", "private"));
        ourMethodIncompatibleModifiers.put("synchronized", (Set<String>)ContainerUtil.newTroveSet("abstract"));
        ourMethodIncompatibleModifiers.put("strictfp", (Set<String>)ContainerUtil.newTroveSet("abstract"));
        ourMethodIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet("abstract"));
        ourFieldIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet("volatile"));
        ourFieldIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet("private", "public", "protected"));
        ourFieldIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "protected"));
        ourFieldIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "private", "protected"));
        ourFieldIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet("packageLocal", "public", "private"));
        ourFieldIncompatibleModifiers.put("static", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("transient", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("volatile", (Set<String>)ContainerUtil.newTroveSet("final"));
        ourClassInitializerIncompatibleModifiers.put("static", Collections.emptySet());
        ourModuleIncompatibleModifiers.put("open", Collections.emptySet());
        ourRequiresIncompatibleModifiers.put("static", Collections.emptySet());
        ourRequiresIncompatibleModifiers.put("transitive", Collections.emptySet());
        FP_LITERAL_PARTS = Pattern.compile("(?:(?:0x([_\\p{XDigit}]*)\\.?([_\\p{XDigit}]*)p[+-]?([_\\d]*))|(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)))[fd]?");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 28: 
            case 30: 
            case 43: 
            case 51: 
            case 69: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 148: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 28: 
            case 30: 
            case 43: 
            case 51: 
            case 69: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 148: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibleModifiersHash";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 40: 
            case 59: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 24: 
            case 61: 
            case 62: 
            case 67: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 4: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 10: 
            case 11: 
            case 21: 
            case 22: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 13: 
            case 101: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 14: 
            case 33: 
            case 34: 
            case 42: 
            case 55: 
            case 56: 
            case 90: 
            case 105: 
            case 106: 
            case 112: 
            case 118: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unhandled";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 28: 
            case 30: 
            case 43: 
            case 51: 
            case 69: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 25: 
            case 27: 
            case 66: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 29: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 31: 
            case 127: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 36: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 41: 
            case 60: 
            case 63: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 44: 
            case 46: 
            case 49: 
            case 52: 
            case 83: 
            case 108: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 45: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownTypes";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caughtType";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownInTryStatement";
                break;
            }
            case 54: 
            case 97: 
            case 100: 
            case 115: 
            case 120: 
            case 125: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 57: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 58: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 70: 
            case 74: 
            case 123: 
            case 132: 
            case 134: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 72: 
            case 76: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultForIncompleteCode";
                break;
            }
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedField";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedClass";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdkVersion";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperCatchTypes";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedClasses";
                break;
            }
            case 121: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptionsDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypes";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "formatField";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "checkMultiCatchParameter";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "staticContextProblemDescription";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "accessProblemDescription";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "accessProblemDescriptionAndFixes";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterReferenceParent";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeVariableTypeFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatibleModifier";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkInstanceOfApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkIntersectionInTypeCast";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkInconvertibleTypeCast";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableExpected";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentOperatorApplicable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentCompatibleTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCastIntentionApplicable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableInitializerType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkVarTypeApplicability";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignability";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnStatementType";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptionsDescriptor";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 28: 
            case 30: 
            case 43: 
            case 51: 
            case 69: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 148: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "formatTypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableAlreadyDefined";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkSameNames";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderscore";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "formatField";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkUnhandledExceptions";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkUnhandledCloserExceptions";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkBreakOutsideLoop";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkContinueOutsideLoop";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalModifierCombination";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkNotAllowedModifier";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkLiteralExpressionParsingError";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkMustBeBoolean";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkExceptionThrownInTry";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkSimpleCatchParameter";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkMultiCatchParameter";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkWithImprovedCatchAnalysis";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkNotAStatement";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkSwitchSelectorType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchSelectorKind";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "checkPolyadicOperatorApplicable";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "checkThisOrSuperExpressionInIllegalContext";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "checkUnqualifiedSuperInDefaultMethod";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "thisNotFoundInInterfaceInfo";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToImmediateSuperInterface";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "staticContextProblemDescription";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "accessProblemDescription";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "accessProblemDescriptionAndFixes";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "checkValidArrayAccessExpression";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "checkCatchParameterIsThrowable";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "checkTryResourceIsAutoCloseable";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceVariableIsFinal";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializerCompatibleTypes";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "checkExpressionRequired";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializerApplicable";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "checkCaseStatement";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalForwardReferenceToField";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isIllegalForwardReferenceToField";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalVoidType";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberReferencedBeforeConstructorCalled";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceToOurInstanceInsideThisOrSuper";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "createMemberReferencedError";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitThisReferenceBeforeSuper";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isSuperCalledInConstructor";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "checkLabelWithoutStatement";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "checkLabelAlreadyInUse";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "checkUnclosedComment";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "checkCatchTypeIsDisjoint";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "checkExceptionAlreadyCaught";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "checkMultipleTypes";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "checkTernaryOperatorConditionIsBoolean";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "checkStatementPrependedWithCaseInsideSwitch";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "checkAssertOperatorTypes";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "checkSynchronizedExpressionType";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "checkConditionalExpressionBranchTypesMatch";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleTypeHighlightInfo";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "checkSingleImportClassConflict";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "checkMustBeThrowable";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "checkReference";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getOuterReferenceParent";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageAndClassConflict";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "checkElementInReferenceList";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "isSerializationImplicitlyUsedField";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "checkClassReferenceAfterQualifier";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationMethodParameters";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "checkForStatement";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "checkFeature";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getChangeVariableTypeFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 28: 
            case 30: 
            case 43: 
            case 51: 
            case 69: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 148: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Feature {
        GENERICS(LanguageLevel.JDK_1_5, "feature.generics"),
        ANNOTATIONS(LanguageLevel.JDK_1_5, "feature.annotations"),
        STATIC_IMPORTS(LanguageLevel.JDK_1_5, "feature.static.imports"),
        FOR_EACH(LanguageLevel.JDK_1_5, "feature.for.each"),
        VARARGS(LanguageLevel.JDK_1_5, "feature.varargs"),
        HEX_FP_LITERALS(LanguageLevel.JDK_1_5, "feature.hex.fp.literals"),
        DIAMOND_TYPES(LanguageLevel.JDK_1_7, "feature.diamond.types"),
        MULTI_CATCH(LanguageLevel.JDK_1_7, "feature.multi.catch"),
        TRY_WITH_RESOURCES(LanguageLevel.JDK_1_7, "feature.try.with.resources"),
        BIN_LITERALS(LanguageLevel.JDK_1_7, "feature.binary.literals"),
        UNDERSCORES(LanguageLevel.JDK_1_7, "feature.underscores.in.literals"),
        EXTENSION_METHODS(LanguageLevel.JDK_1_8, "feature.extension.methods"),
        METHOD_REFERENCES(LanguageLevel.JDK_1_8, "feature.method.references"),
        LAMBDA_EXPRESSIONS(LanguageLevel.JDK_1_8, "feature.lambda.expressions"),
        TYPE_ANNOTATIONS(LanguageLevel.JDK_1_8, "feature.type.annotations"),
        RECEIVERS(LanguageLevel.JDK_1_8, "feature.type.receivers"),
        INTERSECTION_CASTS(LanguageLevel.JDK_1_8, "feature.intersections.in.casts"),
        STATIC_INTERFACE_CALLS(LanguageLevel.JDK_1_8, "feature.static.interface.calls"),
        REFS_AS_RESOURCE(LanguageLevel.JDK_1_9, "feature.try.with.resources.refs"),
        MODULES(LanguageLevel.JDK_1_9, "feature.modules");

        private final LanguageLevel level;
        private final String key;

        private Feature(LanguageLevel level, String key) {
            this.level = level;
            this.key = key;
        }
    }

    private static enum SelectorKind {
        INT,
        ENUM,
        STRING;

    }
}

