/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReferenceInstruction
extends Instruction {
    private final PsiExpression myExpression;
    @Nullable
    private final String mySyntheticFieldName;

    public FieldReferenceInstruction(@NotNull PsiExpression expression, @Nullable @NonNls String syntheticFieldName) {
        if (expression == null) {
            FieldReferenceInstruction.$$$reportNull$$$0(0);
        }
        this.myExpression = expression;
        this.mySyntheticFieldName = syntheticFieldName;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitFieldReference(this, runner, stateBefore);
    }

    public String toString() {
        return "FIELD_REFERENCE: " + this.myExpression.getText();
    }

    @NotNull
    public PsiExpression getExpression() {
        PsiExpression psiExpression = this.myExpression;
        if (psiExpression == null) {
            FieldReferenceInstruction.$$$reportNull$$$0(1);
        }
        return psiExpression;
    }

    @Nullable
    public PsiExpression getElementToAssert() {
        if (this.mySyntheticFieldName != null) {
            return this.myExpression;
        }
        return this.myExpression instanceof PsiArrayAccessExpression ? ((PsiArrayAccessExpression)this.myExpression).getArrayExpression() : ((PsiReferenceExpression)this.myExpression).getQualifierExpression();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/instructions/FieldReferenceInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/instructions/FieldReferenceInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

