/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ShutDownTracker
implements Runnable {
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private final Thread myThread = new Thread((Runnable)this, "Shutdown tracker");

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(this.myThread);
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        ShutDownTracker shutDownTracker = ShutDownTrackerHolder.ourInstance;
        if (shutDownTracker == null) {
            ShutDownTracker.$$$reportNull$$$0(0);
        }
        return shutDownTracker;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myThread.isAlive();
    }

    @Override
    public void run() {
        Runnable task;
        this.ensureStopperThreadsFinished();
        while ((task = this.removeLast(this.myShutdownTasks)) != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                Logger.getInstance(ShutDownTracker.class).error(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitFor(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ShutDownTracker.$$$reportNull$$$0(1);
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            try {
                void unit;
                this.myThread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myThread.isAlive();
        }
        return false;
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    Logger.getInstance(ShutDownTracker.class).error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker");
                    this.unregisterStopperThread(thread);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread.interrupt();
                }
                try {
                    thread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(@NotNull Thread thread) {
        if (thread == null) {
            ShutDownTracker.$$$reportNull$$$0(2);
        }
        return this.myThreads.contains(thread);
    }

    @NotNull
    private synchronized Thread[] getStopperThreads() {
        Thread[] threadArray = this.myThreads.toArray(new Thread[this.myThreads.size()]);
        if (threadArray == null) {
            ShutDownTracker.$$$reportNull$$$0(3);
        }
        return threadArray;
    }

    public synchronized void registerStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            ShutDownTracker.$$$reportNull$$$0(4);
        }
        this.myThreads.add(thread);
    }

    public synchronized void unregisterStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            ShutDownTracker.$$$reportNull$$$0(5);
        }
        this.myThreads.remove(thread);
    }

    public synchronized void registerShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            ShutDownTracker.$$$reportNull$$$0(6);
        }
        this.myShutdownTasks.addLast(task);
    }

    public synchronized void unregisterShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            ShutDownTracker.$$$reportNull$$$0(7);
        }
        this.myShutdownTasks.remove(task);
    }

    private synchronized <T> T removeLast(@NotNull LinkedList<T> list) {
        if (list == null) {
            ShutDownTracker.$$$reportNull$$$0(8);
        }
        return list.isEmpty() ? null : (T)list.removeLast();
    }

    public static void invokeAndWait(boolean returnOnTimeout, boolean runInEdt2, final @NotNull Runnable runnable) {
        if (runnable == null) {
            ShutDownTracker.$$$reportNull$$$0(9);
        }
        if (!runInEdt2) {
            if (returnOnTimeout) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                        semaphore.up();
                    }
                }, "shutdown tracker invoker").start();
                semaphore.waitFor(1000L);
            } else {
                runnable.run();
            }
            return;
        }
        if (returnOnTimeout) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    semaphore.up();
                }
            });
            semaphore.waitFor(1000L);
            return;
        }
        try {
            UIUtil.invokeAndWaitIfNeeded(runnable);
        }
        catch (Exception e) {
            Logger.getInstance(ShutDownTracker.class).error(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ShutDownTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ShutDownTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStopperThreads";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRegistered";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerStopperThread";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterStopperThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerShutdownTask";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterShutdownTask";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeLast";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();

        private ShutDownTrackerHolder() {
        }
    }
}

