/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Iterable<E> myIterable;
    private static final JBIterable EMPTY = new JBIterable(){

        @Override
        public Iterator iterator() {
            return EmptyIterator.getInstance();
        }
    };

    protected JBIterable() {
        this.myIterable = this;
    }

    JBIterable(@NotNull Iterable<E> iterable) {
        if (iterable == null) {
            JBIterable.$$$reportNull$$$0(0);
        }
        this.myIterable = iterable;
    }

    @NotNull
    public static <E> JBIterable<E> create(final @Nullable Producer<Iterator<E>> producer) {
        if (producer == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                Iterator iterator = (Iterator)producer.produce();
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable$1", "iterator"));
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        if (iterable instanceof JBIterable) {
            JBIterable jBIterable = (JBIterable)iterable;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return this.myIterable.iterator();
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (generator == null) {
            JBIterable.$$$reportNull$$$0(7);
        }
        if (first == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur;
                        if (result == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result;
                    }
                };
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (generator == null) {
            JBIterable.$$$reportNull$$$0(10);
        }
        if (first1 == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result, this.cur2);
                        if (result == null) {
                            return this.stop();
                        }
                        return result;
                    }
                };
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> of(@Nullable E element) {
        JBIterable<E> jBIterable = element == null ? JBIterable.empty() : JBIterable.from(Collections.singletonList(element));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        JBIterable<E> jBIterable = elements == null || elements.length == 0 ? JBIterable.empty() : JBIterable.from(ContainerUtilRt.newArrayList(elements));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        JBIterable jBIterable = EMPTY;
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator) {
        if (iterator == null) {
            JBIterable.$$$reportNull$$$0(16);
        }
        JBIterable jBIterable = JBIterable.of(Ref.create(iterator)).intercept(new Function<Iterator<Ref<Iterator<E>>>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<Ref<Iterator<E>>> iterator) {
                Ref ref = iterator.next();
                Iterator result = ref.get();
                if (result == null) {
                    throw new UnsupportedOperationException();
                }
                ref.set(null);
                return result;
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        Iterator iterator = this.iterator();
        if (iterator == null) {
            JBIterable.$$$reportNull$$$0(18);
        }
        return (T)iterator;
    }

    public final boolean processEach(@NotNull Processor<E> processor) {
        if (processor == null) {
            JBIterable.$$$reportNull$$$0(19);
        }
        return ContainerUtil.process(this, processor);
    }

    public final void consumeEach(@NotNull Consumer<E> consumer) {
        if (consumer == null) {
            JBIterable.$$$reportNull$$$0(20);
        }
        for (Object e : this) {
            consumer.consume(e);
        }
    }

    @NotNull
    public String toString() {
        String string = this.myIterable == this ? JBIterable.class.getSimpleName() : String.valueOf(this.myIterable);
        if (string == null) {
            JBIterable.$$$reportNull$$$0(21);
        }
        return string;
    }

    public final int size() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).size();
        }
        int count = 0;
        for (E ignored : this.myIterable) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).contains(element);
        }
        for (E e : this.myIterable) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index) {
        List<E> list = JBIterable.asRandomAccess(this.myIterable);
        if (list != null) {
            return index >= list.size() ? null : (E)list.get(index);
        }
        return this.skip(index).first();
    }

    @Nullable
    private static <E> List<E> asRandomAccess(@Nullable Iterable<E> iterable) {
        return iterable instanceof RandomAccess ? (List)iterable : null;
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        JBIterable<Object> jBIterable = other == null ? this : (this == EMPTY ? JBIterable.from(other) : JBIterable.of(this.myIterable, other).flatten(Functions.identity()));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        if (fun == null) {
            JBIterable.$$$reportNull$$$0(23);
        }
        JBIterable<Object> jBIterable = other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> repeat(int count) {
        Function fun = Functions.identity();
        JBIterable jBIterable = JBIterable.generate(this, fun).take(count).flatten(fun);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(25);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@NotNull E[] elements) {
        if (elements == null) {
            JBIterable.$$$reportNull$$$0(26);
        }
        JBIterable<Object> jBIterable = this == EMPTY ? JBIterable.of(elements) : this.append((E)Arrays.asList(elements));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(27);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E element) {
        JBIterable<Set<E>> jBIterable = element == null ? this : (this == EMPTY ? JBIterable.of(element) : this.append(Collections.singleton(element)));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> filter(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(29);
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).filter(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type) {
        if (type == null) {
            JBIterable.$$$reportNull$$$0(31);
        }
        JBIterable jBIterable = this.filter(Conditions.instanceOf(type));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(32);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> take(final int count) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).take(count);
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(33);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> takeWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(34);
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).takeWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(35);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skip(final int count) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skip(count);
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(36);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skipWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(37);
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skipWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(38);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> transform(final @NotNull Function<? super E, T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(39);
        }
        JBIterable<T> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).transform(Stateful.copy(function));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(40);
        }
        return jBIterable;
    }

    @NotNull
    public <T> JBIterable<T> flatten(final @NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(41);
        }
        JBIterable<T> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(final Iterator<E> iterator) {
                final Function fun = Stateful.copy(function);
                return new JBIterator<T>(){
                    Iterator<? extends T> cur;

                    @Override
                    public T nextImpl() {
                        if (this.cur != null && this.cur.hasNext()) {
                            return this.cur.next();
                        }
                        if (!iterator.hasNext()) {
                            return this.stop();
                        }
                        Iterable next = (Iterable)fun.fun(iterator.next());
                        this.cur = next == null ? null : next.iterator();
                        return this.skip();
                    }
                };
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(42);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> unique() {
        JBIterable<E> jBIterable = this.unique(Function.ID);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(43);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> unique(final @NotNull Function<? super E, ?> identity) {
        if (identity == null) {
            JBIterable.$$$reportNull$$$0(44);
        }
        JBIterable<E> jBIterable = this.filter(new SCond<E>(){
            HashSet<Object> visited;

            @Override
            public boolean value(E e) {
                if (this.visited == null) {
                    this.visited = new HashSet();
                }
                return this.visited.add(identity.fun(e));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(45);
        }
        return jBIterable;
    }

    @NotNull
    public final <T, X extends Iterator<E>> JBIterable<T> intercept(final @NotNull Function<X, ? extends Iterator<T>> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(46);
        }
        if (this == EMPTY) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(47);
            }
            return jBIterable;
        }
        final JBIterable thisIterable = this;
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (Iterator)function.fun(thisIterable.iterator());
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(48);
        }
        return jBIterable;
    }

    @Nullable
    public final E first() {
        List<E> list = JBIterable.asRandomAccess(this.myIterable);
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(0);
        }
        Iterator<E> iterator = this.myIterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Nullable
    public final E single() {
        List<E> list = JBIterable.asRandomAccess(this.myIterable);
        if (list != null) {
            return list.size() != 1 ? null : (E)list.get(0);
        }
        Iterator<E> iterator = this.myIterable.iterator();
        E first = iterator.hasNext() ? (E)iterator.next() : null;
        return iterator.hasNext() ? null : first;
    }

    @Nullable
    public final E last() {
        List<E> list = JBIterable.asRandomAccess(this.myIterable);
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(list.size() - 1);
        }
        E cur = null;
        for (E e : this.myIterable) {
            cur = e;
        }
        return cur;
    }

    public final <T> T reduce(@Nullable T first, @NotNull PairFunction<T, ? super E, T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(49);
        }
        T cur = first;
        for (Object e : this) {
            cur = function.fun(cur, e);
        }
        return cur;
    }

    public final E find(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(50);
        }
        return this.filter(condition).first();
    }

    public final int indexOf(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(51);
        }
        int index = 0;
        for (Object e : this) {
            if (condition.value(e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @NotNull
    public final <T> JBIterable<T> map(@NotNull Function<? super E, T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(52);
        }
        JBIterable<T> jBIterable = this.transform(function);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(53);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> filterMap(@NotNull Function<? super E, T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(54);
        }
        JBIterable<T> jBIterable = this.map(function).filter(Conditions.notNull());
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(55);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> flatMap(Function<? super E, ? extends Iterable<? extends T>> function) {
        JBIterable<T> jBIterable = this.map(function).flatten(Function.ID);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(56);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> join(final @Nullable E separator) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                final Iterator original = iterator;
                return new JBIterator<E>(){
                    boolean flag;

                    @Override
                    protected E nextImpl() {
                        if (!original.hasNext()) {
                            return this.stop();
                        }
                        this.flag = !this.flag;
                        return this.flag ? original.next() : separator;
                    }
                };
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(57);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<List<E>> split(final int size, final boolean strict) {
        JBIterable<List<E>> jBIterable = this.split(size).filterMap(new Function<JBIterable<E>, List<E>>(){

            @Override
            public List<E> fun(JBIterable<E> es) {
                List list = es.addAllTo(ContainerUtilRt.newArrayListWithCapacity(size));
                return strict && list.size() < size ? null : list;
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(58);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(size + " <= 0");
        }
        JBIterable<JBIterable<E>> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<JBIterable<E>>>(){

            @Override
            public Iterator<JBIterable<E>> fun(Iterator<E> iterator) {
                final Iterator orig = iterator;
                return new JBIterator<JBIterable<E>>(){
                    JBIterator<E> it;

                    @Override
                    protected JBIterable<E> nextImpl() {
                        JBIterable jBIterable;
                        while (this.it != null && this.it.advance()) {
                        }
                        this.it = null;
                        if (orig.hasNext()) {
                            this.it = JBIterator.wrap(orig);
                            jBIterable = JBIterable.once(this.it.take(size));
                        } else {
                            jBIterable = (JBIterable)this.stop();
                        }
                        return jBIterable;
                    }
                };
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(59);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final Split mode, final Condition<? super E> separator) {
        JBIterable<JBIterable<E>> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<JBIterable<E>>>(){

            @Override
            public Iterator<JBIterable<E>> fun(Iterator<E> iterator) {
                final Iterator orig = iterator;
                final Condition condition = Stateful.copy(separator);
                return new JBIterator<JBIterable<E>>(){
                    JBIterator<E> it;
                    E stored;
                    int st;

                    @Override
                    protected JBIterable<E> nextImpl() {
                        while (this.it != null && this.it.advance()) {
                        }
                        this.it = null;
                        if (this.stored == null && !orig.hasNext()) {
                            if (this.st < 0 && mode != Split.BEFORE && mode != Split.GROUP) {
                                this.st = 1;
                                return JBIterable.empty();
                            }
                            return (JBIterable)this.stop();
                        }
                        if (this.st == -2 && mode == Split.AROUND) {
                            this.st = -1;
                            return JBIterable.empty();
                        }
                        Object tmp = this.stored;
                        this.stored = null;
                        this.it = JBIterator.wrap(orig);
                        return JBIterable.of(tmp).append(JBIterable.once(this.it.takeWhile(new Condition<E>(){

                            @Override
                            public boolean value(E e) {
                                boolean result;
                                boolean sep = condition.value(e);
                                int st0 = st;
                                st = st0 < 0 && sep ? -2 : (st0 > 0 && !sep ? 2 : (sep ? -1 : 1));
                                switch (mode) {
                                    case AFTER: {
                                        result = st != -2 && (st != 1 || st0 == 0);
                                        break;
                                    }
                                    case BEFORE: {
                                        result = st != -2 && st != -1;
                                        break;
                                    }
                                    case AROUND: {
                                        result = st0 >= 0 && st > 0;
                                        break;
                                    }
                                    case GROUP: {
                                        result = st0 >= 0 && st > 0 || st0 <= 0 && st < 0;
                                        break;
                                    }
                                    case OFF: {
                                        result = st > 0;
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError(st);
                                    }
                                }
                                stored = !result && mode != Split.OFF ? e : null;
                                return result;
                            }
                        })));
                    }
                };
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(60);
        }
        return jBIterable;
    }

    public final boolean isEmpty() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).isEmpty();
        }
        return !this.myIterable.iterator().hasNext();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final JBIterable<E> collect(@NotNull Collection<E> collection) {
        if (collection == null) {
            JBIterable.$$$reportNull$$$0(61);
        }
        JBIterable<E> jBIterable = JBIterable.from(this.addAllTo(collection));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(62);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> collect() {
        if (this.myIterable instanceof ArrayList) {
            JBIterable jBIterable = this;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(63);
            }
            return jBIterable;
        }
        JBIterable jBIterable = this.collect(ContainerUtilRt.newArrayList());
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(64);
        }
        return jBIterable;
    }

    @NotNull
    public final List<E> toList() {
        List<E> list = Collections.unmodifiableList(ContainerUtilRt.newArrayList(this.myIterable));
        if (list == null) {
            JBIterable.$$$reportNull$$$0(65);
        }
        return list;
    }

    @NotNull
    public final Set<E> toSet() {
        Set<E> set = Collections.unmodifiableSet(ContainerUtilRt.newLinkedHashSet(this.myIterable));
        if (set == null) {
            JBIterable.$$$reportNull$$$0(66);
        }
        return set;
    }

    @NotNull
    public final <V> Map<E, V> toMap(Convertor<E, V> toValue) {
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (Object e : this) {
            map.put(e, toValue.convert(e));
        }
        Map map2 = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        if (map2 == null) {
            JBIterable.$$$reportNull$$$0(67);
        }
        return map2;
    }

    @NotNull
    public final <K> Map<K, E> toReverseMap(Convertor<E, K> toKey) {
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (Object e : this) {
            map.put(toKey.convert(e), e);
        }
        Map map2 = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        if (map2 == null) {
            JBIterable.$$$reportNull$$$0(68);
        }
        return map2;
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (collection == null) {
            JBIterable.$$$reportNull$$$0(69);
        }
        if (this.myIterable instanceof Collection) {
            collection.addAll((Collection)this.myIterable);
        } else {
            for (E item : this.myIterable) {
                collection.add(item);
            }
        }
        C c = collection;
        if (c == null) {
            JBIterable.$$$reportNull$$$0(70);
        }
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/JBIterable";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 29: 
            case 34: 
            case 37: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: 
            case 41: 
            case 46: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 61: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/JBIterable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "once";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "typedIterator";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "take";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "takeWhile";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "skip";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "skipWhile";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "transform";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "intercept";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMap";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "toSet";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "toReverseMap";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "once";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processEach";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "consumeEach";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "takeWhile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "skipWhile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "filterMap";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addAllTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class SFun<S, T>
    extends Stateful<SFun>
    implements Function<S, T> {
    }

    public static abstract class SCond<T>
    extends Stateful<SCond>
    implements Condition<T> {
    }

    public static abstract class Stateful<Self extends Stateful>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (o == null) {
                Stateful.$$$reportNull$$$0(0);
            }
            if (!(o instanceof Stateful)) {
                T t = o;
                if (t == null) {
                    Stateful.$$$reportNull$$$0(1);
                }
                return t;
            }
            Object object = ((Stateful)o).clone();
            if (object == null) {
                Stateful.$$$reportNull$$$0(2);
            }
            return (T)object;
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/JBIterable$Stateful";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/JBIterable$Stateful";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copy";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Split {
        AFTER,
        BEFORE,
        AROUND,
        OFF,
        GROUP;

    }
}

