/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfStatementWithIdenticalBranchesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.display.name", new Object[0]);
        if (string == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.problem.descriptor", new Object[0]);
        if (string == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseIfFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithIdenticalBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        private static PsiStatement unwrap(PsiStatement statement) {
            if (statement == null) {
                return null;
            }
            PsiElement[] children = DuplicatesFinder.getFilteredChildren(statement);
            if (children.length == 1 && children[0] instanceof PsiStatement) {
                return (PsiStatement)children[0];
            }
            return statement;
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                IfStatementWithIdenticalBranchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(ifStatement);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                PsiIfStatement statement = (PsiIfStatement)elseBranch;
                PsiStatement branch = IfStatementWithIdenticalBranchesVisitor.unwrap(statement.getThenBranch());
                if (branch != null && IfStatementWithIdenticalBranchesVisitor.isDuplicate(thenBranch, branch)) {
                    this.registerStatementError(ifStatement, new Object[0]);
                }
            } else if (elseBranch == null) {
                this.checkIfStatementWithoutElseBranch(ifStatement);
            } else if (IfStatementWithIdenticalBranchesVisitor.isDuplicate(thenBranch, elseBranch)) {
                this.registerStatementError(ifStatement, new Object[0]);
            }
        }

        private static boolean isDuplicate(@NotNull PsiStatement element1, @NotNull PsiStatement element2) {
            Match match1;
            if (element1 == null) {
                IfStatementWithIdenticalBranchesVisitor.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                IfStatementWithIdenticalBranchesVisitor.$$$reportNull$$$0(2);
            }
            if ((match1 = IfStatementWithIdenticalBranchesVisitor.findMatch(element1 = IfStatementWithIdenticalBranchesVisitor.unwrap(element1), element2 = IfStatementWithIdenticalBranchesVisitor.unwrap(element2))) == null) {
                return false;
            }
            Match match2 = IfStatementWithIdenticalBranchesVisitor.findMatch(element2, element1);
            if (match2 == null) {
                return false;
            }
            ReturnValue matchReturnValue1 = match1.getReturnValue();
            ReturnValue matchReturnValue2 = match2.getReturnValue();
            if (matchReturnValue1 == null) {
                return matchReturnValue2 == null;
            }
            return matchReturnValue1.isEquivalent(matchReturnValue2);
        }

        private static Match findMatch(@NotNull PsiStatement element1, @NotNull PsiStatement element2) {
            if (element1 == null) {
                IfStatementWithIdenticalBranchesVisitor.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                IfStatementWithIdenticalBranchesVisitor.$$$reportNull$$$0(4);
            }
            InputVariables inputVariables = new InputVariables(Collections.emptyList(), element1.getProject(), new LocalSearchScope(element1), false);
            DuplicatesFinder finder = new DuplicatesFinder(new PsiElement[]{element1}, inputVariables, null, Collections.emptyList());
            return finder.isDuplicate(element2, true);
        }

        private void checkIfStatementWithoutElseBranch(PsiIfStatement ifStatement) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            PsiStatement nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement(ifStatement);
            if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                PsiStatement lastStatement = statements[statements.length - 1];
                for (PsiStatement statement : statements) {
                    if (nextStatement == null) {
                        PsiReturnStatement returnStatement;
                        if (statement == lastStatement && statement instanceof PsiReturnStatement && (returnStatement = (PsiReturnStatement)statement).getReturnValue() == null) {
                            this.registerStatementError(ifStatement, new Object[0]);
                        }
                        return;
                    }
                    if (!EquivalenceChecker.getCanonicalPsiEquivalence().statementsAreEquivalent(statement, nextStatement)) {
                        return;
                    }
                    nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement(nextStatement);
                }
            } else if (!EquivalenceChecker.getCanonicalPsiEquivalence().statementsAreEquivalent(thenBranch, nextStatement)) {
                return;
            }
            this.registerStatementError(ifStatement, new Object[0]);
        }

        @Nullable
        private static PsiStatement getNextStatement(PsiStatement statement) {
            PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(statement, PsiStatement.class);
            while (nextStatement == null) {
                PsiElement nextStatementParent;
                PsiElement statementParent;
                if ((statement = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class)) == null) {
                    return null;
                }
                if (statement instanceof PsiLoopStatement) {
                    return statement;
                }
                nextStatement = PsiTreeUtil.getNextSiblingOfType(statement, PsiStatement.class);
                if (nextStatement == null || !((statementParent = statement.getParent()) instanceof PsiIfStatement) || !statementParent.equals(nextStatementParent = nextStatement.getParent())) continue;
                nextStatement = null;
            }
            return nextStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element1";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element2";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$IfStatementWithIdenticalBranchesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDuplicate";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CollapseIfFix
    extends InspectionGadgetsFix {
        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.collapse.quickfix", new Object[0]);
            if (string == null) {
                CollapseIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
            if (project == null) {
                CollapseIfFix.$$$reportNull$$$0(1);
            }
            PsiElement identifier = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)identifier.getParent();
            assert (statement != null);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                statement.delete();
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                PsiIfStatement elseIfStatement = (PsiIfStatement)elseBranch;
                PsiExpression condition1 = statement.getCondition();
                PsiExpression condition2 = elseIfStatement.getCondition();
                if (condition1 == null) {
                    return;
                }
                PsiReplacementUtil.replaceExpression(condition1, CollapseIfFix.buildOrExpressionText(condition1, condition2));
                PsiStatement elseElseBranch = elseIfStatement.getElseBranch();
                if (elseElseBranch == null) {
                    elseIfStatement.delete();
                } else {
                    elseIfStatement.replace(elseElseBranch);
                }
            } else {
                PsiElement parent = statement.getParent();
                if (thenBranch instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                    if (parent instanceof PsiCodeBlock) {
                        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                        PsiStatement[] statements = codeBlock.getStatements();
                        if (statements.length > 0) {
                            parent.addRangeBefore(statements[0], statements[statements.length - 1], statement);
                        }
                        statement.delete();
                    } else {
                        statement.replace(blockStatement);
                    }
                } else {
                    statement.replace(thenBranch);
                }
            }
        }

        private static String buildOrExpressionText(PsiExpression expression1, PsiExpression expression2) {
            StringBuilder result = new StringBuilder();
            if (expression1 != null) {
                result.append(expression1.getText());
            }
            result.append("||");
            if (expression2 != null) {
                result.append(expression2.getText());
            }
            return result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CollapseIfFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CollapseIfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

