/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountingLoop {
    @NotNull
    final PsiLocalVariable myCounter;
    @NotNull
    final PsiLoopStatement myLoop;
    @NotNull
    final PsiExpression myInitializer;
    @NotNull
    final PsiExpression myBound;
    final boolean myIncluding;

    private CountingLoop(@NotNull PsiLoopStatement loop, @NotNull PsiLocalVariable counter, @NotNull PsiExpression initializer, @NotNull PsiExpression bound, boolean including) {
        if (loop == null) {
            CountingLoop.$$$reportNull$$$0(0);
        }
        if (counter == null) {
            CountingLoop.$$$reportNull$$$0(1);
        }
        if (initializer == null) {
            CountingLoop.$$$reportNull$$$0(2);
        }
        if (bound == null) {
            CountingLoop.$$$reportNull$$$0(3);
        }
        this.myInitializer = initializer;
        this.myCounter = counter;
        this.myLoop = loop;
        this.myBound = bound;
        this.myIncluding = including;
    }

    @NotNull
    public PsiLocalVariable getCounter() {
        PsiLocalVariable psiLocalVariable = this.myCounter;
        if (psiLocalVariable == null) {
            CountingLoop.$$$reportNull$$$0(4);
        }
        return psiLocalVariable;
    }

    @NotNull
    public PsiLoopStatement getLoop() {
        PsiLoopStatement psiLoopStatement = this.myLoop;
        if (psiLoopStatement == null) {
            CountingLoop.$$$reportNull$$$0(5);
        }
        return psiLoopStatement;
    }

    @NotNull
    public PsiExpression getInitializer() {
        PsiExpression psiExpression = this.myInitializer;
        if (psiExpression == null) {
            CountingLoop.$$$reportNull$$$0(6);
        }
        return psiExpression;
    }

    @NotNull
    public PsiExpression getBound() {
        PsiExpression psiExpression = this.myBound;
        if (psiExpression == null) {
            CountingLoop.$$$reportNull$$$0(7);
        }
        return psiExpression;
    }

    public boolean isIncluding() {
        return this.myIncluding;
    }

    @Nullable
    public static CountingLoop from(PsiForStatement forStatement) {
        PsiExpression ref;
        PsiExpression bound;
        PsiDeclarationStatement initialization = ObjectUtils.tryCast(forStatement.getInitialization(), PsiDeclarationStatement.class);
        if (initialization == null || initialization.getDeclaredElements().length != 1) {
            return null;
        }
        PsiLocalVariable counter = ObjectUtils.tryCast(initialization.getDeclaredElements()[0], PsiLocalVariable.class);
        if (counter == null) {
            return null;
        }
        if (!counter.getType().equals(PsiType.INT) && !counter.getType().equals(PsiType.LONG)) {
            return null;
        }
        PsiExpression initializer = PsiUtil.skipParenthesizedExprDown(counter.getInitializer());
        if (initializer == null) {
            return null;
        }
        if (!VariableAccessUtils.variableIsIncremented(counter, forStatement.getUpdate())) {
            return null;
        }
        PsiBinaryExpression condition = ObjectUtils.tryCast(forStatement.getCondition(), PsiBinaryExpression.class);
        if (condition == null) {
            return null;
        }
        IElementType type = condition.getOperationTokenType();
        boolean closed = false;
        if (type.equals(JavaTokenType.LE)) {
            bound = condition.getROperand();
            ref = condition.getLOperand();
            closed = true;
        } else if (type.equals(JavaTokenType.LT)) {
            bound = condition.getROperand();
            ref = condition.getLOperand();
        } else if (type.equals(JavaTokenType.GE)) {
            bound = condition.getLOperand();
            ref = condition.getROperand();
            closed = true;
        } else if (type.equals(JavaTokenType.GT)) {
            bound = condition.getLOperand();
            ref = condition.getROperand();
        } else {
            return null;
        }
        if (bound == null || !ExpressionUtils.isReferenceTo(ref, counter)) {
            return null;
        }
        if (!TypeConversionUtil.areTypesAssignmentCompatible(counter.getType(), bound)) {
            return null;
        }
        return new CountingLoop(forStatement, counter, initializer, bound, closed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loop";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/CountingLoop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/CountingLoop";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCounter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoop";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

