/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHasherBase;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DuplicatesMatchingVisitor
extends AbstractMatchingVisitor {
    private final NodeSpecificHasherBase myNodeSpecificHasher;
    private final NodeFilter myNodeFilter;
    private final int myDiscardCost;
    private final TreeHasherBase myTreeHasher;
    private final Map<PsiElement, TreeHashResult> myPsiElement2HashAndCost;

    public DuplicatesMatchingVisitor(NodeSpecificHasherBase nodeSpecificHasher, @NotNull NodeFilter nodeFilter, int discardCost) {
        if (nodeFilter == null) {
            DuplicatesMatchingVisitor.$$$reportNull$$$0(0);
        }
        this.myPsiElement2HashAndCost = new HashMap<PsiElement, TreeHashResult>();
        this.myNodeSpecificHasher = nodeSpecificHasher;
        this.myNodeFilter = nodeFilter;
        this.myDiscardCost = discardCost;
        this.myTreeHasher = new TreeHasherBase(null, this.myNodeSpecificHasher.getDuplicatesProfile(), discardCost, false){

            @Override
            protected TreeHashResult hash(@NotNull PsiElement root, PsiFragment upper, @NotNull NodeSpecificHasher hasher) {
                TreeHashResult result;
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (hasher == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((result = (TreeHashResult)DuplicatesMatchingVisitor.this.myPsiElement2HashAndCost.get(root)) == null) {
                    result = super.hash(root, upper, hasher);
                    DuplicatesMatchingVisitor.this.myPsiElement2HashAndCost.put(root, result);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "hasher";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/dupLocator/treeHash/DuplicatesMatchingVisitor$1";
                objectArray[2] = "hash";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public boolean matchSequentially(NodeIterator nodes, NodeIterator nodes2) {
        while (nodes.hasNext() && nodes2.hasNext()) {
            DuplicatesMatchingVisitor.skipIfNeccessary(nodes, nodes2);
            DuplicatesMatchingVisitor.skipIfNeccessary(nodes2, nodes);
            if (!nodes.hasNext() || !nodes2.hasNext()) {
                return !nodes.hasNext() && !nodes2.hasNext();
            }
            if (!this.match(nodes.current(), nodes2.current())) {
                return false;
            }
            nodes.advance();
            nodes2.advance();
        }
        return !nodes.hasNext() && !nodes2.hasNext();
    }

    private static void skipIfNeccessary(NodeIterator nodes, NodeIterator nodes2) {
        while (DuplocatorUtil.shouldSkip(nodes2.current(), nodes.current())) {
            nodes2.advance();
        }
    }

    @Override
    public boolean match(PsiElement element1, PsiElement element2) {
        if (element1 == null || element2 == null) {
            return element1 == element2;
        }
        if (this.myDiscardCost > 0) {
            int cost1 = this.myTreeHasher.hash(element1, null, this.myNodeSpecificHasher).getCost();
            int cost2 = this.myTreeHasher.hash(element2, null, this.myNodeSpecificHasher).getCost();
            if (cost1 < this.myDiscardCost || cost2 < this.myDiscardCost) {
                return true;
            }
        }
        DuplicatesProfileBase duplicatesProfile = this.myNodeSpecificHasher.getDuplicatesProfile();
        PsiElementRole role1 = duplicatesProfile.getRole(element1);
        PsiElementRole role2 = duplicatesProfile.getRole(element2);
        EnumSet<PsiElementRole> skippedRoles = EnumSet.noneOf(PsiElementRole.class);
        ExternalizableDuplocatorState duplocatorState = duplicatesProfile.getDuplocatorState(duplicatesProfile.getLanguage(element1));
        for (PsiElementRole role : PsiElementRole.values()) {
            if (duplocatorState.distinguishRole(role)) continue;
            skippedRoles.add(role);
        }
        if (role1 == role2 && skippedRoles.contains((Object)role1)) {
            return true;
        }
        EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element1);
        EquivalenceDescriptor descriptor1 = descriptorProvider != null ? descriptorProvider.buildDescriptor(element1) : null;
        EquivalenceDescriptor descriptor2 = descriptorProvider != null ? descriptorProvider.buildDescriptor(element2) : null;
        PsiElement newElement1 = DuplocatorUtil.skipNodeIfNeccessary(element1, descriptor1, this.myNodeFilter);
        PsiElement newElement2 = DuplocatorUtil.skipNodeIfNeccessary(element2, descriptor2, this.myNodeFilter);
        if (newElement1 != element1 || newElement2 != element2) {
            return this.match(newElement1, newElement2);
        }
        if (!element1.getClass().equals(element2.getClass())) {
            return false;
        }
        if (descriptor1 != null && descriptor2 != null) {
            return DuplocatorUtil.match(descriptor1, descriptor2, (AbstractMatchingVisitor)this, skippedRoles, (DuplicatesProfile)duplicatesProfile);
        }
        if (element1 instanceof LeafElement) {
            IElementType elementType1 = ((LeafElement)((Object)element1)).getElementType();
            IElementType elementType2 = ((LeafElement)((Object)element2)).getElementType();
            if (!duplocatorState.distinguishLiterals() && duplicatesProfile.getLiterals().contains(elementType1) && duplicatesProfile.getLiterals().contains(elementType2)) {
                return true;
            }
            return element1.getText().equals(element2.getText());
        }
        if (element1.getFirstChild() == null && element1.getTextLength() == 0) {
            return element2.getFirstChild() == null && element2.getTextLength() == 0;
        }
        return this.matchSequentially(new FilteringNodeIterator(new SiblingNodeIterator(element1.getFirstChild()), this.getNodeFilter()), new FilteringNodeIterator(new SiblingNodeIterator(element2.getFirstChild()), this.getNodeFilter()));
    }

    @Override
    protected boolean doMatchInAnyOrder(NodeIterator it1, NodeIterator it2) {
        List list;
        int hash;
        TreeHashResult result;
        PsiElement element;
        ArrayList<PsiElement> elements1 = new ArrayList<PsiElement>();
        ArrayList<PsiElement> elements2 = new ArrayList<PsiElement>();
        while (it1.hasNext()) {
            element = it1.current();
            if (element != null) {
                elements1.add(element);
            }
            it1.advance();
        }
        while (it2.hasNext()) {
            element = it2.current();
            if (element != null) {
                elements2.add(element);
            }
            it2.advance();
        }
        if (elements1.size() != elements2.size()) {
            return false;
        }
        TIntObjectHashMap hash2element = new TIntObjectHashMap(elements1.size());
        for (PsiElement element2 : elements1) {
            result = this.myTreeHasher.hash(element2, null, this.myNodeSpecificHasher);
            if (result == null) continue;
            hash = result.getHash();
            list = (ArrayList<PsiElement>)hash2element.get(hash);
            if (list == null) {
                list = new ArrayList<PsiElement>();
                hash2element.put(hash, list);
            }
            list.add(element2);
        }
        for (PsiElement element2 : elements2) {
            result = this.myTreeHasher.hash(element2, null, this.myNodeSpecificHasher);
            if (result == null) continue;
            hash = result.getHash();
            list = (List)hash2element.get(hash);
            if (list == null) {
                return false;
            }
            boolean found = false;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (!this.match(element2, (PsiElement)it.next())) continue;
                it.remove();
                found = true;
            }
            if (!found) {
                return false;
            }
            if (list.size() != 0) continue;
            hash2element.remove(hash);
        }
        return hash2element.size() == 0;
    }

    @Override
    @NotNull
    protected NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = this.myNodeFilter;
        if (nodeFilter == null) {
            DuplicatesMatchingVisitor.$$$reportNull$$$0(1);
        }
        return nodeFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeFilter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/treeHash/DuplicatesMatchingVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/treeHash/DuplicatesMatchingVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

