/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MethodTextOccurrenceProcessor
extends RequestResultProcessor {
    private static final PsiReferenceService ourReferenceService = PsiReferenceService.getService();
    private final PsiMethod[] myMethods;
    protected final PsiClass myContainingClass;
    protected final boolean myStrictSignatureSearch;

    public MethodTextOccurrenceProcessor(@NotNull PsiClass aClass, boolean strictSignatureSearch, PsiMethod ... methods) {
        if (aClass == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(0);
        }
        super(strictSignatureSearch, Arrays.asList(methods));
        this.myMethods = methods;
        this.myContainingClass = aClass;
        this.myStrictSignatureSearch = strictSignatureSearch;
    }

    @Override
    public final boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<PsiReference> consumer) {
        if (element == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(2);
        }
        for (PsiReference ref : ourReferenceService.getReferences(element, new PsiReferenceService.Hints(this.myMethods[0], offsetInElement))) {
            if (!ReferenceRange.containsOffsetInElement(ref, offsetInElement) || this.processReference(consumer, ref)) continue;
            return false;
        }
        return true;
    }

    private boolean processReference(Processor<PsiReference> consumer, PsiReference ref) {
        for (PsiMethod method : this.myMethods) {
            if (!method.isValid()) continue;
            if (ref instanceof ResolvingHint && !((ResolvingHint)((Object)ref)).canResolveTo(PsiMethod.class)) {
                return true;
            }
            if (ref.isReferenceTo(method)) {
                return consumer.process(ref);
            }
            if (this.processInexactReference(ref, ref.resolve(), method, consumer)) continue;
            return false;
        }
        return true;
    }

    protected boolean processInexactReference(PsiReference ref, PsiElement refElement, PsiMethod method, Processor<PsiReference> consumer) {
        if (refElement instanceof PsiMethod) {
            PsiManager manager;
            MethodSignature refSignature;
            MethodSignature superSignature;
            PsiSubstitutor substitutor;
            PsiMethod refMethod = (PsiMethod)refElement;
            PsiClass refMethodClass = refMethod.getContainingClass();
            if (refMethodClass == null) {
                return true;
            }
            if (!refMethod.hasModifierProperty("static") && (substitutor = TypeConversionUtil.getClassSubstitutor(this.myContainingClass, refMethodClass, PsiSubstitutor.EMPTY)) != null && MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(substitutor), refSignature = refMethod.getSignature(PsiSubstitutor.EMPTY)) && !consumer.process(ref)) {
                return false;
            }
            if (!this.myStrictSignatureSearch && (manager = method.getManager()).areElementsEquivalent(refMethodClass, this.myContainingClass) && !consumer.process(ref)) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/MethodTextOccurrenceProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processTextOccurrence";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

