/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nullable;

public abstract class XsdEnumerationDescriptor<T extends XmlElement>
extends XmlEnumerationDescriptor<T> {
    private boolean myExhaustiveEnum;

    public abstract XmlTag getDeclaration();

    @Override
    public String getDefaultValue() {
        if (this.isFixed()) {
            return this.getDeclaration().getAttributeValue("fixed");
        }
        return this.getDeclaration().getAttributeValue("default");
    }

    @Override
    public boolean isFixed() {
        return this.getDeclaration().getAttributeValue("fixed") != null;
    }

    @Override
    public String[] getEnumeratedValues() {
        return this.getEnumeratedValues(false);
    }

    @Override
    public String[] getValuesForCompletion() {
        return this.getEnumeratedValues(true);
    }

    private String[] getEnumeratedValues(boolean forCompletion) {
        SmartList<String> list = new SmartList<String>();
        this.processEnumeration(null, (element, s) -> {
            list.add((String)s);
            return true;
        }, forCompletion);
        String defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            list.add(defaultValue);
        }
        return ArrayUtil.toStringArray(list);
    }

    private boolean processEnumeration(XmlElement context, PairProcessor<PsiElement, String> processor, boolean forCompletion) {
        if (this.getDeclaration() == null) {
            return false;
        }
        XmlTag contextTag = context != null ? PsiTreeUtil.getContextOfType((PsiElement)context, XmlTag.class, false) : null;
        XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType(this.getDeclaration(), contextTag);
        if (elementDescriptor != null && elementDescriptor.getType() instanceof ComplexTypeDescriptor) {
            TypeDescriptor type = elementDescriptor.getType();
            return this.processEnumerationImpl(type.getDeclaration(), (ComplexTypeDescriptor)type, processor, forCompletion);
        }
        String namespacePrefix = this.getDeclaration().getNamespacePrefix();
        XmlTag type = this.getDeclaration().findFirstSubTag((namespacePrefix.length() > 0 ? namespacePrefix + ":" : "") + "simpleType");
        if (type != null) {
            return this.processEnumerationImpl(type, null, processor, forCompletion);
        }
        return false;
    }

    private boolean processEnumerationImpl(XmlTag declaration, @Nullable ComplexTypeDescriptor type, PairProcessor<PsiElement, String> pairProcessor, boolean forCompletion) {
        String namespace;
        XmlNSDescriptorImpl nsDescriptor;
        XmlAttribute name = declaration.getAttribute("name");
        if (name != null && "boolean".equals(name.getValue()) && type != null && (nsDescriptor = type.getNsDescriptor()) != null && "http://www.w3.org/2001/XMLSchema".equals(namespace = nsDescriptor.getDefaultNamespace())) {
            XmlAttributeValue valueElement = name.getValueElement();
            pairProcessor.process(valueElement, "true");
            pairProcessor.process(valueElement, "false");
            if (!forCompletion) {
                pairProcessor.process(valueElement, "1");
                pairProcessor.process(valueElement, "0");
            }
            this.myExhaustiveEnum = true;
            return true;
        }
        Ref<Boolean> found = new Ref<Boolean>(Boolean.FALSE);
        this.myExhaustiveEnum = XmlUtil.processEnumerationValues(declaration, tag -> {
            found.set(Boolean.TRUE);
            XmlAttribute name1 = tag.getAttribute("value");
            return name1 == null || pairProcessor.process((PsiElement)tag, name1.getValue());
        });
        return found.get();
    }

    @Override
    public PsiElement getValueDeclaration(XmlElement attributeValue, String value) {
        PsiElement declaration = super.getValueDeclaration(attributeValue, value);
        if (declaration == null && !this.myExhaustiveEnum) {
            return this.getDeclaration();
        }
        return declaration;
    }

    @Override
    public boolean isEnumerated(@Nullable XmlElement context) {
        return this.processEnumeration(context, PairProcessor.TRUE, false);
    }

    @Override
    public PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        Ref result = new Ref();
        this.processEnumeration(this.getDeclaration(), (element, s) -> {
            if (value.equals(s)) {
                result.set(element);
                return false;
            }
            return true;
        }, false);
        return (PsiElement)result.get();
    }

    @Override
    protected PsiElement getDefaultValueDeclaration() {
        return this.getDeclaration();
    }
}

