/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.VisibilityUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangeModifierFix
extends InspectionGadgetsFix {
    @PsiModifier.ModifierConstant
    private final String modifierText;

    public ChangeModifierFix(@NonNls @PsiModifier.ModifierConstant String modifierText) {
        this.modifierText = modifierText;
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("change.modifier.quickfix", VisibilityUtil.toPresentableText(this.modifierText));
        if (string == null) {
            ChangeModifierFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Change modifier" == null) {
            ChangeModifierFix.$$$reportNull$$$0(1);
        }
        return "Change modifier";
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiModifierListOwner modifierListOwner = PsiTreeUtil.getParentOfType(element, PsiModifierListOwner.class);
        if (modifierListOwner == null) {
            return;
        }
        PsiModifierList modifiers = modifierListOwner.getModifierList();
        if (modifiers == null) {
            return;
        }
        modifiers.setModifierProperty(this.modifierText, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/ChangeModifierFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

