/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ComparisonToNaNInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparison.to.nan.display.name", new Object[0]);
        if (string == null) {
            ComparisonToNaNInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiBinaryExpression comparison = (PsiBinaryExpression)infos[0];
        IElementType tokenType = comparison.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            String string = InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor1", new Object[0]);
            if (string == null) {
                ComparisonToNaNInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor2", new Object[0]);
        if (string == null) {
            ComparisonToNaNInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ComparisonToNaNVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ComparisonToNaNFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/ComparisonToNaNInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ComparisonToNaNVisitor
    extends BaseInspectionVisitor {
        private ComparisonToNaNVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ComparisonToNaNVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (rhs == null || !TypeUtils.hasFloatingPointType(lhs) && !TypeUtils.hasFloatingPointType(rhs)) {
                return;
            }
            if (ComparisonToNaNVisitor.isNaN(lhs)) {
                this.registerError((PsiElement)lhs, expression);
            } else if (ComparisonToNaNVisitor.isNaN(rhs)) {
                this.registerError((PsiElement)rhs, expression);
            }
        }

        private static boolean isNaN(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            String referenceName = referenceExpression.getReferenceName();
            if (!"NaN".equals(referenceName)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String qualifiedName = containingClass.getQualifiedName();
            return "java.lang.Double".equals(qualifiedName) || "java.lang.Float".equals(qualifiedName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/ComparisonToNaNInspection$ComparisonToNaNVisitor", "visitBinaryExpression"));
        }
    }

    private static class ComparisonToNaNFix
    extends InspectionGadgetsFix {
        private ComparisonToNaNFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("comparison.to.nan.replace.quickfix", new Object[0]);
            if (string == null) {
                ComparisonToNaNFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression nanExpression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiElement target = nanExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String typeText = containingClass.getQualifiedName();
            PsiBinaryExpression comparison = (PsiBinaryExpression)nanExpression.getParent();
            PsiExpression lhs = comparison.getLOperand();
            PsiExpression rhs = comparison.getROperand();
            PsiExpression operand = nanExpression.equals(lhs) ? rhs : lhs;
            assert (operand != null);
            String operandText = operand.getText();
            IElementType tokenType = comparison.getOperationTokenType();
            String negationText = tokenType.equals(JavaTokenType.EQEQ) ? "" : "!";
            String newExpressionText = negationText + typeText + ".isNaN(" + operandText + ')';
            PsiReplacementUtil.replaceExpression(comparison, newExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ComparisonToNaNInspection$ComparisonToNaNFix", "getFamilyName"));
        }
    }
}

