/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.SortedIntSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EqClass
extends SortedIntSet {
    private final DfaValueFactory myFactory;

    EqClass(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    EqClass(@NotNull EqClass toCopy) {
        if (toCopy == null) {
            EqClass.$$$reportNull$$$0(0);
        }
        super(toCopy.toNativeArray());
        this.myFactory = toCopy.myFactory;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            int value = this.get(i);
            DfaValue dfaValue = this.myFactory.getValue(value);
            buf.append(dfaValue);
        }
        buf.append(")");
        return buf.toString();
    }

    List<DfaVariableValue> getVariables(boolean unwrap) {
        ArrayList<DfaVariableValue> vars = ContainerUtil.newArrayList();
        for (DfaValue value : this.getMemberValues()) {
            if (unwrap) {
                value = DfaMemoryStateImpl.unwrap(value);
            }
            if (!(value instanceof DfaVariableValue)) continue;
            vars.add((DfaVariableValue)value);
        }
        return vars;
    }

    List<DfaValue> getMemberValues() {
        ArrayList<DfaValue> result = new ArrayList<DfaValue>(this.size());
        this.forEach(c1 -> {
            DfaValue value = this.myFactory.getValue(c1);
            result.add(value);
            return true;
        });
        return result;
    }

    @Nullable
    DfaValue findConstant(boolean wrapped) {
        for (DfaValue value : this.getMemberValues()) {
            if (!(value instanceof DfaConstValue) && (!wrapped || !(DfaMemoryStateImpl.unwrap(value) instanceof DfaConstValue))) continue;
            return value;
        }
        return null;
    }

    @Nullable
    private static DfaConstValue asConstantValue(DfaValue value) {
        return (value = DfaMemoryStateImpl.unwrap(value)) instanceof DfaConstValue ? (DfaConstValue)value : null;
    }

    boolean containsConstantsOnly() {
        for (int i = 0; i < this.size(); ++i) {
            if (EqClass.asConstantValue(this.myFactory.getValue(this.get(i))) != null) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCopy", "com/intellij/codeInspection/dataFlow/EqClass", "<init>"));
    }
}

