/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class FormatDecode {
    private static final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d*)?([tT])?([a-zA-Z%])");
    private static final Validator ALL_VALIDATOR = new AllValidator();
    private static final int LEFT_JUSTIFY = 1;
    private static final int ALTERNATE = 2;
    private static final int PLUS = 4;
    private static final int LEADING_SPACE = 8;
    private static final int ZERO_PAD = 16;
    private static final int GROUP = 32;
    private static final int PARENTHESES = 64;
    private static final int PREVIOUS = 128;

    private FormatDecode() {
    }

    private static int flag(char c) {
        switch (c) {
            case '-': {
                return 1;
            }
            case '#': {
                return 2;
            }
            case '+': {
                return 4;
            }
            case ' ': {
                return 8;
            }
            case '0': {
                return 16;
            }
            case ',': {
                return 32;
            }
            case '(': {
                return 64;
            }
            case '<': {
                return 128;
            }
        }
        return -1;
    }

    private static String flagString(int flags) {
        StringBuilder result = new StringBuilder(8);
        if ((flags & 1) != 0) {
            result.append('-');
        }
        if ((flags & 2) != 0) {
            result.append('#');
        }
        if ((flags & 4) != 0) {
            result.append('+');
        }
        if ((flags & 8) != 0) {
            result.append(' ');
        }
        if ((flags & 0x10) != 0) {
            result.append('0');
        }
        if ((flags & 0x20) != 0) {
            result.append(',');
        }
        if ((flags & 0x40) != 0) {
            result.append('(');
        }
        if ((flags & 0x80) != 0) {
            result.append('<');
        }
        return result.toString();
    }

    private static void checkFlags(int value, int allowedFlags, String specifier) {
        int result = value & ~allowedFlags;
        if (result != 0) {
            String flags = FormatDecode.flagString(result);
            String word = flags.length() == 1 ? "flag '" : "flags '";
            throw new IllegalFormatException(word + flags + "' not allowed in '" + specifier + '\'');
        }
    }

    @NotNull
    public static Validator[] decode(String formatString, int argumentCount) {
        ArrayList<Validator> parameters = new ArrayList<Validator>();
        Matcher matcher = fsPattern.matcher(formatString);
        boolean previousAllowed = false;
        int implicit = 0;
        int pos = 0;
        int i = 0;
        while (matcher.find(i)) {
            Validator allowed;
            int start = matcher.start();
            if (start != i) {
                FormatDecode.checkText(formatString.substring(i, start));
            }
            i = matcher.end();
            String specifier = matcher.group();
            String posSpec = matcher.group(1);
            String flags = matcher.group(2);
            String width = matcher.group(3);
            String precision = matcher.group(4);
            String dateSpec = matcher.group(5);
            String conversion = matcher.group(6);
            int flagBits = 0;
            for (int j = 0; j < flags.length(); ++j) {
                char flag = flags.charAt(j);
                int bit = FormatDecode.flag(flag);
                if (bit == -1) {
                    throw new IllegalFormatException("unexpected character '" + flag + "' in '" + specifier + '\'');
                }
                if ((flagBits | bit) == flagBits) {
                    throw new IllegalFormatException("duplicate flag '" + flag + "' in '" + specifier + '\'');
                }
                flagBits |= bit;
            }
            if ("n".equals(conversion)) {
                FormatDecode.checkFlags(flagBits, 0, specifier);
                if (!StringUtil.isEmpty(width)) {
                    throw new IllegalFormatException("width ('" + width + "') not allowed in '" + specifier + '\'');
                }
                FormatDecode.checkNoPrecision(precision, specifier);
                continue;
            }
            if ("%".equals(conversion)) {
                FormatDecode.checkFlags(flagBits, 1, specifier);
                FormatDecode.checkNoPrecision(precision, specifier);
                continue;
            }
            if (posSpec != null) {
                if (FormatDecode.isAllBitsSet(flagBits, 128)) {
                    throw new IllegalFormatException("unnecessary argument position specifier '" + posSpec + "' in '" + specifier + '\'');
                }
                String num = posSpec.substring(0, posSpec.length() - 1);
                pos = Integer.parseInt(num) - 1;
                if (pos < 0) {
                    throw new IllegalFormatException("illegal position specifier '" + posSpec + "' in '" + specifier + '\'');
                }
                previousAllowed = true;
            } else if (FormatDecode.isAllBitsSet(flagBits, 128)) {
                if (!previousAllowed) {
                    throw new IllegalFormatException("previous flag '<' used but no previous format specifier found for '" + specifier + '\'');
                }
            } else {
                previousAllowed = true;
                pos = implicit++;
            }
            if (dateSpec != null) {
                FormatDecode.checkFlags(flagBits, 129, specifier);
                FormatDecode.checkNoPrecision(precision, specifier);
                allowed = new DateValidator(specifier);
            } else {
                switch (conversion.charAt(0)) {
                    case 'B': 
                    case 'H': 
                    case 'b': 
                    case 'h': {
                        FormatDecode.checkFlags(flagBits, 129, specifier);
                        allowed = ALL_VALIDATOR;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        FormatDecode.checkFlags(flagBits, 131, specifier);
                        allowed = (flagBits & 2) != 0 ? new FormattableValidator(specifier) : ALL_VALIDATOR;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        FormatDecode.checkFlags(flagBits, 129, specifier);
                        FormatDecode.checkNoPrecision(precision, specifier);
                        allowed = new CharValidator(specifier);
                        break;
                    }
                    case 'd': {
                        FormatDecode.checkFlags(flagBits, -3, specifier);
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'X': 
                    case 'o': 
                    case 'x': {
                        FormatDecode.checkFlags(flagBits, -45, specifier);
                        FormatDecode.checkNoPrecision(precision, specifier);
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        FormatDecode.checkFlags(flagBits, -97, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        FormatDecode.checkFlags(flagBits, -33, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        FormatDecode.checkFlags(flagBits, -3, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'f': {
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    default: {
                        throw new IllegalFormatException("unknown conversion in '" + specifier + '\'');
                    }
                }
            }
            if (precision != null && precision.length() < 2) {
                throw new IllegalFormatException("invalid precision specified in '" + specifier + '\'');
            }
            if (FormatDecode.isAllBitsSet(flagBits, 12)) {
                throw new IllegalFormatException("illegal flag combination ' ' and '+' in '" + specifier + '\'');
            }
            if (FormatDecode.isAllBitsSet(flagBits, 17)) {
                throw new IllegalFormatException("illegal flag combination '-' and '0' in '" + specifier + '\'');
            }
            if (StringUtil.isEmpty(width)) {
                if (FormatDecode.isAllBitsSet(flagBits, 1)) {
                    throw new IllegalFormatException("left justify flag '-' used but width not specified in '" + specifier + '\'');
                }
                if (FormatDecode.isAllBitsSet(flagBits, 16)) {
                    throw new IllegalFormatException("zero padding flag '0' used but width not specified in '" + specifier + '\'');
                }
            }
            FormatDecode.storeValidator(allowed, pos, parameters, argumentCount);
        }
        if (i < formatString.length()) {
            FormatDecode.checkText(formatString.substring(i));
        }
        Validator[] validatorArray = parameters.toArray(new Validator[parameters.size()]);
        if (validatorArray == null) {
            FormatDecode.$$$reportNull$$$0(0);
        }
        return validatorArray;
    }

    private static void checkNoPrecision(String precision, String specifier) {
        if (!StringUtil.isEmpty(precision)) {
            throw new IllegalFormatException("precision ('" + precision + "') not allowed in '" + specifier + '\'');
        }
    }

    private static boolean isAllBitsSet(int value, int mask) {
        return (value & mask) == mask;
    }

    private static void checkText(String s) {
        if (s.indexOf(37) != -1) {
            throw new IllegalFormatException();
        }
    }

    private static void storeValidator(Validator validator, int pos, ArrayList<Validator> parameters, int argumentCount) {
        if (pos < parameters.size()) {
            Validator existing = parameters.get(pos);
            if (existing == null) {
                parameters.set(pos, validator);
            } else if (existing instanceof MultiValidator) {
                ((MultiValidator)existing).addValidator(validator);
            } else if (existing != validator) {
                MultiValidator multiValidator = new MultiValidator(existing.getSpecifier());
                multiValidator.addValidator(existing);
                multiValidator.addValidator(validator);
                parameters.set(pos, multiValidator);
            }
        } else {
            while (pos > parameters.size() && argumentCount > parameters.size()) {
                parameters.add(null);
            }
            parameters.add(validator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/FormatDecode", "decode"));
    }

    static abstract class Validator {
        private final String mySpecifier;

        public Validator(String specifier) {
            this.mySpecifier = specifier;
        }

        public abstract boolean valid(PsiType var1);

        public String getSpecifier() {
            return this.mySpecifier;
        }
    }

    private static class MultiValidator
    extends Validator {
        private final Set<Validator> validators = new HashSet<Validator>(3);

        public MultiValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            for (Validator validator : this.validators) {
                if (validator.valid(type)) continue;
                return false;
            }
            return true;
        }

        public void addValidator(Validator validator) {
            this.validators.add(validator);
        }
    }

    private static class FormattableValidator
    extends Validator {
        public FormattableValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            return InheritanceUtil.isInheritor(type, "java.util.Formattable");
        }
    }

    private static class FloatValidator
    extends Validator {
        public FloatValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text2 = type.getCanonicalText();
            return PsiType.DOUBLE.equals(type) || "java.lang.Double".equals(text2) || PsiType.FLOAT.equals(type) || "java.lang.Float".equals(text2) || "java.math.BigDecimal".equals(text2);
        }
    }

    private static class IntValidator
    extends Validator {
        public IntValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text2 = type.getCanonicalText();
            return PsiType.INT.equals(type) || "java.lang.Integer".equals(text2) || PsiType.LONG.equals(type) || "java.lang.Long".equals(text2) || PsiType.SHORT.equals(type) || "java.lang.Short".equals(text2) || PsiType.BYTE.equals(type) || "java.lang.Byte".equals(text2) || "java.math.BigInteger".equals(text2);
        }
    }

    private static class CharValidator
    extends Validator {
        public CharValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            if (PsiType.CHAR.equals(type) || PsiType.BYTE.equals(type) || PsiType.SHORT.equals(type) || PsiType.INT.equals(type)) {
                return true;
            }
            String text2 = type.getCanonicalText();
            return "java.lang.Character".equals(text2) || "java.lang.Byte".equals(text2) || "java.lang.Short".equals(text2) || "java.lang.Integer".equals(text2);
        }
    }

    private static class DateValidator
    extends Validator {
        public DateValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text2 = type.getCanonicalText();
            return PsiType.LONG.equals(type) || "java.lang.Long".equals(text2) || InheritanceUtil.isInheritor(type, "java.util.Date") || InheritanceUtil.isInheritor(type, "java.util.Calendar") || InheritanceUtil.isInheritor(type, "java.time.temporal.TemporalAccessor");
        }
    }

    private static class AllValidator
    extends Validator {
        public AllValidator() {
            super("");
        }

        @Override
        public boolean valid(PsiType type) {
            return true;
        }
    }

    public static class IllegalFormatException
    extends RuntimeException {
        public IllegalFormatException(String message) {
            super(message);
        }

        public IllegalFormatException() {
        }
    }
}

