/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableUninitializedUseInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @Override
    @NotNull
    public String getID() {
        if ("StaticVariableUsedBeforeInitialization" == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(0);
        }
        return "StaticVariableUsedBeforeInitialization";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.variable.used.before.initialization.display.name", new Object[0]);
        if (string == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.variable.used.before.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), this, "m_ignorePrimitives");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/StaticVariableUninitializedUseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private StaticVariableInitializationVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            PsiExpression[] moreBadReads;
            PsiMethod[] methods;
            PsiType type;
            if (field == null) {
                StaticVariableInitializationVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            if (StaticVariableUninitializedUseInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(type = field.getType())) {
                return;
            }
            PsiClassInitializer[] initializers = containingClass.getInitializers();
            UninitializedReadCollector uninitializedReadCollector = new UninitializedReadCollector();
            boolean assigned = false;
            for (PsiClassInitializer initializer : initializers) {
                PsiCodeBlock body;
                if (!initializer.hasModifierProperty("static") || !uninitializedReadCollector.blockAssignsVariable(body = initializer.getBody(), field)) continue;
                assigned = true;
                break;
            }
            if (assigned) {
                PsiExpression[] badReads;
                for (PsiExpression badRead : badReads = uninitializedReadCollector.getUninitializedReads()) {
                    this.registerError((PsiElement)badRead, new Object[0]);
                }
                return;
            }
            for (PsiMethod method : methods = containingClass.getMethods()) {
                if (!method.hasModifierProperty("static")) continue;
                PsiCodeBlock body = method.getBody();
                uninitializedReadCollector.blockAssignsVariable(body, field);
            }
            for (PsiExpression badRead : moreBadReads = uninitializedReadCollector.getUninitializedReads()) {
                this.registerError((PsiElement)badRead, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/initialization/StaticVariableUninitializedUseInspection$StaticVariableInitializationVisitor", "visitField"));
        }
    }
}

