/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.if.statement.display.name", new Object[0]);
        if (string == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableIfStatementVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiIfStatement statement = (PsiIfStatement)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.if.statement.problem.descriptor", StringUtil.escapeXml(SimplifiableIfStatementInspection.calculateReplacementStatement(statement)));
        if (string == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementStatement(PsiIfStatement statement) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
        if (thenBranch == null) {
            return null;
        }
        PsiStatement elseBranch = statement.getElseBranch();
        if (elseBranch == null) {
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward(statement);
            if (nextStatement instanceof PsiStatement) {
                elseBranch = (PsiStatement)nextStatement;
            }
        } else {
            elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        }
        if (elseBranch == null) {
            return null;
        }
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return null;
        }
        if (thenBranch instanceof PsiReturnStatement && elseBranch instanceof PsiReturnStatement) {
            return SimplifiableIfStatementInspection.calculateReplacementReturnStatement(thenBranch, elseBranch, condition);
        }
        if (thenBranch instanceof PsiExpressionStatement && elseBranch instanceof PsiExpressionStatement) {
            PsiExpressionStatement thenStatement = (PsiExpressionStatement)thenBranch;
            PsiExpressionStatement elseStatement = (PsiExpressionStatement)elseBranch;
            PsiExpression thenExpression = thenStatement.getExpression();
            PsiExpression elseExpression = elseStatement.getExpression();
            if (!(thenExpression instanceof PsiAssignmentExpression) || !(elseExpression instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression thenAssignment = (PsiAssignmentExpression)thenExpression;
            PsiAssignmentExpression elseAssignment = (PsiAssignmentExpression)elseExpression;
            return SimplifiableIfStatementInspection.calculateReplacementAssignmentStatement(thenAssignment, elseAssignment, condition);
        }
        return null;
    }

    private static String calculateReplacementAssignmentStatement(PsiAssignmentExpression thenAssignment, PsiAssignmentExpression elseAssignment, PsiExpression condition) {
        PsiExpression lhs = thenAssignment.getLExpression();
        PsiExpression thenRhs = thenAssignment.getRExpression();
        if (thenRhs == null) {
            return "";
        }
        PsiExpression elseRhs = elseAssignment.getRExpression();
        if (elseRhs == null) {
            return "";
        }
        PsiJavaToken token = elseAssignment.getOperationSign();
        return lhs.getText() + ' ' + token.getText() + ' ' + SimplifiableIfStatementInspection.getCombinedConditionText(condition, thenRhs, elseRhs) + ';';
    }

    @NonNls
    private static String calculateReplacementReturnStatement(PsiStatement thenBranch, PsiStatement elseBranch, PsiExpression condition) {
        PsiReturnStatement thenReturnStatement = (PsiReturnStatement)thenBranch;
        PsiExpression thenReturnValue = thenReturnStatement.getReturnValue();
        if (thenReturnValue == null) {
            return "";
        }
        PsiReturnStatement elseReturnStatement = (PsiReturnStatement)elseBranch;
        PsiExpression elseReturnValue = elseReturnStatement.getReturnValue();
        if (elseReturnValue == null) {
            return "";
        }
        return "return " + SimplifiableIfStatementInspection.getCombinedConditionText(condition, thenReturnValue, elseReturnValue) + ';';
    }

    @NotNull
    private static String getCombinedConditionText(PsiExpression condition, PsiExpression thenValue, PsiExpression elseValue) {
        if (BoolUtils.isTrue(thenValue)) {
            String string = SimplifiableIfStatementInspection.joinConditions(condition, elseValue, false);
            if (string == null) {
                SimplifiableIfStatementInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (BoolUtils.isFalse(thenValue)) {
            String string = BoolUtils.getNegatedExpressionText(condition, 13) + " && " + SimplifiableIfStatementInspection.buildExpressionText(elseValue, 13);
            if (string == null) {
                SimplifiableIfStatementInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (BoolUtils.isTrue(elseValue)) {
            String string = BoolUtils.getNegatedExpressionText(condition, 14) + " || " + SimplifiableIfStatementInspection.buildExpressionText(thenValue, 14);
            if (string == null) {
                SimplifiableIfStatementInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = SimplifiableIfStatementInspection.joinConditions(condition, thenValue, true);
        if (string == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String joinConditions(PsiExpression left, PsiExpression right, boolean isAnd) {
        IElementType tokenType;
        String token;
        int precedence;
        if (isAnd) {
            precedence = 13;
            token = " && ";
            tokenType = JavaTokenType.ANDAND;
        } else {
            precedence = 14;
            token = " || ";
            tokenType = JavaTokenType.OROR;
        }
        PsiPolyadicExpression leftPolyadic = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(left), PsiPolyadicExpression.class);
        PsiPolyadicExpression rightPolyadic = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(right), PsiPolyadicExpression.class);
        if (rightPolyadic != null && rightPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(ArrayUtil.getFirstElement(rightPolyadic.getOperands()), left) && !SideEffectChecker.mayHaveSideEffects(left)) {
            String string = SimplifiableIfStatementInspection.buildExpressionText(rightPolyadic, 17);
            if (string == null) {
                SimplifiableIfStatementInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (leftPolyadic != null && leftPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(ArrayUtil.getLastElement(leftPolyadic.getOperands()), right) && !SideEffectChecker.mayHaveSideEffects(right)) {
            String string = SimplifiableIfStatementInspection.buildExpressionText(leftPolyadic, 17);
            if (string == null) {
                SimplifiableIfStatementInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = SimplifiableIfStatementInspection.buildExpressionText(left, precedence) + token + SimplifiableIfStatementInspection.buildExpressionText(right, precedence);
        if (string == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static String buildExpressionText(PsiExpression expression, int precedence) {
        StringBuilder builder = new StringBuilder();
        if (ParenthesesUtils.getPrecedence(expression) > precedence) {
            builder.append('(');
            SimplifiableIfStatementInspection.appendPresentableText(expression, builder);
            builder.append(')');
        } else {
            SimplifiableIfStatementInspection.appendPresentableText(expression, builder);
        }
        return builder.toString();
    }

    private static void appendPresentableText(@Nullable PsiElement element, StringBuilder builder) {
        if (element == null) {
            return;
        }
        if (element instanceof PsiWhiteSpace) {
            PsiComment comment;
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals((comment = (PsiComment)prevSibling).getTokenType())) {
                builder.append('\n');
                return;
            }
            builder.append(' ');
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            builder.append(element.getText());
        } else {
            for (PsiElement child : children) {
                SimplifiableIfStatementInspection.appendPresentableText(child, builder);
            }
        }
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableIfStatementFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/SimplifiableIfStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedConditionText";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "joinConditions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SimplifiableIfStatementVisitor
    extends BaseInspectionVisitor {
        private SimplifiableIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            if (statement.getCondition() == null) {
                return;
            }
            if (!SimplifiableIfStatementVisitor.isReplaceableAssignment(statement) && !SimplifiableIfStatementVisitor.isReplaceableReturn(statement)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        public static boolean isReplaceableReturn(PsiIfStatement ifStatement) {
            PsiElement nextStatement;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            thenBranch = ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if ((elseBranch = ControlFlowUtils.stripBraces(elseBranch)) == null && (nextStatement = PsiTreeUtil.skipWhitespacesForward(ifStatement)) instanceof PsiStatement) {
                elseBranch = (PsiStatement)nextStatement;
            }
            if (!(thenBranch instanceof PsiReturnStatement) || !(elseBranch instanceof PsiReturnStatement)) {
                return false;
            }
            PsiExpression thenReturn = ((PsiReturnStatement)thenBranch).getReturnValue();
            if (thenReturn == null) {
                return false;
            }
            PsiType thenType = thenReturn.getType();
            if (!PsiType.BOOLEAN.equals(thenType)) {
                return false;
            }
            PsiExpression elseReturn = ((PsiReturnStatement)elseBranch).getReturnValue();
            if (elseReturn == null) {
                return false;
            }
            PsiType elseType = elseReturn.getType();
            if (!PsiType.BOOLEAN.equals(elseType)) {
                return false;
            }
            boolean thenConstant = BoolUtils.isFalse(thenReturn) || BoolUtils.isTrue(thenReturn);
            boolean elseConstant = BoolUtils.isFalse(elseReturn) || BoolUtils.isTrue(elseReturn);
            return thenConstant != elseConstant;
        }

        public static boolean isReplaceableAssignment(PsiIfStatement ifStatement) {
            boolean elseConstant;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return false;
            }
            if ((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) == null || !SimplifiableIfStatementVisitor.isAssignment(thenBranch)) {
                return false;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return false;
            }
            if ((elseBranch = ControlFlowUtils.stripBraces(elseBranch)) == null || !SimplifiableIfStatementVisitor.isAssignment(elseBranch)) {
                return false;
            }
            PsiExpressionStatement thenStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenStatement.getExpression();
            PsiExpressionStatement elseStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseStatement.getExpression();
            IElementType elseTokenType = elseExpression.getOperationTokenType();
            if (!thenExpression.getOperationTokenType().equals(elseTokenType)) {
                return false;
            }
            PsiExpression thenRhs = thenExpression.getRExpression();
            if (thenRhs == null) {
                return false;
            }
            PsiType thenRhsType = thenRhs.getType();
            if (!PsiType.BOOLEAN.equals(thenRhsType)) {
                return false;
            }
            PsiExpression elseRhs = elseExpression.getRExpression();
            if (elseRhs == null) {
                return false;
            }
            PsiType elseRhsType = elseRhs.getType();
            if (!PsiType.BOOLEAN.equals(elseRhsType)) {
                return false;
            }
            boolean thenConstant = BoolUtils.isFalse(thenRhs) || BoolUtils.isTrue(thenRhs);
            boolean bl = elseConstant = BoolUtils.isFalse(elseRhs) || BoolUtils.isTrue(elseRhs);
            if (thenConstant == elseConstant) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs);
        }

        public static boolean isAssignment(@Nullable PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            return expression instanceof PsiAssignmentExpression;
        }
    }

    private static class SimplifiableIfStatementFix
    extends InspectionGadgetsFix {
        private SimplifiableIfStatementFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement nextStatement;
            PsiElement element = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
            ArrayList<PsiComment> before = new ArrayList<PsiComment>();
            ArrayList<PsiComment> after = new ArrayList<PsiComment>();
            SimplifiableIfStatementFix.collectComments(ifStatement, true, before, after);
            String newStatementText = SimplifiableIfStatementInspection.calculateReplacementStatement(ifStatement);
            if (newStatementText == null) {
                return;
            }
            StringBuilder codeBlockText = new StringBuilder("{\n");
            for (PsiComment comment : before) {
                codeBlockText.append(comment.getText()).append('\n');
            }
            codeBlockText.append(newStatementText).append('\n');
            for (PsiComment comment : after) {
                codeBlockText.append(comment.getText()).append('\n');
            }
            codeBlockText.append('}');
            if (ifStatement.getElseBranch() == null && (nextStatement = PsiTreeUtil.skipWhitespacesForward(ifStatement)) != null) {
                nextStatement.delete();
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiCodeBlock codeBlock = psiFacade.getElementFactory().createCodeBlockFromText(codeBlockText.toString(), ifStatement);
            PsiElement parent = ifStatement.getParent();
            PsiElement child = codeBlock.getFirstBodyElement();
            PsiElement end = codeBlock.getLastBodyElement();
            while (true) {
                parent.addBefore(child, ifStatement);
                if (child == end) break;
                child = child.getNextSibling();
            }
            ifStatement.delete();
            CodeStyleManager.getInstance(project).reformat(parent);
        }

        private static void collectComments(PsiElement element, boolean first, List<PsiComment> before, List<PsiComment> after) {
            if (element instanceof PsiComment) {
                if (first) {
                    before.add((PsiComment)element);
                } else {
                    after.add((PsiComment)element);
                }
                return;
            }
            for (PsiElement child : element.getChildren()) {
                if (child instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)child;
                    if (keyword.getTokenType() != JavaTokenType.ELSE_KEYWORD) continue;
                    first = false;
                    continue;
                }
                SimplifiableIfStatementFix.collectComments(child, first, before, after);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/SimplifiableIfStatementInspection$SimplifiableIfStatementFix", "getFamilyName"));
        }
    }
}

