/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class AccessToStaticFieldLockedOnInstanceInspectionBase
extends BaseInspection {
    public OrderedSet<String> ignoredClasses = new OrderedSet();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("access.to.static.field.locked.on.instance.display.name", new Object[0]);
        if (string == null) {
            AccessToStaticFieldLockedOnInstanceInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("access.to.static.field.locked.on.instance.problem.descriptor", new Object[0]);
        if (string == null) {
            AccessToStaticFieldLockedOnInstanceInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AccessToStaticFieldLockedOnInstanceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/AccessToStaticFieldLockedOnInstanceInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AccessToStaticFieldLockedOnInstanceVisitor
    extends BaseInspectionVisitor {
        private AccessToStaticFieldLockedOnInstanceVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiSynchronizedStatement synchronizedStatement;
            PsiClass expressionClass;
            if (expression == null) {
                AccessToStaticFieldLockedOnInstanceVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField lockedField = (PsiField)target;
            if (!lockedField.hasModifierProperty("static") || ExpressionUtils.isConstant(lockedField)) {
                return;
            }
            PsiClass containingClass = lockedField.getContainingClass();
            if (!PsiTreeUtil.isAncestor(containingClass, expression, false)) {
                return;
            }
            if (!AccessToStaticFieldLockedOnInstanceInspectionBase.this.ignoredClasses.isEmpty() && AccessToStaticFieldLockedOnInstanceInspectionBase.this.ignoredClasses.contains(TypeUtils.resolvedClassName(lockedField.getType()))) {
                return;
            }
            boolean isLockedOnInstance = false;
            boolean isLockedOnClass = false;
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                if (containingMethod.hasModifierProperty("static")) {
                    isLockedOnClass = true;
                } else {
                    isLockedOnInstance = true;
                }
            }
            if ((expressionClass = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) == null) {
                return;
            }
            PsiElement elementToCheck = expression;
            while ((synchronizedStatement = PsiTreeUtil.getParentOfType(elementToCheck, PsiSynchronizedStatement.class)) != null && PsiTreeUtil.isAncestor(expressionClass, synchronizedStatement, true)) {
                PsiExpression lockExpression = synchronizedStatement.getLockExpression();
                if (lockExpression instanceof PsiReferenceExpression) {
                    PsiReferenceExpression reference = (PsiReferenceExpression)lockExpression;
                    PsiElement lockTarget = reference.resolve();
                    if (lockTarget instanceof PsiField) {
                        PsiField lockField = (PsiField)lockTarget;
                        if (lockField.hasModifierProperty("static")) {
                            isLockedOnClass = true;
                        } else {
                            isLockedOnInstance = true;
                        }
                    }
                } else if (lockExpression instanceof PsiThisExpression) {
                    isLockedOnInstance = true;
                } else if (lockExpression instanceof PsiClassObjectAccessExpression) {
                    isLockedOnClass = true;
                }
                elementToCheck = synchronizedStatement;
            }
            if (!isLockedOnInstance || isLockedOnClass) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/AccessToStaticFieldLockedOnInstanceInspectionBase$AccessToStaticFieldLockedOnInstanceVisitor", "visitReferenceExpression"));
        }
    }
}

