/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeConstraint {
    public static final TypeConstraint EMPTY = new TypeConstraint(Collections.emptySet(), Collections.emptySet());
    @NotNull
    private final Set<DfaPsiType> myInstanceofValues;
    @NotNull
    private final Set<DfaPsiType> myNotInstanceofValues;

    private TypeConstraint(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
        if (instanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(0);
        }
        if (notInstanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(1);
        }
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
    }

    private static TypeConstraint create(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
        if (instanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(2);
        }
        if (notInstanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(3);
        }
        if (instanceofValues.isEmpty() && notInstanceofValues.isEmpty()) {
            return EMPTY;
        }
        if (instanceofValues.isEmpty()) {
            instanceofValues = Collections.emptySet();
        } else if (instanceofValues.size() == 1) {
            instanceofValues = Collections.singleton(instanceofValues.iterator().next());
        }
        if (notInstanceofValues.isEmpty()) {
            notInstanceofValues = Collections.emptySet();
        } else if (notInstanceofValues.size() == 1) {
            notInstanceofValues = Collections.singleton(notInstanceofValues.iterator().next());
        }
        return new TypeConstraint(instanceofValues, notInstanceofValues);
    }

    boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType == null) {
            TypeConstraint.$$$reportNull$$$0(4);
        }
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    TypeConstraint withInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            TypeConstraint.$$$reportNull$$$0(5);
        }
        return this.withInstanceofValue(dfaType.getDfaType());
    }

    @Nullable
    TypeConstraint withInstanceofValue(@NotNull DfaPsiType type) {
        if (type == null) {
            TypeConstraint.$$$reportNull$$$0(6);
        }
        if (type.getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        if (!this.checkInstanceofValue(type)) {
            return null;
        }
        ArrayList<DfaPsiType> moreGeneric = new ArrayList<DfaPsiType>();
        for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
            if (type.isAssignableFrom(alreadyInstanceof)) {
                return this;
            }
            if (!alreadyInstanceof.isAssignableFrom(type)) continue;
            moreGeneric.add(alreadyInstanceof);
        }
        HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
        newInstanceof.removeAll(moreGeneric);
        newInstanceof.add(type);
        return TypeConstraint.create(newInstanceof, this.myNotInstanceofValues);
    }

    @Nullable
    TypeConstraint withNotInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            TypeConstraint.$$$reportNull$$$0(7);
        }
        return this.withNotInstanceofValue(dfaType.getDfaType());
    }

    @Nullable
    TypeConstraint withNotInstanceofValue(DfaPsiType type) {
        if (this.myNotInstanceofValues.contains(type)) {
            return this;
        }
        for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
            if (!type.isAssignableFrom(dfaPsiType)) continue;
            return null;
        }
        ArrayList<DfaPsiType> moreSpecific = new ArrayList<DfaPsiType>();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(type)) {
                return this;
            }
            if (!type.isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet<DfaPsiType> hashSet = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        hashSet.removeAll(moreSpecific);
        hashSet.add(type);
        return TypeConstraint.create(this.myInstanceofValues, hashSet);
    }

    @NotNull
    TypeConstraint withoutType(@NotNull DfaPsiType type) {
        if (type == null) {
            TypeConstraint.$$$reportNull$$$0(8);
        }
        if (this.myInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type);
            TypeConstraint typeConstraint = TypeConstraint.create(newInstanceof, this.myNotInstanceofValues);
            if (typeConstraint == null) {
                TypeConstraint.$$$reportNull$$$0(9);
            }
            return typeConstraint;
        }
        if (this.myNotInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type);
            TypeConstraint typeConstraint = TypeConstraint.create(this.myInstanceofValues, newNotInstanceof);
            if (typeConstraint == null) {
                TypeConstraint.$$$reportNull$$$0(10);
            }
            return typeConstraint;
        }
        TypeConstraint typeConstraint = this;
        if (typeConstraint == null) {
            TypeConstraint.$$$reportNull$$$0(11);
        }
        return typeConstraint;
    }

    @Nullable
    public PsiType getPsiType() {
        if (this.myInstanceofValues.isEmpty()) {
            return null;
        }
        if (this.myInstanceofValues.size() == 1) {
            return this.myInstanceofValues.iterator().next().getPsiType();
        }
        return ((Optional)((StreamEx)StreamEx.of(this.myInstanceofValues).map(DfaPsiType::getPsiType).select(PsiClassType.class).filter(type -> {
            PsiClass psiClass = type.resolve();
            return psiClass != null && !psiClass.isInterface();
        })).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    boolean isSuperStateOf(@NotNull TypeConstraint that) {
        if (that == null) {
            TypeConstraint.$$$reportNull$$$0(12);
        }
        return that.myNotInstanceofValues.containsAll(this.myNotInstanceofValues) && that.myInstanceofValues.containsAll(this.myInstanceofValues);
    }

    @NotNull
    public Set<DfaPsiType> getInstanceofValues() {
        Set<DfaPsiType> set = Collections.unmodifiableSet(this.myInstanceofValues);
        if (set == null) {
            TypeConstraint.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Set<DfaPsiType> getNotInstanceofValues() {
        Set<DfaPsiType> set = Collections.unmodifiableSet(this.myNotInstanceofValues);
        if (set == null) {
            TypeConstraint.$$$reportNull$$$0(14);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myInstanceofValues.isEmpty() && this.myNotInstanceofValues.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeConstraint that = (TypeConstraint)o;
        return Objects.equals(this.myInstanceofValues, that.myInstanceofValues) && Objects.equals(this.myNotInstanceofValues, that.myNotInstanceofValues);
    }

    public int hashCode() {
        return Objects.hash(this.myInstanceofValues, this.myNotInstanceofValues);
    }

    public String toString() {
        return EntryStream.of((Object)"instanceof ", this.myInstanceofValues, (Object)"not instanceof ", this.myNotInstanceofValues).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).joining((CharSequence)",", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceofValues";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notInstanceofValues";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaType";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceofValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInstanceofValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkInstanceofValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceofValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withNotInstanceofValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withoutType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSuperStateOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

