/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantStringFormatCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.string.format.call.display.name", new Object[0]);
        if (string == null) {
            RedundantStringFormatCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.string.format.call.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantStringFormatCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean printf = (Boolean)infos[0];
        return printf != false ? new ReplaceWithPrintFix() : new RedundantStringFormatCallFix();
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantStringFormatCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/RedundantStringFormatCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RedundantStringFormatCallVisitor
    extends BaseInspectionVisitor {
        private RedundantStringFormatCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            boolean printf;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("format".equals(methodName)) {
                printf = false;
            } else if ("printf".equals(methodName)) {
                printf = true;
            } else {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 2 || arguments.length == 0) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (printf ? !"java.io.PrintStream".equals(className) : !"java.lang.String".equals(className)) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType firstType = firstArgument.getType();
            if (firstType == null) {
                return;
            }
            if (firstType.equalsToText("java.lang.String")) {
                if (arguments.length == 1 && !RedundantStringFormatCallVisitor.containsPercentN(firstArgument)) {
                    this.registerMethodCallError(expression, printf);
                }
            } else if (firstType.equalsToText("java.util.Locale")) {
                if (arguments.length != 2) {
                    return;
                }
                PsiExpression secondArgument = arguments[1];
                PsiType secondType = secondArgument.getType();
                if (secondType == null || !secondType.equalsToText("java.lang.String")) {
                    return;
                }
                if (RedundantStringFormatCallVisitor.containsPercentN(secondArgument)) {
                    return;
                }
                this.registerMethodCallError(expression, printf);
            }
        }

        private static boolean containsPercentN(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                String expressionText = literalExpression.getText();
                return expressionText.contains("%n");
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiExpression[] operands;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (!tokenType.equals(JavaTokenType.PLUS)) {
                    return false;
                }
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    if (!RedundantStringFormatCallVisitor.containsPercentN(operand)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class RedundantStringFormatCallFix
    extends InspectionGadgetsFix {
        private RedundantStringFormatCallFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.string.format.call.quickfix", new Object[0]);
            if (string == null) {
                RedundantStringFormatCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
            methodCallExpression.replace(arguments[arguments.length - 1]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/RedundantStringFormatCallInspection$RedundantStringFormatCallFix", "getFamilyName"));
        }
    }

    private static class ReplaceWithPrintFix
    extends InspectionGadgetsFix {
        private ReplaceWithPrintFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.printf.with.print.quickfix", new Object[0]);
            if (string == null) {
                ReplaceWithPrintFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            StringBuilder newExpression = new StringBuilder();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                newExpression.append(qualifierExpression.getText()).append('.');
            }
            newExpression.append("print").append(methodCallExpression.getArgumentList().getText());
            PsiReplacementUtil.replaceExpression(methodCallExpression, newExpression.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/RedundantStringFormatCallInspection$ReplaceWithPrintFix", "getFamilyName"));
        }
    }
}

