/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class HibernateResourceInspection
extends ResourceInspection {
    @Override
    @NotNull
    public String getID() {
        if ("HibernateResourceOpenedButNotSafelyClosed" == null) {
            HibernateResourceInspection.$$$reportNull$$$0(0);
        }
        return "HibernateResourceOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("hibernate.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            HibernateResourceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"openSession".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        return qualifier != null && TypeUtils.expressionHasTypeOrSubtype(qualifier, "org.hibernate.SessionFactory");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/resources/HibernateResourceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

