/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CachingChildrenTreeNode<Value>
extends AbstractTreeNode<Value> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode");
    private List<CachingChildrenTreeNode> myChildren;
    private List<CachingChildrenTreeNode> myOldChildren = null;
    protected final TreeModel myTreeModel;

    public CachingChildrenTreeNode(Project project, Value value, TreeModel treeModel) {
        super(project, value instanceof StructureViewElementWrapper ? ((StructureViewElementWrapper)value).getWrappedElement() : value);
        this.myTreeModel = treeModel;
    }

    @Override
    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        this.ensureChildrenAreInitialized();
        ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>(this.myChildren);
        if (arrayList == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private void ensureChildrenAreInitialized() {
        if (this.myChildren == null) {
            try {
                this.myChildren = new ArrayList<CachingChildrenTreeNode>();
                this.rebuildSubtree();
            }
            catch (ProcessCanceledException pce) {
                this.myChildren = null;
                throw pce;
            }
        }
    }

    protected void addSubElement(CachingChildrenTreeNode node) {
        JBIterable<AbstractTreeNode> parents = JBIterable.generate(this, o -> o.getParent());
        if (parents.map(o -> o.getValue()).contains(node.getValue())) {
            return;
        }
        this.ensureChildrenAreInitialized();
        this.myChildren.add(node);
        node.setParent(this);
    }

    protected void setChildren(Collection<AbstractTreeNode> children) {
        this.clearChildren();
        for (AbstractTreeNode node : children) {
            this.myChildren.add((CachingChildrenTreeNode)node);
            node.setParent(this);
        }
    }

    protected void sortChildren(Sorter[] sorters) {
        if (this.myChildren == null) {
            return;
        }
        Collections.sort(this.myChildren, new CompositeComparator(sorters));
        for (CachingChildrenTreeNode child : this.myChildren) {
            if (!(child instanceof GroupWrapper)) continue;
            child.sortChildren(sorters);
        }
    }

    protected void filterChildren(@NotNull Filter[] filters) {
        if (filters == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(1);
        }
        Collection<AbstractTreeNode> children = this.getChildren();
        for (Filter filter : filters) {
            Iterator<AbstractTreeNode> eachNode = children.iterator();
            while (eachNode.hasNext()) {
                AbstractTreeNode eachChild = eachNode.next();
                Object value = eachChild.getValue();
                if (value instanceof TreeElement && filter.isVisible((TreeElement)value)) continue;
                eachNode.remove();
            }
        }
        this.setChildren(children);
    }

    protected void groupChildren(@NotNull Grouper[] groupers) {
        if (groupers == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(2);
        }
        for (Grouper grouper : groupers) {
            this.groupElements(grouper);
        }
        Collection<AbstractTreeNode> children = this.getChildren();
        for (AbstractTreeNode child : children) {
            if (!(child instanceof GroupWrapper)) continue;
            ((GroupWrapper)child).groupChildren(groupers);
        }
    }

    private void groupElements(Grouper grouper) {
        ArrayList<AbstractTreeNode<TreeElement>> ungrouped = new ArrayList<AbstractTreeNode<TreeElement>>();
        Collection<AbstractTreeNode> children = this.getChildren();
        for (AbstractTreeNode child : children) {
            if (!(child instanceof TreeElementWrapper)) continue;
            ungrouped.add(child);
        }
        if (!ungrouped.isEmpty()) {
            this.processUngrouped(ungrouped, grouper);
        }
        LinkedHashSet<AbstractTreeNode> result = new LinkedHashSet<AbstractTreeNode>();
        for (AbstractTreeNode child : children) {
            AbstractTreeNode parent = child.getParent();
            if (parent != this) {
                if (result.contains(parent)) continue;
                result.add(parent);
                continue;
            }
            result.add(child);
        }
        this.setChildren(result);
    }

    private void processUngrouped(@NotNull List<AbstractTreeNode<TreeElement>> ungrouped, @NotNull Grouper grouper) {
        if (ungrouped == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(3);
        }
        if (grouper == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(4);
        }
        Map<TreeElement, AbstractTreeNode> ungroupedObjects = CachingChildrenTreeNode.collectValues(ungrouped);
        Collection<Group> groups = grouper.group(this, ungroupedObjects.keySet());
        Map<Group, GroupWrapper> groupNodes = this.createGroupNodes(groups);
        for (Group group : groups) {
            if (group == null) {
                LOG.error(grouper + " returned null group: " + groups);
            }
            GroupWrapper groupWrapper = groupNodes.get(group);
            Collection<TreeElement> children = group.getChildren();
            for (TreeElement node : children) {
                if (node == null) {
                    LOG.error(group + " returned null child: " + children);
                }
                TreeElementWrapper child = this.createChildNode(node);
                groupWrapper.addSubElement(child);
                AbstractTreeNode abstractTreeNode = ungroupedObjects.get(node);
                abstractTreeNode.setParent(groupWrapper);
            }
        }
    }

    protected TreeElementWrapper createChildNode(@NotNull TreeElement child) {
        if (child == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(5);
        }
        return new TreeElementWrapper(this.getProject(), child, this.myTreeModel);
    }

    private static Map<TreeElement, AbstractTreeNode> collectValues(List<AbstractTreeNode<TreeElement>> ungrouped) {
        LinkedHashMap<TreeElement, AbstractTreeNode> objects = new LinkedHashMap<TreeElement, AbstractTreeNode>();
        for (AbstractTreeNode<TreeElement> node : ungrouped) {
            objects.put(node.getValue(), node);
        }
        return objects;
    }

    private Map<Group, GroupWrapper> createGroupNodes(@NotNull Collection<Group> groups) {
        if (groups == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(6);
        }
        THashMap result = new THashMap();
        for (Group group : groups) {
            result.put(group, this.createGroupWrapper(this.getProject(), group, this.myTreeModel));
        }
        return result;
    }

    protected GroupWrapper createGroupWrapper(Project project, @NotNull Group group, TreeModel treeModel) {
        if (group == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(7);
        }
        return new GroupWrapper(project, group, treeModel);
    }

    private void rebuildSubtree() {
        this.initChildren();
        this.performTreeActions();
        this.synchronizeChildren();
    }

    protected void synchronizeChildren() {
        List<CachingChildrenTreeNode> children = this.myChildren;
        if (this.myOldChildren != null && children != null) {
            HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode> oldValuesToChildrenMap = new HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode>();
            for (CachingChildrenTreeNode oldChild : this.myOldChildren) {
                CachingChildrenTreeNode<Object> oldValue = oldChild instanceof TreeElementWrapper ? oldChild.getValue() : oldChild;
                if (oldValue == null) continue;
                oldValuesToChildrenMap.put(oldValue, oldChild);
            }
            for (int i = 0; i < children.size(); ++i) {
                CachingChildrenTreeNode oldChild;
                CachingChildrenTreeNode<Object> newValue;
                CachingChildrenTreeNode newChild = children.get(i);
                CachingChildrenTreeNode<Object> cachingChildrenTreeNode = newValue = newChild instanceof TreeElementWrapper ? newChild.getValue() : newChild;
                if (newValue == null || (oldChild = (CachingChildrenTreeNode)oldValuesToChildrenMap.get(newValue)) == null) continue;
                oldChild.copyFromNewInstance(newChild);
                oldChild.setValue(newChild.getValue());
                children.set(i, oldChild);
            }
            this.myOldChildren = null;
        }
    }

    protected abstract void copyFromNewInstance(@NotNull CachingChildrenTreeNode var1);

    protected abstract void performTreeActions();

    protected abstract void initChildren();

    @Override
    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigateToSource();
    }

    protected void clearChildren() {
        if (this.myChildren != null) {
            this.myChildren.clear();
        } else {
            this.myChildren = new ArrayList<CachingChildrenTreeNode>();
        }
    }

    public void rebuildChildren() {
        if (this.myChildren != null) {
            this.myOldChildren = this.myChildren;
            for (CachingChildrenTreeNode node : this.myChildren) {
                node.rebuildChildren();
            }
            this.myChildren = null;
        }
    }

    protected void resetChildren() {
        this.myChildren = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ungrouped";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filterChildren";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "groupChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processUngrouped";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChildNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGroupWrapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeComparator
    implements Comparator<CachingChildrenTreeNode> {
        private final Sorter[] mySorters;

        public CompositeComparator(Sorter[] sorters) {
            this.mySorters = sorters;
        }

        @Override
        public int compare(CachingChildrenTreeNode o1, CachingChildrenTreeNode o2) {
            Object value1 = o1.getValue();
            Object value2 = o2.getValue();
            for (Sorter sorter : this.mySorters) {
                int result = sorter.getComparator().compare(value1, value2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

