/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiEnumConstantImpl;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.EnumConstantElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JavaFieldStubElementType
extends JavaStubElementType<PsiFieldStub, PsiField> {
    private static final int INITIALIZER_LENGTH_LIMIT = 1000;

    public JavaFieldStubElementType(@NotNull String id) {
        if (id == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @Override
    public PsiField createPsi(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(1);
        }
        return this.getPsiFactory(stub).createField(stub);
    }

    @Override
    public PsiField createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(2);
        }
        if (node instanceof EnumConstantElement) {
            return new PsiEnumConstantImpl(node);
        }
        return new PsiFieldImpl(node);
    }

    @Override
    public PsiFieldStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String name = null;
        String initializer = null;
        boolean expectingInit = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type == JavaTokenType.EQ) {
                expectingInit = true;
                continue;
            }
            if (!expectingInit || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) || type == JavaTokenType.SEMICOLON) continue;
            initializer = JavaFieldStubElementType.encodeInitializer(tree, child);
            break;
        }
        boolean isEnumConst = node.getTokenType() == JavaElementType.ENUM_CONSTANT;
        byte flags = PsiFieldStubImpl.packFlags(isEnumConst, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiFieldStubImpl(parentStub, name, typeInfo, initializer, flags);
    }

    private static String encodeInitializer(LighterAST tree, LighterASTNode initializer) {
        IElementType type = initializer.getTokenType();
        if (type == JavaElementType.NEW_EXPRESSION || type == JavaElementType.METHOD_CALL_EXPRESSION) {
            return ";INITIALIZER_NOT_STORED;";
        }
        if (initializer.getEndOffset() - initializer.getStartOffset() > 1000) {
            return ";INITIALIZER_TOO_LONG;";
        }
        return LightTreeUtil.toFilteredString(tree, initializer, null);
    }

    @Override
    public void serialize(@NotNull PsiFieldStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeName(stub.getInitializerText());
        dataStream.writeByte(((PsiFieldStubImpl)stub).getFlags());
    }

    @Override
    @NotNull
    public PsiFieldStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(5);
        }
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream);
        StringRef initializerText = dataStream.readName();
        byte flags = dataStream.readByte();
        PsiFieldStubImpl psiFieldStubImpl = new PsiFieldStubImpl(parentStub, StringRef.toString(name), type, StringRef.toString(initializerText), flags);
        if (psiFieldStubImpl == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(6);
        }
        return psiFieldStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiFieldStub stub, @NotNull IndexSink sink) {
        String name;
        if (stub == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(8);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.FIELDS, name);
            if (RecordUtil.isStaticNonPrivateMember(stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, name);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, stub.getType(false).getShortTypeText());
            }
        }
    }

    @Override
    public String getId(@NotNull PsiFieldStub stub) {
        String name;
        if (stub == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(9);
        }
        return (name = stub.getName()) != null ? name : super.getId(stub);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

