/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMayBeWeakenedInspection
extends BaseInspection {
    public boolean useRighthandTypeAsWeakestTypeInAssignments = true;
    public boolean useParameterizedTypeForCollectionMethods = true;
    public boolean doNotWeakenToJavaLangObject = true;
    public boolean onlyWeakentoInterface = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.may.be.weakened.display.name", new Object[0]);
        if (string == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info;
        Iterable weakerClasses = (Iterable)infos[1];
        StringBuilder builder = new StringBuilder();
        Iterator iterator = weakerClasses.iterator();
        if (iterator.hasNext()) {
            builder.append('\'').append(TypeMayBeWeakenedInspection.getClassName((PsiClass)iterator.next())).append('\'');
            while (iterator.hasNext()) {
                builder.append(", '").append(TypeMayBeWeakenedInspection.getClassName((PsiClass)iterator.next())).append('\'');
            }
        }
        if ((info = infos[0]) instanceof PsiField) {
            String string = InspectionGadgetsBundle.message("type.may.be.weakened.field.problem.descriptor", builder.toString());
            if (string == null) {
                TypeMayBeWeakenedInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (info instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("type.may.be.weakened.parameter.problem.descriptor", builder.toString());
            if (string == null) {
                TypeMayBeWeakenedInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (info instanceof PsiMethod) {
            String string = InspectionGadgetsBundle.message("type.may.be.weakened.method.problem.descriptor", builder.toString());
            if (string == null) {
                TypeMayBeWeakenedInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("type.may.be.weakened.problem.descriptor", builder.toString());
        if (string == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String getClassName(PsiClass aClass) {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return aClass.getName();
        }
        return qualifiedName;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.ignore.option", new Object[0]), "useRighthandTypeAsWeakestTypeInAssignments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.collection.method.option", new Object[0]), "useParameterizedTypeForCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.do.not.weaken.to.object.option", new Object[0]), "doNotWeakenToJavaLangObject");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("only.weaken.to.an.interface", new Object[0]), "onlyWeakentoInterface");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Iterable weakerClasses = (Iterable)infos[1];
        ArrayList<TypeMayBeWeakenedFix> fixes = new ArrayList<TypeMayBeWeakenedFix>();
        for (PsiClass weakestClass : weakerClasses) {
            String className = TypeMayBeWeakenedInspection.getClassName(weakestClass);
            if (className == null) continue;
            fixes.add(new TypeMayBeWeakenedFix(className));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
        if (inspectionGadgetsFixArray == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(5);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeMayBeWeakenedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TypeMayBeWeakenedVisitor
    extends BaseInspectionVisitor {
        private TypeMayBeWeakenedVisitor() {
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            PsiExpression initializer;
            PsiForeachStatement foreachStatement;
            PsiExpression iteratedValue;
            PsiElement parent;
            super.visitVariable(variable);
            if (variable instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable;
                PsiElement declarationScope = parameter.getDeclarationScope();
                if (declarationScope instanceof PsiCatchSection) {
                    return;
                }
                if (declarationScope instanceof PsiLambdaExpression && parameter.getTypeElement() == null) {
                    return;
                }
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null || containingClass.isInterface()) {
                        return;
                    }
                    if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
                        return;
                    }
                    if (MethodUtils.hasSuper(method)) {
                        return;
                    }
                    Query<PsiMethod> overridingSearch = OverridingMethodsSearch.search(method);
                    if (overridingSearch.findFirst() != null) {
                        return;
                    }
                }
            }
            if (this.isOnTheFly() && variable instanceof PsiField && !variable.hasModifierProperty("private")) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments && (variable instanceof PsiParameter ? (parent = variable.getParent()) instanceof PsiForeachStatement && !((iteratedValue = (foreachStatement = (PsiForeachStatement)parent).getIteratedValue()) instanceof PsiNewExpression) && !(iteratedValue instanceof PsiTypeCastExpression) : !((initializer = variable.getInitializer()) instanceof PsiNewExpression) && !(initializer instanceof PsiTypeCastExpression))) {
                return;
            }
            Collection<PsiClass> weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary(variable, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                Project project = variable.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                PsiClass javaLangObjectClass = facade.findClass("java.lang.Object", variable.getResolveScope());
                weakestClasses.remove(javaLangObjectClass);
            }
            if (TypeMayBeWeakenedInspection.this.onlyWeakentoInterface) {
                Iterator<PsiClass> iterator = weakestClasses.iterator();
                while (iterator.hasNext()) {
                    PsiClass weakestClass = iterator.next();
                    if (weakestClass.isInterface()) continue;
                    iterator.remove();
                }
            }
            if (weakestClasses.isEmpty()) {
                return;
            }
            this.registerVariableError(variable, variable, weakestClasses);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (this.isOnTheFly() && !method.hasModifierProperty("private") && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            Query<PsiMethod> overridingSearch = OverridingMethodsSearch.search(method);
            if (overridingSearch.findFirst() != null) {
                return;
            }
            Collection<PsiClass> weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary(method, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                Project project = method.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                PsiClass javaLangObjectClass = facade.findClass("java.lang.Object", method.getResolveScope());
                weakestClasses.remove(javaLangObjectClass);
            }
            if (TypeMayBeWeakenedInspection.this.onlyWeakentoInterface) {
                Iterator<PsiClass> iterator = weakestClasses.iterator();
                while (iterator.hasNext()) {
                    PsiClass weakestClass = iterator.next();
                    if (weakestClass.isInterface()) continue;
                    iterator.remove();
                }
            }
            if (weakestClasses.isEmpty()) {
                return;
            }
            this.registerMethodError(method, method, weakestClasses);
        }
    }

    private static class TypeMayBeWeakenedFix
    extends InspectionGadgetsFix {
        private final String fqClassName;

        TypeMayBeWeakenedFix(@NotNull String fqClassName) {
            if (fqClassName == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(0);
            }
            this.fqClassName = fqClassName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("type.may.be.weakened.quickfix", this.fqClassName);
            if (string == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Weaken type" == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(2);
            }
            return "Weaken type";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiTypeParameter[] typeParameters;
            PsiTypeElement typeElement;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                typeElement = variable.getTypeElement();
            } else if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                typeElement = method.getReturnTypeElement();
            } else {
                return;
            }
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement componentReferenceElement = typeElement.getInnermostComponentReferenceElement();
            if (componentReferenceElement == null) {
                return;
            }
            PsiType oldType = typeElement.getType();
            if (!(oldType instanceof PsiClassType)) {
                return;
            }
            PsiClassType oldClassType = (PsiClassType)oldType;
            PsiType[] parameterTypes = oldClassType.getParameters();
            JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiType type = factory.createTypeFromText(this.fqClassName, element);
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass != null && (typeParameters = aClass.getTypeParameters()).length != 0 && typeParameters.length == parameterTypes.length) {
                HashMap<PsiTypeParameter, PsiType> typeParameterMap = new HashMap<PsiTypeParameter, PsiType>();
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiTypeParameter typeParameter = typeParameters[i];
                    PsiType parameterType = parameterTypes[i];
                    typeParameterMap.put(typeParameter, parameterType);
                }
                PsiSubstitutor substitutor = factory.createSubstitutor(typeParameterMap);
                classType = factory.createType(aClass, substitutor);
            }
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
            PsiElement replacement = componentReferenceElement.replace(referenceElement);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
            javaCodeStyleManager.shortenClassReferences(replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqClassName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

