/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

abstract class BaseEqualsVisitor
extends BaseInspectionVisitor {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.instanceCall("java.lang.Object", "equals").parameterTypes("java.lang.Object");
    private static final CallMatcher STATIC_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));

    BaseEqualsVisitor() {
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        PsiType rightType;
        PsiType leftType;
        super.visitMethodReferenceExpression(expression);
        if (!OBJECT_EQUALS.methodReferenceMatches(expression) && !STATIC_EQUALS.methodReferenceMatches(expression)) {
            return;
        }
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(method, resolveResult);
        if (parameters.length == 2) {
            leftType = substitutor.substitute(parameters[0].getType());
            rightType = substitutor.substitute(parameters[1].getType());
        } else {
            PsiExpression qualifier = expression.getQualifierExpression();
            assert (qualifier != null);
            leftType = qualifier.getType();
            rightType = substitutor.substitute(parameters[0].getType());
        }
        if (leftType != null && rightType != null) {
            this.checkTypes(expression, leftType, rightType);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        PsiExpression expression2;
        PsiExpression expression1;
        if (expression == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(0);
        }
        super.visitMethodCallExpression(expression);
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (OBJECT_EQUALS.test(expression)) {
            expression1 = ExpressionUtils.getQualifierOrThis(expression.getMethodExpression());
            expression2 = arguments[0];
        } else if (STATIC_EQUALS.test(expression)) {
            expression1 = arguments[0];
            expression2 = arguments[1];
        } else {
            return;
        }
        PsiType leftType = expression1.getType();
        PsiType rightType = expression2.getType();
        if (leftType != null && rightType != null) {
            this.checkTypes(expression.getMethodExpression(), leftType, rightType);
        }
    }

    abstract void checkTypes(@NotNull PsiReferenceExpression var1, @NotNull PsiType var2, @NotNull PsiType var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/BaseEqualsVisitor", "visitMethodCallExpression"));
    }
}

