/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BadExceptionCaughtInspectionBase
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.NullPointerException", "java.lang.IllegalMonitorStateException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.IndexOutOfBoundsException", "java.util.ConcurrentModificationException");

    public BadExceptionCaughtInspectionBase() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List<String> strings = StringUtil.split(this.exceptionsString, ",");
            for (String string : strings) {
                this.exceptions.add(string);
            }
            this.exceptionsString = "";
        }
    }

    @Override
    @NotNull
    public String getID() {
        if ("ProhibitedExceptionCaught" == null) {
            BadExceptionCaughtInspectionBase.$$$reportNull$$$0(0);
        }
        return "ProhibitedExceptionCaught";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.exception.caught.display.name", new Object[0]);
        if (string == null) {
            BadExceptionCaughtInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.exception.caught.problem.descriptor", new Object[0]);
        if (string == null) {
            BadExceptionCaughtInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionCaughtVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/BadExceptionCaughtInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class BadExceptionCaughtVisitor
    extends BaseInspectionVisitor {
        private BadExceptionCaughtVisitor() {
        }

        @Override
        public void visitCatchSection(PsiCatchSection section) {
            super.visitCatchSection(section);
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiTypeElement[] childTypeElements = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
            if (childTypeElements != null) {
                for (PsiTypeElement childTypeElement : childTypeElements) {
                    this.checkTypeElement(childTypeElement);
                }
            } else {
                this.checkTypeElement(typeElement);
            }
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            PsiType type = typeElement.getType();
            if (BadExceptionCaughtInspectionBase.this.exceptions.contains(type.getCanonicalText())) {
                this.registerError((PsiElement)typeElement, typeElement);
            }
        }
    }
}

