/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnaryMinusInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryUnaryMinusInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryUnaryMinusInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnaryMinusFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnaryMinusVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryUnaryMinusVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnaryMinusVisitor() {
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            IElementType operationTokenType = expression.getOperationTokenType();
            if (!JavaTokenType.MINUS.equals(operationTokenType)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                if (ExpressionUtils.hasType(polyadicExpression, "java.lang.String")) {
                    return;
                }
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(expression);
                if (token == null) {
                    return;
                }
                IElementType binaryExpressionTokenType = token.getTokenType();
                if (!JavaTokenType.PLUS.equals(binaryExpressionTokenType)) {
                    return;
                }
                this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                if (ExpressionUtils.hasType(assignmentExpression, "java.lang.String")) {
                    return;
                }
                IElementType assignmentTokenType = assignmentExpression.getOperationTokenType();
                if (!JavaTokenType.PLUSEQ.equals(assignmentTokenType)) {
                    return;
                }
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (!expression.equals(rhs)) {
                    return;
                }
                this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
            }
        }
    }

    private static class UnnecessaryUnaryMinusFix
    extends InspectionGadgetsFix {
        private UnnecessaryUnaryMinusFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryUnaryMinusFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element.getParent();
            PsiExpression parentExpression = (PsiExpression)prefixExpression.getParent();
            StringBuilder newExpression = new StringBuilder();
            if (parentExpression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parentExpression;
                PsiExpression lhs = assignmentExpression.getLExpression();
                newExpression.append(lhs.getText());
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType.equals(JavaTokenType.PLUSEQ)) {
                    newExpression.append("-=");
                } else {
                    newExpression.append("+=");
                }
            } else if (parentExpression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parentExpression;
                PsiExpression lhs = binaryExpression.getLOperand();
                newExpression.append(lhs.getText());
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (tokenType.equals(JavaTokenType.PLUS)) {
                    newExpression.append('-');
                } else {
                    newExpression.append('+');
                }
            }
            PsiExpression operand = prefixExpression.getOperand();
            if (operand == null) {
                return;
            }
            newExpression.append(operand.getText());
            PsiReplacementUtil.replaceExpression(parentExpression, newExpression.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection$UnnecessaryUnaryMinusFix", "getFamilyName"));
        }
    }
}

