/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiFileFactoryImpl");
    private final PsiManager myManager;

    public PsiFileFactoryImpl(PsiManager manager) {
        this.myManager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean bl) {
        void eventSystemEnabled;
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(1);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text, modificationStamp, (boolean)eventSystemEnabled, true);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(4);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(5);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(6);
        }
        return this.createFileFromText(name, language, text, true, true);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy) {
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(7);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(8);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(9);
        }
        return this.createFileFromText(name, language, text, eventSystemEnabled, markAsCopy, false);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit) {
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(10);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(11);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(12);
        }
        return this.createFileFromText(name, language, text, eventSystemEnabled, markAsCopy, noSizeLimit, null);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit, @Nullable VirtualFile original) {
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(13);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(14);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(15);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, language, text);
        if (original != null) {
            virtualFile.setOriginalFile(original);
            virtualFile.setFileType(original.getFileType());
        }
        if (noSizeLimit) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit(virtualFile);
        }
        return this.trySetupPsiForFile(virtualFile, language, eventSystemEnabled, markAsCopy);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean eventSystemEnabled, boolean bl) {
        void markAsCopy;
        Language language;
        PsiFile file;
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(17);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(18);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        if (fileType instanceof LanguageFileType && (file = this.trySetupPsiForFile(virtualFile, language = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), virtualFile, this.myManager.getProject()), eventSystemEnabled, (boolean)markAsCopy)) != null) {
            PsiFile psiFile = file;
            if (psiFile == null) {
                PsiFileFactoryImpl.$$$reportNull$$$0(19);
            }
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, eventSystemEnabled);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(20);
        }
        return psiPlainTextFileImpl;
    }

    @Nullable
    public PsiFile trySetupPsiForFile(@NotNull LightVirtualFile virtualFile, @NotNull Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProviderFactory factory;
        FileViewProvider viewProvider;
        if (virtualFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(21);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(22);
        }
        FileViewProvider fileViewProvider = viewProvider = (factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language)) != null ? factory.createFileViewProvider(virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                if (psiFile.getNode() == null) {
                    throw new AssertionError((Object)("No node for file " + psiFile + "; language=" + language));
                }
                PsiFileFactoryImpl.markGenerated(psiFile);
            }
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text, long modificationStamp, boolean physical, boolean bl) {
        void markAsCopy;
        PsiFile psiFile;
        FileViewProvider viewProvider;
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(23);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(24);
        }
        if (targetLanguage == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(25);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(26);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider(virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, physical);
        }
        if (parserDefinition != null && (psiFile = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy != false) {
                PsiFileFactoryImpl.markGenerated(psiFile);
            }
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                PsiFileFactoryImpl.$$$reportNull$$$0(27);
            }
            return psiFile2;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(28);
        }
        return psiPlainTextFileImpl;
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text) {
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(29);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(30);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(31);
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(32);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull String text) {
        FileType type;
        if (name == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(33);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(34);
        }
        if ((type = FileTypeRegistry.getInstance().getFileTypeByFileName(name)).isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name + ", file type " + type);
        }
        PsiFile psiFile = this.createFileFromText(name, type, (CharSequence)text);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(35);
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(FileType fileType, String fileName, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        CharSequence text = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName, fileType, text);
    }

    @Override
    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        PsiFile file;
        if (chars == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(36);
        }
        if (original == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(37);
        }
        if ((file = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true)) != null) {
            file.putUserData(ORIGINAL_FILE, original);
        }
        return file;
    }

    @Nullable
    public PsiElement createElementFromText(@Nullable String text, @NotNull Language language, @NotNull IElementType type, @Nullable PsiElement context) {
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(38);
        }
        if (type == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(39);
        }
        if (text == null) {
            return null;
        }
        DummyHolder result = DummyHolderFactory.createHolder(this.myManager, language, context);
        FileElement holder = result.getTreeElement();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for " + language));
        }
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiFileFactoryImpl.markGenerated(result);
        return node.getPsi();
    }

    public static void markGenerated(PsiElement element) {
        TreeElement node = (TreeElement)element.getNode();
        assert (node != null);
        node.acceptTree(new GeneratedMarkerVisitor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 17: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiFileFactoryImpl";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLanguage";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiFileFactoryImpl";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "trySetupPsiForFile";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

