/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlSuppressionProvider
extends XmlSuppressionProvider
implements InspectionSuppressor {
    public static final String SUPPRESS_MARK = "suppress";

    @Override
    public boolean isProviderAvailable(@NotNull PsiFile file) {
        if (file == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(1);
        }
        if (inspectionId == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(2);
        }
        XmlTag tag = element instanceof XmlFile ? ((XmlFile)element).getRootTag() : PsiTreeUtil.getContextOfType(element, XmlTag.class, false);
        return tag != null && this.findSuppression(tag, inspectionId, element) != null;
    }

    @Override
    public void suppressForFile(@NotNull PsiElement element, @NotNull String inspectionId) {
        PsiFile file;
        XmlDocument document;
        PsiElement anchor;
        if (element == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(3);
        }
        if (inspectionId == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = anchor = (document = ((XmlFile)(file = element.getContainingFile())).getDocument()) != null ? document.getRootTag() : file.findElementAt(0);
        assert (anchor != null);
        this.suppress(file, this.findFileSuppression(anchor, null, element), inspectionId, anchor.getTextRange().getStartOffset());
    }

    @Override
    public void suppressForTag(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(5);
        }
        if (inspectionId == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(6);
        }
        XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class);
        assert (tag != null);
        this.suppress(element.getContainingFile(), this.findSuppressionLeaf(tag, null, 0), inspectionId, tag.getTextRange().getStartOffset());
    }

    @Nullable
    protected PsiElement findSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiElement element = this.findSuppressionLeaf(anchor, id, 0);
        if (element != null) {
            return element;
        }
        return this.findFileSuppression(anchor, id, originalElement);
    }

    @Nullable
    protected PsiElement findFileSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiFile file = anchor.getContainingFile();
        if (file instanceof XmlFile) {
            XmlDocument document = ((XmlFile)file).getDocument();
            XmlTag rootTag = document != null ? document.getRootTag() : null;
            PsiElement leaf = rootTag != null ? rootTag.getPrevSibling() : file.findElementAt(0);
            return this.findSuppressionLeaf(leaf, id, 0);
        }
        return null;
    }

    @Nullable
    protected PsiElement findSuppressionLeaf(PsiElement leaf, @Nullable String id, int offset) {
        while (leaf != null && leaf.getTextOffset() >= offset) {
            String text2;
            if ((leaf instanceof PsiComment || leaf instanceof XmlProlog || leaf instanceof XmlText) && this.isSuppressedFor(text2 = leaf.getText(), id)) {
                return leaf;
            }
            if (!((leaf = leaf.getPrevSibling()) instanceof XmlTag)) continue;
            return null;
        }
        return null;
    }

    private boolean isSuppressedFor(@NonNls String text2, @Nullable String id) {
        if (!text2.contains(this.getPrefix())) {
            return false;
        }
        if (id == null) {
            return true;
        }
        HashSet<String> parts = ContainerUtil.newHashSet(StringUtil.getWordsIn(text2));
        return parts.contains(id) || parts.contains("ALL");
    }

    protected void suppress(PsiFile file, PsiElement suppressionElement, String inspectionId, int offset) {
        Project project = file.getProject();
        Document doc = PsiDocumentManager.getInstance(project).getDocument(file);
        assert (doc != null);
        if (suppressionElement != null) {
            TextRange textRange = suppressionElement.getTextRange();
            String text2 = suppressionElement.getText();
            String suppressionText = this.getSuppressionText(inspectionId, text2);
            doc.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), suppressionText);
        } else {
            String suppressionText = this.getSuppressionText(inspectionId, null);
            doc.insertString(offset, suppressionText);
            CodeStyleManager.getInstance(project).adjustLineIndent(doc, offset + suppressionText.length());
            UndoUtil.markPsiFileForUndo(file);
        }
    }

    protected String getSuppressionText(String inspectionId, @Nullable String originalText) {
        if (originalText == null) {
            return this.getPrefix() + inspectionId + this.getSuffix() + "\n";
        }
        if (inspectionId.equals("ALL")) {
            int pos = originalText.indexOf(this.getPrefix());
            return originalText.substring(0, pos) + this.getPrefix() + inspectionId + this.getSuffix() + "\n";
        }
        return StringUtil.replace(originalText, this.getSuffix(), ", " + inspectionId + this.getSuffix());
    }

    @NonNls
    protected String getPrefix() {
        return "<!--suppress ";
    }

    @NonNls
    protected String getSuffix() {
        return " -->";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/DefaultXmlSuppressionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isProviderAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuppressedFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressForFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressForTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

