/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.RemoveAttributeIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownBooleanAttributeInspectionBase
extends HtmlUnknownElementInspection {
    private static final Key<HtmlUnknownElementInspection> BOOLEAN_ATTRIBUTE_KEY = Key.create("HtmlUnknownBooleanAttribute");
    private static final Logger LOG = Logger.getInstance(HtmlUnknownBooleanAttributeInspectionBase.class);

    public HtmlUnknownBooleanAttributeInspectionBase() {
        this("");
    }

    public HtmlUnknownBooleanAttributeInspectionBase(String defaultValues) {
        super(defaultValues);
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message("html.inspections.unknown.boolean.attribute", new Object[0]);
        if (string == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlUnknownBooleanAttribute" == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(1);
        }
        return "HtmlUnknownBooleanAttribute";
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlBundle.message("html.inspections.unknown.tag.boolean.attribute.checkbox.title", new Object[0]);
    }

    @Override
    @NotNull
    protected String getPanelTitle() {
        String string = XmlBundle.message("html.inspections.unknown.tag.boolean.attribute.title", new Object[0]);
        if (string == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlTag tag;
        if (attribute == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(5);
        }
        if (attribute.getValueElement() == null && (tag = attribute.getParent()) instanceof HtmlTag) {
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
            if (attributeDescriptor != null && !(attributeDescriptor instanceof AnyXmlAttributeDescriptor)) {
                String name = attribute.getName();
                if (!(HtmlUtil.isBooleanAttribute(attributeDescriptor, null) || this.isCustomValuesEnabled() && this.isCustomValue(name))) {
                    LocalQuickFix[] localQuickFixArray;
                    boolean html5 = HtmlUtil.isHtml5Context(tag);
                    if (!html5) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[3];
                        localQuickFixArray2[0] = new AddCustomHtmlElementIntentionAction(BOOLEAN_ATTRIBUTE_KEY, name, XmlBundle.message("add.custom.html.boolean.attribute", name));
                        localQuickFixArray2[1] = XmlQuickFixFactory.getInstance().addAttributeValueFix(attribute);
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[2] = new RemoveAttributeIntentionAction(name);
                    } else {
                        LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray3;
                        localQuickFixArray3[0] = XmlQuickFixFactory.getInstance().addAttributeValueFix(attribute);
                    }
                    LocalQuickFix[] quickFixes = localQuickFixArray;
                    String error = null;
                    if (html5) {
                        if (attributeDescriptor instanceof XmlEnumerationDescriptor && ((XmlEnumerationDescriptor)((Object)attributeDescriptor)).getValueDeclaration(attribute, "") == null) {
                            error = XmlErrorMessages.message("wrong.value", "attribute");
                        }
                    } else {
                        error = XmlErrorMessages.message("attribute.is.not.boolean", attribute.getName());
                    }
                    if (error != null) {
                        HtmlUnknownBooleanAttributeInspectionBase.registerProblemOnAttributeName(attribute, error, holder, quickFixes);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownBooleanAttributeInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownBooleanAttributeInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

