/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0013JL\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\u00132\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0018H\u0016J.\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J(\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\b\u0002\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\"R*\u0010\u0005\u001a\u001e\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "subStateTagName", "", "(Ljava/lang/String;)V", "nameToData", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "", "delete", "", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "load", "", "state", "Lorg/jdom/Element;", "nameGetter", "Lkotlin/Function1;", "processChildren", "path", "filter", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "consumer", "write", "content", "size", "", "writeState", "comparator", "Ljava/util/Comparator;", "projectModel-impl"})
public final class SchemeManagerIprProvider
implements StreamProvider {
    private final ConcurrentMap<String, byte[]> nameToData;
    private final String subStateTagName;

    @Override
    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        ByteArrayInputStream byteArrayInputStream;
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)((Object)roamingType), (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        byte[] byArray2 = (byte[])this.nameToData.get(PathUtilRt.getFileName(fileSpec));
        if (byArray2 != null) {
            byte[] p1;
            byte[] byArray3 = p1 = (byArray = byArray2);
            byteArrayInputStream = new ByteArrayInputStream(byArray3);
        } else {
            byteArrayInputStream = null;
        }
        byte[] it = byArray = byteArrayInputStream;
        consumer.invoke((Object)it);
        return true;
    }

    @Override
    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)((Object)roamingType), (String)"roamingType");
        this.nameToData.remove(PathUtilRt.getFileName(fileSpec));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)((Object)roamingType), (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Map map = this.nameToData;
        for (Map.Entry entry : map.entrySet()) {
            boolean bl;
            Object object = entry;
            String name = (String)object.getKey();
            object = entry;
            byte[] data = (byte[])object.getValue();
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            if (!((Boolean)filter.invoke((Object)string)).booleanValue()) continue;
            object = data;
            object = new ByteArrayInputStream((byte[])object);
            Throwable throwable = null;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                bl = (Boolean)processor.invoke((Object)name, (Object)it, (Object)false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            if (bl) continue;
            break;
        }
        return true;
    }

    @Override
    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)((Object)roamingType), (String)"roamingType");
        byte[] byArray2 = byArray = content;
        DefaultStateSerializerKt.getLOG().assertTrue(!(byArray2.length == 0));
        this.nameToData.put(PathUtilRt.getFileName(fileSpec), ArrayUtil.realloc(content, size));
    }

    public final void load(@Nullable Element state, @Nullable Function1<? super Element, String> nameGetter) {
        this.nameToData.clear();
        if (state == null) {
            return;
        }
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        for (Element child : state.getChildren(this.subStateTagName)) {
            CharSequence charSequence;
            Object name;
            block8: {
                Object object;
                block7: {
                    if (JdomKt.isEmpty(child)) continue;
                    object = nameGetter;
                    if (object == null) break block7;
                    Element element = child;
                    Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"child");
                    if ((object = (String)object.invoke((Object)element)) != null) break block8;
                }
                object = name = child.getAttributeValue("name");
            }
            if (name == null) {
                for (Element optionElement : child.getChildren("option")) {
                    if (!Intrinsics.areEqual((Object)optionElement.getAttributeValue("name"), (Object)"myName")) continue;
                    name = optionElement.getAttributeValue("value");
                }
            }
            if ((charSequence = (CharSequence)name) == null || charSequence.length() == 0) continue;
            this.nameToData.put(nameGenerator.generateUniqueName("" + FileUtil.sanitizeFileName(name, false) + ".xml"), JdomKt.toByteArray(child));
        }
    }

    public static /* bridge */ /* synthetic */ void load$default(SchemeManagerIprProvider schemeManagerIprProvider, Element element, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        schemeManagerIprProvider.load(element, (Function1<? super Element, String>)function1);
    }

    public final void writeState(@NotNull Element state, @Nullable Comparator<String> comparator) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Comparable[] $receiver$iv = (Comparable[])this.nameToData.keySet();
        if ($receiver$iv == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Comparable[] thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] names = stringArray;
        if (comparator == null) {
            $receiver$iv = (Comparable[])names;
            if ($receiver$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            ArraysKt.sort((Object[])$receiver$iv);
        } else {
            ArraysKt.sortWith((Object[])names, comparator);
        }
        for (int i = 0; i < names.length; ++i) {
            byte[] byArray;
            byte[] it;
            String name = names[i];
            if ((byte[])this.nameToData.get(name) == null) continue;
            byte[] byArray2 = it = byArray;
            state.addContent(JdomKt.loadElement(new ByteArrayInputStream(byArray2)));
        }
    }

    public static /* bridge */ /* synthetic */ void writeState$default(SchemeManagerIprProvider schemeManagerIprProvider, Element element, Comparator comparator, int n, Object object) {
        if ((n & 2) != 0) {
            comparator = null;
        }
        schemeManagerIprProvider.writeState(element, comparator);
    }

    public SchemeManagerIprProvider(@NotNull String subStateTagName) {
        Intrinsics.checkParameterIsNotNull((Object)subStateTagName, (String)"subStateTagName");
        this.subStateTagName = subStateTagName;
        this.nameToData = ContainerUtil.newConcurrentMap();
    }

    @Override
    public void write(@NotNull String path, @NotNull BufferExposingByteArrayOutputStream content, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)((Object)roamingType), (String)"roamingType");
        StreamProvider.DefaultImpls.write(this, path, content, roamingType);
    }

    @Override
    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled(this);
    }

    @Override
    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)((Object)roamingType), (String)"roamingType");
        return StreamProvider.DefaultImpls.isApplicable(this, fileSpec, roamingType);
    }
}

