/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopWithImplicitTerminationConditionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.display.name", new Object[0]);
        if (string == null) {
            LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (Boolean.TRUE.equals(infos[0])) {
            String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.dowhile.problem.descriptor", new Object[0]);
            if (string == null) {
                LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LoopWithImplicitTerminationConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopWithImplicitTerminationConditionVisitor();
    }

    static boolean containsUnlabeledBreakStatement(@Nullable PsiStatement statement) {
        if (!(statement instanceof PsiBlockStatement)) {
            return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(statement);
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(codeBlock);
        return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(firstStatement);
    }

    private static boolean isUnlabeledBreakStatement(@Nullable PsiStatement statement) {
        if (!(statement instanceof PsiBreakStatement)) {
            return false;
        }
        PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
        PsiIdentifier identifier = breakStatement.getLabelIdentifier();
        return identifier == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LoopWithImplicitTerminationConditionVisitor
    extends BaseInspectionVisitor {
        private LoopWithImplicitTerminationConditionVisitor() {
        }

        @Override
        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition(statement, true)) {
                return;
            }
            this.registerStatementError(statement, Boolean.FALSE);
        }

        @Override
        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition(statement, false)) {
                return;
            }
            this.registerStatementError(statement, Boolean.TRUE);
        }

        @Override
        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition(statement, true)) {
                return;
            }
            this.registerStatementError(statement, Boolean.FALSE);
        }

        private static boolean isLoopWithImplicitTerminationCondition(PsiLoopStatement statement, boolean firstStatement) {
            PsiStatement bodyStatement;
            PsiStatement body = statement.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return true;
                }
                bodyStatement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                bodyStatement = body;
            }
            return !LoopWithImplicitTerminationConditionVisitor.isImplicitTerminationCondition(bodyStatement);
        }

        private static boolean isImplicitTerminationCondition(@Nullable PsiStatement statement) {
            if (!(statement instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                return true;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch);
        }
    }

    private static class LoopWithImplicitTerminationConditionFix
    extends InspectionGadgetsFix {
        private LoopWithImplicitTerminationConditionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.quickfix", new Object[0]);
            if (string == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiStatement statement;
            boolean firstStatement;
            PsiStatement body;
            PsiExpression loopCondition;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)parent;
                loopCondition = whileStatement.getCondition();
                body = whileStatement.getBody();
                firstStatement = true;
            } else if (parent instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)parent;
                loopCondition = doWhileStatement.getCondition();
                body = doWhileStatement.getBody();
                firstStatement = false;
            } else if (parent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent;
                loopCondition = forStatement.getCondition();
                body = forStatement.getBody();
                firstStatement = true;
            } else {
                return;
            }
            if (loopCondition == null) {
                return;
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return;
                }
                statement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                statement = body;
            }
            if (!(statement instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiExpression ifCondition = ifStatement.getCondition();
            if (ifCondition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                String negatedExpressionText = BoolUtils.getNegatedExpressionText(ifCondition);
                PsiReplacementUtil.replaceExpression(loopCondition, negatedExpressionText);
                LoopWithImplicitTerminationConditionFix.replaceStatement(ifStatement, elseBranch);
            } else if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch)) {
                loopCondition.replace(ifCondition);
                if (thenBranch == null) {
                    ifStatement.delete();
                } else {
                    LoopWithImplicitTerminationConditionFix.replaceStatement(ifStatement, thenBranch);
                }
            }
        }

        private static void replaceStatement(@NotNull PsiStatement replacedStatement, @Nullable PsiStatement replacingStatement) throws IncorrectOperationException {
            if (replacedStatement == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(1);
            }
            if (replacingStatement == null) {
                replacedStatement.delete();
                return;
            }
            if (!(replacingStatement instanceof PsiBlockStatement)) {
                replacedStatement.replace(replacingStatement);
                return;
            }
            PsiBlockStatement blockStatement = (PsiBlockStatement)replacingStatement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                PsiElement receiver = replacedStatement.getParent();
                for (int i = children.length - 2; i > 0; --i) {
                    PsiElement child = children[i];
                    if (child instanceof PsiWhiteSpace) continue;
                    receiver.addAfter(child, replacedStatement);
                }
                replacedStatement.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection$LoopWithImplicitTerminationConditionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacedStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection$LoopWithImplicitTerminationConditionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

