/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SystemInfo
extends SystemInfoRt {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = SystemInfo.getRtVersion(JAVA_VERSION);
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isAppleJvm = SystemInfo.vendorContains("Apple");
    public static final boolean isOracleJvm = SystemInfo.vendorContains("Oracle");
    public static final boolean isSunJvm = SystemInfo.vendorContains("Sun") && SystemInfo.vendorContains("Microsystems");
    public static final boolean isIbmJvm = SystemInfo.vendorContains("IBM");
    public static final boolean isJetBrainsJvm = SystemInfo.vendorContains("JetBrains");
    public static final boolean IS_AT_LEAST_JAVA9 = SystemInfo.isModularJava();
    public static final boolean isWin2kOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.0");
    public static final boolean isWinXpOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.1");
    public static final boolean isWinVistaOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.0");
    public static final boolean isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
    public static final boolean isWin8OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.2");
    public static final boolean isWin10OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("10.0");
    public static final boolean isXWindow = isUnix && !isMac;
    public static final boolean isWayland = isXWindow && !StringUtil.isEmpty(System.getenv("WAYLAND_DISPLAY"));
    public static final boolean isGNOME = isXWindow && ObjectUtils.notNull(System.getenv("GDMSESSION"), "").startsWith("gnome");
    public static final boolean isKDE = isXWindow && !StringUtil.isEmpty(System.getenv("KDE_FULL_SESSION"));
    public static final boolean isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
    public static final boolean isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
    public static final boolean areSymLinksSupported = isUnix || isWinVistaOrNewer;
    public static final boolean is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
    public static final boolean is64Bit = !is32Bit;
    public static final boolean isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen = new PathExecLazyValue("xdg-open");
    private static final NotNullLazyValue<Boolean> ourHasXdgMime = new PathExecLazyValue("xdg-mime");
    public static final boolean isMacOSTiger = isMac && SystemInfo.isOsVersionAtLeast("10.4");
    public static final boolean isMacOSLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.5");
    public static final boolean isMacOSSnowLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.6");
    public static final boolean isMacOSLion = isMac && SystemInfo.isOsVersionAtLeast("10.7");
    public static final boolean isMacOSMountainLion = isMac && SystemInfo.isOsVersionAtLeast("10.8");
    public static final boolean isMacOSMavericks = isMac && SystemInfo.isOsVersionAtLeast("10.9");
    public static final boolean isMacOSYosemite = isMac && SystemInfo.isOsVersionAtLeast("10.10");
    public static final boolean isMacOSElCapitan = isMac && SystemInfo.isOsVersionAtLeast("10.11");
    public static final boolean isMacOSSierra = isMac && SystemInfo.isOsVersionAtLeast("10.12");
    public static final boolean isMacOSHighSierra = isMac && SystemInfo.isOsVersionAtLeast("10.13");
    public static final boolean isWindowsXP = isWindows && (OS_VERSION.equals("5.1") || OS_VERSION.equals("5.2"));
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);
    public static final boolean isOS2 = SystemInfoRt.isOS2;
    public static final boolean isJetbrainsJvm = isJetBrainsJvm;

    private static String getRtVersion(String fallback) {
        String rtVersion = System.getProperty("java.runtime.version");
        return Character.isDigit(rtVersion.charAt(0)) ? rtVersion : fallback;
    }

    private static boolean isModularJava() {
        try {
            Class.class.getMethod("getModule", new Class[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isOsVersionAtLeast(@NotNull String version) {
        if (version == null) {
            SystemInfo.$$$reportNull$$$0(0);
        }
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public static boolean hasXdgOpen() {
        return isXWindow && ourHasXdgOpen.getValue() != false;
    }

    public static boolean hasXdgMime() {
        return isXWindow && ourHasXdgMime.getValue() != false;
    }

    @NotNull
    public static String getMacOSMajorVersion() {
        String string = SystemInfo.getMacOSMajorVersion(OS_VERSION);
        if (string == null) {
            SystemInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getMacOSMajorVersion(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%d.%d", parts[0], parts[1]);
    }

    @NotNull
    public static String getMacOSVersionCode() {
        String string = SystemInfo.getMacOSVersionCode(OS_VERSION);
        if (string == null) {
            SystemInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode() {
        String string = SystemInfo.getMacOSMajorVersionCode(OS_VERSION);
        if (string == null) {
            SystemInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode() {
        String string = SystemInfo.getMacOSMinorVersionCode(OS_VERSION);
        if (string == null) {
            SystemInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getMacOSVersionCode(@NotNull String version) {
        if (version == null) {
            SystemInfo.$$$reportNull$$$0(5);
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), SystemInfo.normalize(parts[2]));
        if (string == null) {
            SystemInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode(@NotNull String version) {
        if (version == null) {
            SystemInfo.$$$reportNull$$$0(7);
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), 0);
        if (string == null) {
            SystemInfo.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode(@NotNull String version) {
        if (version == null) {
            SystemInfo.$$$reportNull$$$0(9);
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%02d", parts[1], parts[2]);
        if (string == null) {
            SystemInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static int[] getMacOSVersionParts(@NotNull String version) {
        if (version == null) {
            SystemInfo.$$$reportNull$$$0(11);
        }
        List<String> parts = StringUtil.split(version, ".");
        while (parts.size() < 3) {
            parts.add("0");
        }
        return new int[]{SystemInfo.toInt(parts.get(0)), SystemInfo.toInt(parts.get(1)), SystemInfo.toInt(parts.get(2))};
    }

    public static String getOsNameAndVersion() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    private static int normalize(int number) {
        return number > 9 ? 9 : number;
    }

    private static int toInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean vendorContains(String s) {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, s);
    }

    public static String getUnixReleaseName() {
        return null;
    }

    public static String getUnixReleaseVersion() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/SystemInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/SystemInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMajorVersion";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSVersionCode";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMajorVersionCode";
                break;
            }
            case 4: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMinorVersionCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOsVersionAtLeast";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSVersionCode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMajorVersionCode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMinorVersionCode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSVersionParts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

