/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterfaceMayBeAnnotatedFunctionalInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("interface.may.be.annotated.functional.display.name", new Object[0]);
        if (string == null) {
            InterfaceMayBeAnnotatedFunctionalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("interface.may.be.annotated.functional.problem.descriptor", new Object[0]);
        if (string == null) {
            InterfaceMayBeAnnotatedFunctionalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel8OrHigher(file);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        return new DelegatingFix(new AddAnnotationPsiFix("java.lang.FunctionalInterface", aClass, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceMayBeAnnotatedFunctionalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/InterfaceMayBeAnnotatedFunctionalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InterfaceMayBeAnnotatedFunctionalVisitor
    extends BaseInspectionVisitor {
        private InterfaceMayBeAnnotatedFunctionalVisitor() {
        }

        @Override
        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (!aClass.isInterface() || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, "java.lang.FunctionalInterface", false)) {
                return;
            }
            if (LambdaHighlightingUtil.checkInterfaceFunctional(aClass) != null) {
                return;
            }
            MethodSignature signature = LambdaUtil.getFunction(aClass);
            if (signature == null || signature.getTypeParameters().length > 0) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

