/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final boolean myIgnoreInAssertStatements;
    private int m_count;
    private boolean ignoring;

    public NegationCountVisitor(boolean ignoreInAssertStatements) {
        this.myIgnoreInAssertStatements = ignoreInAssertStatements;
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            NegationCountVisitor.$$$reportNull$$$0(0);
        }
        super.visitPolyadicExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        if (!this.ignoring && tokenType.equals(JavaTokenType.NE)) {
            this.m_count += expression.getOperands().length - 1;
        }
    }

    @Override
    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            NegationCountVisitor.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            NegationCountVisitor.$$$reportNull$$$0(2);
        }
        super.visitPrefixExpression(expression);
        if (!this.ignoring && expression.getOperationTokenType().equals(JavaTokenType.EXCL)) {
            ++this.m_count;
        }
    }

    @Override
    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myIgnoreInAssertStatements) {
            this.ignoring = true;
        }
        super.visitAssertStatement(statement);
    }

    @Override
    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            NegationCountVisitor.$$$reportNull$$$0(3);
        }
        super.elementFinished(element);
        if (element instanceof PsiAssertStatement) {
            this.ignoring = false;
        }
    }

    public int getCount() {
        return this.m_count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/methodmetrics/NegationCountVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnonymousClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "elementFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

