/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.configurationStore.StreamProviderKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectFileStoreOptionManager;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\f"}, d2={"isExternalStorageEnabled", "", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "displayUrlRelativeToProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "project", "includeFilePath", "moduleOnTheLeft", "projectModel-api"})
@JvmName(name="ProjectUtilCore")
public final class ProjectUtilCore {
    @NotNull
    public static final String displayUrlRelativeToProject(@NotNull VirtualFile file, @NotNull String url, @NotNull Project project, boolean includeFilePath, boolean moduleOnTheLeft) {
        Module module;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String result = url;
        if (includeFilePath) {
            String string;
            String projectHomeUrl;
            VirtualFile virtualFile = project.getBaseDir();
            String string2 = projectHomeUrl = virtualFile != null ? virtualFile.getPresentableUrl() : null;
            if (projectHomeUrl != null && StringsKt.startsWith$default((String)result, (String)projectHomeUrl, (boolean)false, (int)2, null)) {
                String string3 = result;
                int n = projectHomeUrl.length();
                StringBuilder stringBuilder = new StringBuilder().append("...");
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                String string5 = string4;
                string = stringBuilder.append(string5).toString();
            } else {
                String string6 = FileUtil.getLocationRelativeToUserHome(file.getPresentableUrl());
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"FileUtil.getLocationRela\u2026Home(file.presentableUrl)");
            }
            result = string;
        }
        if (file.getFileSystem() instanceof LocalFileProvider) {
            VirtualFileSystem virtualFileSystem = file.getFileSystem();
            if (virtualFileSystem == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.LocalFileProvider");
            }
            VirtualFile localFile = ((LocalFileProvider)((Object)virtualFileSystem)).getLocalVirtualFileFor(file);
            if (localFile != null) {
                OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file, project);
                if (libraryEntry instanceof JdkOrderEntry) {
                    return "" + result + " [" + ((JdkOrderEntry)libraryEntry).getJdkName() + ']';
                }
                if (libraryEntry != null) {
                    return "" + result + " [" + libraryEntry.getPresentableName() + ']';
                }
            }
        }
        return (module = ModuleUtilCore.findModuleForFile(file, project)) == null ? result : (moduleOnTheLeft ? '[' + module.getName() + "] " + result : "" + result + " [" + module.getName() + ']');
    }

    public static final boolean isExternalStorageEnabled(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String key = "com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager";
        Object object = $receiver.getPicoContainer().getComponentInstance((Object)key);
        if (!(object instanceof ProjectFileStoreOptionManager)) {
            object = null;
        }
        ProjectFileStoreOptionManager projectFileStoreOptionManager = (ProjectFileStoreOptionManager)object;
        if (projectFileStoreOptionManager == null) {
            return false;
        }
        ProjectFileStoreOptionManager manager = projectFileStoreOptionManager;
        return manager.isStoredExternally() || Registry.is("store.imported.project.elements.separately", false) || StreamProviderKt.getIS_EXTERNAL_STORAGE_ENABLED();
    }
}

