/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFinderImpl
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public PsiElementFinderImpl(Project project, JavaFileManager javaFileManager) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(1);
        }
        return this.myFileManager.findClass(qualifiedName, scope);
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(3);
        }
        PsiClass[] psiClassArray = this.myFileManager.findClasses(qualifiedName, scope);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(5);
        }
        return this.myFileManager.findPackage(qualifiedName);
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(7);
        }
        HashMap<String, PsiPackage> packagesMap = new HashMap<String, PsiPackage>();
        String qualifiedName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            PsiDirectory[] subDirs;
            for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                String subQualifiedName;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                packagesMap.put(aPackage.getQualifiedName(), aPackage);
            }
        }
        packagesMap.remove(qualifiedName);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
        if (psiPackageArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(8);
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(10);
        }
        PsiClass[] psiClassArray = this.getClasses(null, psiPackage, scope);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(13);
        }
        ArrayList<PsiClass> list = null;
        String packageName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir);
            if (classes.length == 0) continue;
            if (list == null) {
                list = new ArrayList<PsiClass>();
            }
            for (PsiClass aClass : classes) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName != null) {
                    qualifiedName = StringUtil.getPackageName(qualifiedName);
                }
                if (!Comparing.strEqual(qualifiedName, packageName) || shortName != null && !shortName.equals(aClass.getName())) continue;
                list.add(aClass);
            }
        }
        if (list == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiElementFinderImpl.$$$reportNull$$$0(14);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (list.size() > 1) {
            ContainerUtil.quickSort(list, PsiClassUtil.createScopeComparator(scope));
        }
        PsiClass[] psiClassArray = list.toArray(new PsiClass[list.size()]);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(15);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(17);
        }
        HashSet<String> names = null;
        FileIndexFacade facade = FileIndexFacade.getInstance(this.myProject);
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            for (PsiFile file : dir.getFiles()) {
                Set<String> inFile;
                VirtualFile vFile;
                if (!(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (vFile = file.getVirtualFile()) != null && !(file instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                Set<String> set = inFile = file instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file).getClassNames() : PsiElementFinderImpl.getClassNames(((PsiClassOwner)file).getClasses());
                if (inFile.isEmpty()) continue;
                if (names == null) {
                    names = new HashSet<String>();
                }
                names.addAll(inFile);
            }
        }
        Set<String> set = names == null ? Collections.emptySet() : names;
        if (set == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope, final @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(21);
        }
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        return PackageIndex.getInstance(this.myProject).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor<VirtualFile>)new ReadActionProcessor<VirtualFile>(){

            @Override
            public boolean processInReadAction(VirtualFile dir) {
                if (!scope.contains(dir)) {
                    return true;
                }
                PsiDirectory psiDir = psiManager.findDirectory(dir);
                return psiDir == null || consumer.process(psiDir);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiElementFinderImpl";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiElementFinderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

