/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchScopeUtil {
    @Nullable
    public static SearchScope union(@Nullable SearchScope a, @Nullable SearchScope b) {
        return a == null ? b : (b == null ? a : a.union(b));
    }

    @Deprecated
    @NotNull
    public static SearchScope scopesUnion(@NotNull SearchScope scope1, @NotNull SearchScope scope2) {
        if (scope1 == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(1);
        }
        SearchScope searchScope = scope1.union(scope2);
        if (searchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    public static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element) {
        if (scope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(4);
        }
        if (scope instanceof LocalSearchScope) {
            LocalSearchScope local = (LocalSearchScope)scope;
            return PsiSearchScopeUtil.isInScope(local, element);
        }
        GlobalSearchScope globalScope = (GlobalSearchScope)scope;
        return PsiSearchScopeUtil.isInScope(globalScope, element);
    }

    public static boolean isInScope(@NotNull GlobalSearchScope globalScope, @NotNull PsiElement element) {
        PsiFile file;
        if (globalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(6);
        }
        if ((file = element.getContainingFile()) == null) {
            return true;
        }
        PsiElement context = file.getContext();
        if (context != null) {
            file = context.getContainingFile();
        }
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile == null || globalScope.contains(virtualFile);
    }

    public static boolean isInScope(@NotNull LocalSearchScope local, @NotNull PsiElement element) {
        PsiElement[] scopeElements;
        if (local == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(8);
        }
        for (PsiElement scopeElement : scopeElements = local.getScope()) {
            if (!PsiTreeUtil.isAncestor(scopeElement, element, false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static SearchScope restrictScopeTo(@NotNull SearchScope originalScope, FileType ... fileTypes) {
        if (originalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(9);
        }
        if (fileTypes == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(10);
        }
        if (originalScope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, fileTypes);
            if (globalSearchScope == null) {
                PsiSearchScopeUtil.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }
        LocalSearchScope localSearchScope = LocalSearchScope.getScopeRestrictedByFileTypes((LocalSearchScope)originalScope, fileTypes);
        if (localSearchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(12);
        }
        return localSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "scopesUnion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scopesUnion";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

