/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConcurrentRefHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
TObjectHashingStrategy<K> {
    final ReferenceQueue<K> myReferenceQueue;
    private final ConcurrentMap<KeyReference<K, V>, V> myMap;
    @NotNull
    private final TObjectHashingStrategy<K> myHashingStrategy;
    private static final HardKey NULL_KEY = new HardKey(){

        @Override
        public Object get() {
            return null;
        }

        void setKey(Object key, int hash) {
        }
    };
    private static final float LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 16;
    private static final TObjectHashingStrategy THIS = new TObjectHashingStrategy(){

        public int computeHashCode(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o1, Object o2) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<HardKey> HARD_KEY = new ThreadLocal<HardKey>(){

        @Override
        protected HardKey initialValue() {
            return new HardKey();
        }
    };
    private Set<Map.Entry<K, V>> entrySet;

    @NotNull
    abstract KeyReference<K, V> createKeyReference(@NotNull K var1, @NotNull V var2, @NotNull TObjectHashingStrategy<K> var3);

    @NotNull
    private KeyReference<K, V> createKeyReference(@Nullable K key, @NotNull V value) {
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(0);
        }
        if (key == null) {
            HardKey hardKey = NULL_KEY;
            if (hardKey == null) {
                ConcurrentRefHashMap.$$$reportNull$$$0(1);
            }
            return hardKey;
        }
        KeyReference<K, V> keyReference = this.createKeyReference(key, value, this.myHashingStrategy);
        if (keyReference == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(2);
        }
        return keyReference;
    }

    boolean processQueue() {
        KeyReference wk;
        boolean processed2 = false;
        while ((wk = (KeyReference)((Object)this.myReferenceQueue.poll())) != null) {
            Object value = wk.getValue();
            this.myMap.remove(wk, value);
            processed2 = true;
        }
        return processed2;
    }

    ConcurrentRefHashMap() {
        this(16);
    }

    ConcurrentRefHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    private ConcurrentRefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 4, THIS);
    }

    ConcurrentRefHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(3);
        }
        this(16, 0.75f, 2, hashingStrategy);
    }

    ConcurrentRefHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(4);
        }
        this.myReferenceQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy == THIS ? this : hashingStrategy;
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        HardKey<K, V> hardKey = this.createHardKey(key);
        boolean result = this.myMap.containsKey(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    @NotNull
    private HardKey<K, V> createHardKey(@Nullable Object o) {
        if (o == null) {
            HardKey hardKey = NULL_KEY;
            if (hardKey == null) {
                ConcurrentRefHashMap.$$$reportNull$$$0(5);
            }
            return hardKey;
        }
        Object key = o;
        HardKey hardKey = HARD_KEY.get();
        hardKey.setKey(key, this.myHashingStrategy.computeHashCode(key));
        HardKey hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(6);
        }
        return hardKey2;
    }

    private static void releaseHardKey(@NotNull HardKey<?, ?> key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(7);
        }
        key.setKey(null, 0);
    }

    @Override
    public V get(@Nullable Object key) {
        HardKey<K, V> hardKey = this.createHardKey(key);
        Object result = this.myMap.get(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public V put(@Nullable K key, @NotNull V value) {
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(8);
        }
        this.processQueue();
        KeyReference<K, V> weakKey = this.createKeyReference(key, value);
        return this.myMap.put(weakKey, value);
    }

    @Override
    public V remove(@Nullable Object key) {
        this.processQueue();
        HardKey<K, V> hardKey = this.createHardKey(key);
        Object result = this.myMap.remove(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        EntrySet entrySet = es;
        if (entrySet == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(9);
        }
        return entrySet;
    }

    @Override
    public V putIfAbsent(@Nullable K key, @NotNull V value) {
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(10);
        }
        this.processQueue();
        return this.myMap.putIfAbsent(this.createKeyReference(key, value), value);
    }

    @Override
    public boolean remove(@Nullable Object key, @NotNull Object value) {
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(11);
        }
        this.processQueue();
        return this.myMap.remove(this.createKeyReference(key, value), value);
    }

    @Override
    public boolean replace(@Nullable K key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(12);
        }
        if (newValue == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(13);
        }
        this.processQueue();
        return this.myMap.replace(this.createKeyReference(key, oldValue), oldValue, newValue);
    }

    @Override
    public V replace(@Nullable K key, @NotNull V value) {
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(14);
        }
        this.processQueue();
        return this.myMap.replace(this.createKeyReference(key, value), value);
    }

    public int computeHashCode(K object) {
        int h = object.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public boolean equals(K o1, K o2) {
        return o1.equals(o2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createKeyReference";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "releaseHardKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<KeyReference<K, V>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentRefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator = new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<KeyReference<K, V>, V>> hashIterator;
                private RefEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        KeyReference wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null && wk != NULL_KEY) continue;
                        }
                        this.next = new RefEntry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    RefEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
            if (iterator == null) {
                EntrySet.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            ConcurrentRefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = ConcurrentRefHashMap.this.createHardKey(e.getKey());
            Object hv = ConcurrentRefHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && ConcurrentRefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                ConcurrentRefHashMap.this.myMap.remove(key);
            }
            ConcurrentRefHashMap.releaseHardKey(key);
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Map.Entry ent = entry;
                KeyReference wk = ent.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefHashMap$EntrySet", "iterator"));
        }
    }

    private static class RefEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        RefEntry(@NotNull Map.Entry<?, V> ent, @Nullable K key) {
            if (ent == null) {
                RefEntry.$$$reportNull$$$0(0);
            }
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(@NotNull V value) {
            if (value == null) {
                RefEntry.$$$reportNull$$$0(1);
            }
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RefEntry.valEquals(this.key, e.getKey()) && RefEntry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/ConcurrentRefHashMap$RefEntry";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        void setKey(K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        @NotNull
        public V getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }

    static interface KeyReference<K, V> {
        public K get();

        @NotNull
        public V getValue();

        public boolean equals(Object var1);

        public int hashCode();
    }
}

