/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CallToSuspiciousStringMethodInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.suspicious.string.method.display.name", new Object[0]);
        if (string == null) {
            CallToSuspiciousStringMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.suspicious.string.method.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToSuspiciousStringMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSuspiciousStringMethodVisitor();
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiModifierListOwner annotatableArgument;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        ArrayList<DelegatingFix> result = new ArrayList<DelegatingFix>();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        if (annotatableQualifier != null) {
            DelegatingFix fix = new DelegatingFix(new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableQualifier, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
            result.add(fix);
        }
        if ((annotatableArgument = NonNlsUtils.getAnnotatableArgument(methodCallExpression)) != null) {
            DelegatingFix fix = new DelegatingFix(new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableArgument, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
            result.add(fix);
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(new InspectionGadgetsFix[result.size()]);
        if (inspectionGadgetsFixArray == null) {
            CallToSuspiciousStringMethodInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/CallToSuspiciousStringMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CallToSuspiciousStringMethodVisitor
    extends BaseInspectionVisitor {
        private CallToSuspiciousStringMethodVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (!(MethodCallUtils.isEqualsCall(expression) || MethodCallUtils.isEqualsIgnoreCaseCall(expression) || MethodCallUtils.isCompareToCall(expression) || MethodCallUtils.isCompareToIgnoreCaseCall(expression))) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1 || NonNlsUtils.isNonNlsAnnotated(arguments[0])) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }
    }
}

