/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class UnconstructableTestCaseInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("UnconstructableJUnitTestCase" == null) {
            UnconstructableTestCaseInspection.$$$reportNull$$$0(0);
        }
        return "UnconstructableJUnitTestCase";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unconstructable.test.case.display.name", new Object[0]);
        if (string == null) {
            UnconstructableTestCaseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unconstructable.test.case.problem.descriptor", new Object[0]);
        if (string == null) {
            UnconstructableTestCaseInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconstructableTestCaseVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/UnconstructableTestCaseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnconstructableTestCaseVisitor
    extends BaseInspectionVisitor {
        private UnconstructableTestCaseVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                UnconstructableTestCaseVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (TestUtils.isJUnit4TestClass(aClass, false)) {
                PsiMethod[] constructors = aClass.getConstructors();
                if (constructors.length == 0) {
                    return;
                }
                if (constructors.length == 1) {
                    PsiMethod constructor = constructors[0];
                    PsiParameterList parameterList = constructor.getParameterList();
                    if (constructor.hasModifierProperty("public") && parameterList.getParametersCount() == 0) {
                        return;
                    }
                }
            } else if (TestUtils.isJUnitTestClass(aClass)) {
                PsiMethod[] constructors = aClass.getConstructors();
                boolean hasStringConstructor = false;
                boolean hasNoArgConstructor = false;
                boolean hasConstructor = false;
                for (PsiMethod constructor : constructors) {
                    PsiParameter[] parameters;
                    PsiType type;
                    hasConstructor = true;
                    if (!constructor.hasModifierProperty("public")) continue;
                    PsiParameterList parameterList = constructor.getParameterList();
                    int parametersCount = parameterList.getParametersCount();
                    if (parametersCount == 0) {
                        hasNoArgConstructor = true;
                    }
                    if (parametersCount != 1 || !TypeUtils.typeEquals("java.lang.String", type = (parameters = parameterList.getParameters())[0].getType())) continue;
                    hasStringConstructor = true;
                }
                if (!hasConstructor) {
                    return;
                }
                if (hasNoArgConstructor || hasStringConstructor) {
                    return;
                }
            } else {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/junit/UnconstructableTestCaseInspection$UnconstructableTestCaseVisitor", "visitClass"));
        }
    }
}

