/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.DefiniteAssignment;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefiniteAssignmentUtil {
    public static void checkVariable(PsiVariable variable, DefiniteAssignment definiteAssignment) {
        if (variable.getInitializer() != null) {
            throw new IllegalArgumentException("variable has initializer, check for assignment to the field");
        }
        if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            DefiniteAssignmentUtil.checkField(field, definiteAssignment);
        } else {
            if (variable instanceof PsiParameter) {
                throw new IllegalArgumentException("parameter has implicit initializer, check for assignment to the parameter");
            }
            if (variable instanceof PsiLocalVariable) {
                PsiLocalVariable localVariable = (PsiLocalVariable)variable;
                PsiElement parent = localVariable.getParent();
                assert (parent instanceof PsiDeclarationStatement);
                PsiStatement statement = (PsiStatement)parent;
                while (statement != null) {
                    DefiniteAssignmentUtil.checkStatement(statement, definiteAssignment);
                    statement = PsiTreeUtil.getNextSiblingOfType(statement, PsiStatement.class);
                }
            } else assert (false);
        }
    }

    private static void checkField(PsiField field, DefiniteAssignment definiteAssignment) {
        PsiMethod[] constructors;
        PsiClass aClass;
        if (field.getInitializer() != null) {
            definiteAssignment.set(true, false);
        }
        if ((aClass = field.getContainingClass()) == null) {
            return;
        }
        PsiElement[] children = aClass.getChildren();
        boolean isStatic = field.hasModifierProperty("static");
        for (PsiElement child : children) {
            PsiClassInitializer classInitializer;
            if (child instanceof PsiField) {
                PsiField otherField = (PsiField)child;
                if (otherField.hasModifierProperty("static") != isStatic) continue;
                DefiniteAssignmentUtil.checkExpression(otherField.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
                continue;
            }
            if (!(child instanceof PsiClassInitializer) || (classInitializer = (PsiClassInitializer)child).hasModifierProperty("static") != isStatic) continue;
            DefiniteAssignmentUtil.checkCodeBlock(classInitializer.getBody(), definiteAssignment);
        }
        if (!isStatic && (constructors = aClass.getConstructors()).length != 0) {
            boolean da = definiteAssignment.isDefinitelyAssigned();
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            boolean resultDa = true;
            boolean resultDu = true;
            for (PsiMethod constructor : constructors) {
                DefiniteAssignmentUtil.checkConstructor(constructor, definiteAssignment);
                resultDa &= definiteAssignment.isDefinitelyAssigned();
                resultDu &= definiteAssignment.isDefinitelyUnassigned();
                if (definiteAssignment.stop()) {
                    return;
                }
                definiteAssignment.set(da, du);
            }
            definiteAssignment.set(resultDa, resultDu);
        }
    }

    private static boolean isAlternateConstructorInvocation(PsiStatement statement) {
        return DefiniteAssignmentUtil.isConstructorInvocation(statement, "this");
    }

    private static boolean isSuperClassConstructorInvocation(PsiStatement statement) {
        return DefiniteAssignmentUtil.isConstructorInvocation(statement, "super");
    }

    private static boolean isConstructorInvocation(PsiStatement statement, @NotNull String keyword) {
        if (keyword == null) {
            DefiniteAssignmentUtil.$$$reportNull$$$0(0);
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        return keyword.equals(methodExpression.getReferenceName());
    }

    private static void checkAnonymousClass(PsiAnonymousClass anonymousClass, DefiniteAssignment definiteAssignment) {
        PsiClassInitializer[] initializers;
        for (PsiField field : anonymousClass.getFields()) {
            DefiniteAssignmentUtil.checkExpression(field.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
        for (PsiClassInitializer initializer : initializers = anonymousClass.getInitializers()) {
            DefiniteAssignmentUtil.checkCodeBlock(initializer.getBody(), definiteAssignment);
        }
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        for (PsiMethod method : anonymousClass.getMethods()) {
            definiteAssignment.set(true, false);
            DefiniteAssignmentUtil.checkCodeBlock(method.getBody(), definiteAssignment);
        }
        definiteAssignment.set(da, du);
    }

    private static void checkClass(PsiClass aClass, DefiniteAssignment definiteAssignment) {
        for (PsiField psiField : aClass.getFields()) {
            DefiniteAssignmentUtil.checkExpression(psiField.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
        for (PsiMember psiMember : aClass.getInitializers()) {
            DefiniteAssignmentUtil.checkCodeBlock(psiMember.getBody(), definiteAssignment);
        }
        for (PsiMember psiMember : aClass.getMethods()) {
            DefiniteAssignmentUtil.checkCodeBlock(psiMember.getBody(), definiteAssignment);
        }
        for (PsiMember psiMember : aClass.getInnerClasses()) {
            DefiniteAssignmentUtil.checkClass((PsiClass)psiMember, definiteAssignment);
        }
    }

    private static void checkConstructor(PsiMethod constructor, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(false, true);
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] statements = body.getStatements();
        boolean superCalled = false;
        for (int i = 0; i < statements.length; ++i) {
            PsiStatement statement = statements[i];
            if (i == 0) {
                if (DefiniteAssignmentUtil.isAlternateConstructorInvocation(statement)) {
                    DefiniteAssignmentUtil.checkStatement(statement, definiteAssignment);
                    definiteAssignment.set(true, false);
                    superCalled = true;
                    continue;
                }
                if (DefiniteAssignmentUtil.isSuperClassConstructorInvocation(statement)) {
                    DefiniteAssignmentUtil.checkStatement(statement, definiteAssignment);
                    definiteAssignment.set(da, du);
                    superCalled = true;
                    continue;
                }
            }
            if (!superCalled) {
                definiteAssignment.set(da, du);
                superCalled = true;
            }
            DefiniteAssignmentUtil.checkStatement(statement, definiteAssignment);
        }
        if (!superCalled) {
            definiteAssignment.set(da, du);
        }
        definiteAssignment.andDefiniteAssignmentBeforeReturn(constructor);
    }

    private static void checkCodeBlock(@Nullable PsiCodeBlock codeBlock, DefiniteAssignment definiteAssignment) {
        if (codeBlock == null) {
            return;
        }
        for (PsiStatement statement : codeBlock.getStatements()) {
            DefiniteAssignmentUtil.checkStatement(statement, definiteAssignment);
        }
    }

    private static void checkLocalVariable(PsiLocalVariable localVariable, DefiniteAssignment definiteAssignment) {
        PsiExpression initializer = localVariable.getInitializer();
        if (initializer != null && definiteAssignment.getVariable() == localVariable) {
            definiteAssignment.set(true, false);
        }
        DefiniteAssignmentUtil.checkExpression(initializer, definiteAssignment, BooleanExpressionValue.UNDEFINED);
    }

    private static void checkStatement(@Nullable PsiStatement statement, DefiniteAssignment definiteAssignment) {
        if (statement == null || definiteAssignment.stop() || statement instanceof PsiEmptyStatement) {
            return;
        }
        if (statement instanceof PsiAssertStatement) {
            PsiAssertStatement assertStatement = (PsiAssertStatement)statement;
            DefiniteAssignmentUtil.checkAssertStatement(assertStatement, definiteAssignment);
        } else if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            DefiniteAssignmentUtil.checkCodeBlock(blockStatement.getCodeBlock(), definiteAssignment);
        } else if (statement instanceof PsiBreakStatement) {
            PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
            DefiniteAssignmentUtil.checkBreakStatement(breakStatement, definiteAssignment);
        } else if (statement instanceof PsiContinueStatement) {
            PsiContinueStatement continueStatement = (PsiContinueStatement)statement;
            DefiniteAssignmentUtil.checkContinueStatement(continueStatement, definiteAssignment);
        } else if (statement instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            DefiniteAssignmentUtil.checkDeclarationStatement(declarationStatement, definiteAssignment);
        } else if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
            DefiniteAssignmentUtil.checkDoWhileStatement(doWhileStatement, definiteAssignment);
        } else if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            DefiniteAssignmentUtil.checkExpression(expressionStatement.getExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        } else if (statement instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)statement;
            DefiniteAssignmentUtil.checkExpressionListStatement(expressionListStatement, definiteAssignment);
        } else if (statement instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement;
            DefiniteAssignmentUtil.checkForeachStatement(foreachStatement, definiteAssignment);
        } else if (statement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement;
            DefiniteAssignmentUtil.checkForStatement(forStatement, definiteAssignment);
        } else if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            DefiniteAssignmentUtil.checkIfStatement(ifStatement, definiteAssignment);
        } else if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            DefiniteAssignmentUtil.checkLabeledStatement(labeledStatement, definiteAssignment);
        } else if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            DefiniteAssignmentUtil.checkReturnStatement(returnStatement, definiteAssignment);
        } else if (statement instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
            DefiniteAssignmentUtil.checkSwitchStatement(switchStatement, definiteAssignment);
        } else if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            DefiniteAssignmentUtil.checkSynchronizedStatement(synchronizedStatement, definiteAssignment);
        } else if (statement instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
            DefiniteAssignmentUtil.checkThrowStatement(throwStatement, definiteAssignment);
        } else if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            DefiniteAssignmentUtil.checkTryStatement(tryStatement, definiteAssignment);
        } else if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
            DefiniteAssignmentUtil.checkWhileStatement(whileStatement, definiteAssignment);
        }
    }

    private static void checkAssertStatement(PsiAssertStatement assertStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition = assertStatement.getAssertCondition();
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        boolean resultDu = du && definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(da, du);
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        DefiniteAssignmentUtil.checkExpression(assertStatement.getAssertDescription(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        definiteAssignment.set(da, resultDu);
    }

    private static void checkBreakStatement(PsiBreakStatement breakStatement, DefiniteAssignment definiteAssignment) {
        definiteAssignment.storeBeforeBreakStatement(breakStatement);
        definiteAssignment.set(true, true);
    }

    private static void checkContinueStatement(PsiContinueStatement continueStatement, DefiniteAssignment definiteAssignment) {
        definiteAssignment.storeBeforeContinueStatement(continueStatement);
        definiteAssignment.set(true, true);
    }

    private static void checkDeclarationStatement(PsiDeclarationStatement declarationStatement, DefiniteAssignment definiteAssignment) {
        for (PsiElement element : declarationStatement.getDeclaredElements()) {
            if (element instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)element;
                DefiniteAssignmentUtil.checkLocalVariable(variable, definiteAssignment);
                continue;
            }
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                boolean da = definiteAssignment.isDefinitelyAssigned();
                boolean du = definiteAssignment.isDefinitelyUnassigned();
                definiteAssignment.set(true, false);
                DefiniteAssignmentUtil.checkClass(aClass, definiteAssignment);
                definiteAssignment.set(da, du);
                continue;
            }
            throw new AssertionError((Object)("unknown element declared: " + element));
        }
    }

    private static void checkDoWhileStatement(PsiDoWhileStatement doWhileStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition = doWhileStatement.getCondition();
        PsiStatement body = doWhileStatement.getBody();
        DefiniteAssignmentUtil.checkStatement(body, definiteAssignment);
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned() & du);
        DefiniteAssignmentUtil.checkStatement(body, definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeContinue(doWhileStatement);
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        definiteAssignment.andDefiniteAssignmentBeforeBreak(doWhileStatement);
    }

    private static void checkExpressionListStatement(PsiExpressionListStatement expressionListStatement, DefiniteAssignment definiteAssignment) {
        PsiExpressionList expressionList = expressionListStatement.getExpressionList();
        for (PsiExpression expression : expressionList.getExpressions()) {
            DefiniteAssignmentUtil.checkExpression(expression, definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
    }

    private static void checkForeachStatement(PsiForeachStatement foreachStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(foreachStatement.getIteratedValue(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        boolean da = definiteAssignment.isDefinitelyAssigned();
        DefiniteAssignmentUtil.checkStatement(foreachStatement.getBody(), definiteAssignment);
        definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned());
        definiteAssignment.andDefiniteAssignmentBeforeBreak(foreachStatement);
    }

    private static void checkForStatement(PsiForStatement forStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkStatement(forStatement.getInitialization(), definiteAssignment);
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition = forStatement.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkStatement(forStatement.getBody(), definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeContinue(forStatement);
        DefiniteAssignmentUtil.checkStatement(forStatement.getUpdate(), definiteAssignment);
        DefiniteAssignmentUtil.checkStatement(forStatement.getBody(), definiteAssignment);
        definiteAssignment.set(da, du);
        if (condition == null) {
            definiteAssignment.set(true, true);
        } else {
            DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        }
        definiteAssignment.andDefiniteAssignmentBeforeBreak(forStatement);
    }

    private static void checkIfStatement(PsiIfStatement ifStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition = ifStatement.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkStatement(ifStatement.getThenBranch(), definiteAssignment);
        boolean resultDa = definiteAssignment.isDefinitelyAssigned();
        boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(da, du);
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        DefiniteAssignmentUtil.checkStatement(ifStatement.getElseBranch(), definiteAssignment);
        definiteAssignment.and(resultDa, resultDu);
    }

    private static void checkLabeledStatement(PsiLabeledStatement labeledStatement, DefiniteAssignment definiteAssignment) {
        PsiStatement statement = labeledStatement.getStatement();
        DefiniteAssignmentUtil.checkStatement(statement, definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeBreak(statement);
    }

    private static void checkReturnStatement(PsiReturnStatement returnStatement, DefiniteAssignment definiteAssignment) {
        definiteAssignment.storeBeforeReturn(returnStatement);
        DefiniteAssignmentUtil.checkExpression(returnStatement.getReturnValue(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        definiteAssignment.set(true, true);
    }

    private static void checkSwitchStatement(PsiSwitchStatement switchStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(switchStatement.getExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return;
        }
        boolean defaultSeen = false;
        for (PsiStatement statement : statements) {
            PsiSwitchLabelStatement switchLabelStatement;
            if (statement instanceof PsiSwitchLabelStatement && (switchLabelStatement = (PsiSwitchLabelStatement)statement).isDefaultCase()) {
                defaultSeen = true;
            }
            DefiniteAssignmentUtil.checkStatement(statement, definiteAssignment);
        }
        definiteAssignment.andDefiniteAssignmentBeforeBreak(switchStatement);
        definiteAssignment.and(defaultSeen, definiteAssignment.isDefinitelyUnassigned());
    }

    private static void checkSynchronizedStatement(PsiSynchronizedStatement synchronizedStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(synchronizedStatement.getLockExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        DefiniteAssignmentUtil.checkCodeBlock(synchronizedStatement.getBody(), definiteAssignment);
    }

    private static void checkThrowStatement(PsiThrowStatement throwStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(throwStatement.getException(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        definiteAssignment.set(true, true);
    }

    private static void checkTryStatement(PsiTryStatement tryStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement element : resourceList) {
                if (element instanceof PsiResourceExpression) {
                    PsiResourceExpression resourceExpression = (PsiResourceExpression)element;
                    DefiniteAssignmentUtil.checkExpression(resourceExpression.getExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
                    continue;
                }
                if (element instanceof PsiResourceVariable) {
                    PsiResourceVariable resourceVariable = (PsiResourceVariable)element;
                    DefiniteAssignmentUtil.checkExpression(resourceVariable.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
                    continue;
                }
                throw new AssertionError();
            }
        }
        DefiniteAssignmentUtil.checkCodeBlock(tryStatement.getTryBlock(), definiteAssignment);
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        boolean resultDa = definiteAssignment.isDefinitelyAssigned();
        boolean resultDu = du;
        for (PsiCodeBlock catchBlock : tryStatement.getCatchBlocks()) {
            definiteAssignment.set(da, du);
            DefiniteAssignmentUtil.checkCodeBlock(catchBlock, definiteAssignment);
            resultDu &= definiteAssignment.isDefinitelyUnassigned();
            resultDa &= definiteAssignment.isDefinitelyAssigned();
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned());
            DefiniteAssignmentUtil.checkCodeBlock(finallyBlock, definiteAssignment);
            resultDu &= definiteAssignment.isDefinitelyUnassigned();
        }
        definiteAssignment.set(resultDa | definiteAssignment.isDefinitelyAssigned(), resultDu);
    }

    private static void checkWhileStatement(PsiWhileStatement whileStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        PsiExpression condition = whileStatement.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkStatement(whileStatement.getBody(), definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeContinue(whileStatement);
        definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned());
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        definiteAssignment.andDefiniteAssignmentBeforeBreak(whileStatement);
    }

    private static void checkExpression(@Nullable PsiExpression expression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        Object result;
        if (expression == null || definiteAssignment.stop()) {
            return;
        }
        if (PsiType.BOOLEAN.equals(expression.getType()) && (result = ExpressionUtils.computeConstantExpression(expression)) != null) {
            if (Boolean.TRUE == result && BooleanExpressionValue.WHEN_FALSE == value || Boolean.FALSE == result && BooleanExpressionValue.WHEN_TRUE == value) {
                definiteAssignment.set(true, true);
            }
            return;
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            DefiniteAssignmentUtil.checkArrayAccessExpression(arrayAccessExpression, definiteAssignment, value);
        } else if (expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression;
            DefiniteAssignmentUtil.checkArrayInitializerExpression(arrayInitializerExpression, definiteAssignment, value);
        } else if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            DefiniteAssignmentUtil.checkAssignmentExpression(assignmentExpression, definiteAssignment);
        } else if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            DefiniteAssignmentUtil.checkConditionalExpression(conditionalExpression, definiteAssignment, value);
        } else if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
            DefiniteAssignmentUtil.checkExpression(instanceOfExpression.getOperand(), definiteAssignment, value);
        } else if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)expression;
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), false);
            DefiniteAssignmentUtil.checkLambdaExpression(lambdaExpression, definiteAssignment);
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), du);
        } else if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            DefiniteAssignmentUtil.checkMethodCallExpression(methodCallExpression, definiteAssignment, value);
        } else if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            DefiniteAssignmentUtil.checkNewExpression(newExpression, definiteAssignment, value);
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            DefiniteAssignmentUtil.checkExpression(parenthesizedExpression.getExpression(), definiteAssignment, value);
        } else if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            DefiniteAssignmentUtil.checkPolyadicExpression(polyadicExpression, definiteAssignment, value);
        } else if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            DefiniteAssignmentUtil.checkPostFixExpression(postfixExpression, definiteAssignment);
        } else if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            DefiniteAssignmentUtil.checkPrefixExpression(prefixExpression, definiteAssignment, value);
        } else if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            DefiniteAssignmentUtil.checkReferenceExpression(referenceExpression, definiteAssignment, value);
        } else if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            DefiniteAssignmentUtil.checkExpression(typeCastExpression.getOperand(), definiteAssignment, value);
        }
    }

    private static void checkArrayAccessExpression(PsiArrayAccessExpression arrayAccessExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        DefiniteAssignmentUtil.checkExpression(arrayAccessExpression.getArrayExpression(), definiteAssignment, value);
        DefiniteAssignmentUtil.checkExpression(arrayAccessExpression.getIndexExpression(), definiteAssignment, value);
    }

    private static void checkArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializerExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
            DefiniteAssignmentUtil.checkExpression(initializer, definiteAssignment, value);
        }
    }

    private static void checkAssignmentExpression(PsiAssignmentExpression assignmentExpression, DefiniteAssignment definiteAssignment) {
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiReferenceExpression referenceExpression = DefiniteAssignmentUtil.getReferenceIfAssignmentOfVariable(lhs, definiteAssignment);
        if (referenceExpression == null) {
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, BooleanExpressionValue.UNDEFINED);
            DefiniteAssignmentUtil.checkExpression(assignmentExpression.getRExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        } else {
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                definiteAssignment.valueAccess(referenceExpression);
            }
            DefiniteAssignmentUtil.checkExpression(assignmentExpression.getRExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
            definiteAssignment.assign(referenceExpression, true);
        }
    }

    private static PsiReferenceExpression getReferenceIfAssignmentOfVariable(PsiExpression lhs, DefiniteAssignment definiteAssignment) {
        if (!((lhs = ParenthesesUtils.stripParentheses(lhs)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
        PsiElement target = referenceExpression.resolve();
        if (!definiteAssignment.getVariable().equals(target)) {
            return null;
        }
        PsiExpression qualifier = referenceExpression.getQualifierExpression();
        if (!(qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null)) {
            return null;
        }
        return referenceExpression;
    }

    private static void checkConditionalExpression(PsiConditionalExpression conditionalExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        if (thenExpression != null && PsiType.BOOLEAN.equals(thenExpression.getType()) && elseExpression != null && PsiType.BOOLEAN.equals(elseExpression.getType())) {
            if (value == BooleanExpressionValue.WHEN_TRUE) {
                DefiniteAssignmentUtil.checkConditionalInternal(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
            } else if (value == BooleanExpressionValue.WHEN_FALSE) {
                DefiniteAssignmentUtil.checkConditionalInternal(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
            } else {
                boolean da = definiteAssignment.isDefinitelyAssigned();
                boolean du = definiteAssignment.isDefinitelyUnassigned();
                DefiniteAssignmentUtil.checkConditionalExpression(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
                boolean resultDa = definiteAssignment.isDefinitelyAssigned();
                boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
                definiteAssignment.set(da, du);
                DefiniteAssignmentUtil.checkConditionalExpression(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
                definiteAssignment.and(resultDa, resultDu);
            }
        } else {
            DefiniteAssignmentUtil.checkConditionalInternal(conditionalExpression, definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
    }

    private static void checkConditionalInternal(PsiConditionalExpression conditionalExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition = conditionalExpression.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkExpression(conditionalExpression.getThenExpression(), definiteAssignment, value);
        boolean resultDa = definiteAssignment.isDefinitelyAssigned();
        boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(da, du);
        DefiniteAssignmentUtil.checkExpression(condition, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        DefiniteAssignmentUtil.checkExpression(conditionalExpression.getElseExpression(), definiteAssignment, value);
        definiteAssignment.and(resultDa, resultDu);
    }

    private static void checkLambdaExpression(PsiLambdaExpression lambdaExpression, DefiniteAssignment definiteAssignment) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            PsiExpression bodyExpression = (PsiExpression)body;
            DefiniteAssignmentUtil.checkExpression(bodyExpression, definiteAssignment, BooleanExpressionValue.UNDEFINED);
        } else if (body instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = (PsiCodeBlock)body;
            DefiniteAssignmentUtil.checkCodeBlock(codeBlock, definiteAssignment);
        }
    }

    private static void checkMethodCallExpression(PsiMethodCallExpression methodCallExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        DefiniteAssignmentUtil.checkExpression(qualifier, definiteAssignment, value);
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression argument : argumentList.getExpressions()) {
            DefiniteAssignmentUtil.checkExpression(argument, definiteAssignment, value);
        }
    }

    private static void checkNewExpression(PsiNewExpression newExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        PsiAnonymousClass anonymousClass;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            for (PsiExpression argument : argumentList.getExpressions()) {
                DefiniteAssignmentUtil.checkExpression(argument, definiteAssignment, value);
            }
        }
        if ((anonymousClass = newExpression.getAnonymousClass()) != null) {
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), false);
            DefiniteAssignmentUtil.checkAnonymousClass(anonymousClass, definiteAssignment);
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), du);
        }
        for (PsiExpression dimension : newExpression.getArrayDimensions()) {
            DefiniteAssignmentUtil.checkExpression(dimension, definiteAssignment, value);
        }
        PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
        if (arrayInitializer != null) {
            DefiniteAssignmentUtil.checkExpression(arrayInitializer, definiteAssignment, value);
        }
    }

    private static void checkPolyadicExpression(PsiPolyadicExpression polyadicExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        PsiExpression[] operands = polyadicExpression.getOperands();
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (JavaTokenType.OROR == tokenType || JavaTokenType.ANDAND == tokenType) {
            for (int i = 1; i < operands.length; ++i) {
                DefiniteAssignmentUtil.checkBinaryExpression(operands[i - 1], operands[i], tokenType == JavaTokenType.ANDAND, definiteAssignment, value);
            }
        } else {
            for (PsiExpression operand : operands) {
                DefiniteAssignmentUtil.checkExpression(operand, definiteAssignment, BooleanExpressionValue.UNDEFINED);
            }
        }
    }

    private static void checkBinaryExpression(PsiExpression lhs, PsiExpression rhs, boolean and, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        if (and ? value == BooleanExpressionValue.WHEN_FALSE : value == BooleanExpressionValue.WHEN_TRUE) {
            boolean da = definiteAssignment.isDefinitelyAssigned();
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_FALSE : BooleanExpressionValue.WHEN_TRUE);
            boolean resultDa = definiteAssignment.isDefinitelyAssigned();
            boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(da, du);
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_TRUE : BooleanExpressionValue.WHEN_FALSE);
            DefiniteAssignmentUtil.checkExpression(rhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_FALSE : BooleanExpressionValue.WHEN_TRUE);
            definiteAssignment.and(resultDa, resultDu);
        } else if (and ? value == BooleanExpressionValue.WHEN_TRUE : value == BooleanExpressionValue.WHEN_FALSE) {
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_TRUE : BooleanExpressionValue.WHEN_FALSE);
            DefiniteAssignmentUtil.checkExpression(rhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_TRUE : BooleanExpressionValue.WHEN_FALSE);
        } else {
            boolean da = definiteAssignment.isDefinitelyAssigned();
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            DefiniteAssignmentUtil.checkBinaryExpression(lhs, rhs, false, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
            boolean resultDa = definiteAssignment.isDefinitelyAssigned();
            boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(da, du);
            DefiniteAssignmentUtil.checkBinaryExpression(lhs, rhs, false, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
            definiteAssignment.and(resultDa, resultDu);
        }
    }

    private static void checkPostFixExpression(PsiPostfixExpression postfixExpression, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(postfixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
    }

    private static void checkPrefixExpression(PsiPrefixExpression prefixExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (JavaTokenType.EXCL == tokenType) {
            if (value == BooleanExpressionValue.WHEN_TRUE) {
                DefiniteAssignmentUtil.checkExpression(prefixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
            } else if (value == BooleanExpressionValue.WHEN_FALSE) {
                DefiniteAssignmentUtil.checkExpression(prefixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
            } else {
                boolean da = definiteAssignment.isDefinitelyAssigned();
                boolean du = definiteAssignment.isDefinitelyUnassigned();
                DefiniteAssignmentUtil.checkPrefixExpression(prefixExpression, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
                boolean resultDa = definiteAssignment.isDefinitelyAssigned();
                boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
                definiteAssignment.set(da, du);
                DefiniteAssignmentUtil.checkPrefixExpression(prefixExpression, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
                definiteAssignment.and(resultDa, resultDu);
            }
        } else {
            DefiniteAssignmentUtil.checkExpression(prefixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
    }

    private static void checkReferenceExpression(PsiReferenceExpression referenceExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value) {
        PsiExpression qualifier = referenceExpression.getQualifierExpression();
        if (qualifier != null) {
            DefiniteAssignmentUtil.checkExpression(qualifier, definiteAssignment, value);
        }
        if (!definiteAssignment.getVariable().equals(referenceExpression.resolve())) {
            return;
        }
        if (PsiUtil.isAccessedForWriting(referenceExpression)) {
            definiteAssignment.assign(referenceExpression, false);
        } else {
            if (qualifier != null) {
                if (!(qualifier instanceof PsiThisExpression)) {
                    return;
                }
                PsiThisExpression thisExpression = (PsiThisExpression)qualifier;
                if (thisExpression.getQualifier() != null) {
                    return;
                }
            }
            definiteAssignment.valueAccess(referenceExpression);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/siyeh/ig/psiutils/DefiniteAssignmentUtil", "isConstructorInvocation"));
    }

    private static enum BooleanExpressionValue {
        WHEN_TRUE,
        WHEN_FALSE,
        UNDEFINED;

    }
}

