/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.style.ControlFlowStatementVisitorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleStatementInBlockInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("single.statement.in.block.name", new Object[0]);
        if (string == null) {
            SingleStatementInBlockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("single.statement.in.block.descriptor", infos);
        if (string == null) {
            SingleStatementInBlockInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SingleStatementInBlockVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 1 && infos[0] instanceof String) {
            return new SingleStatementInBlockFix((String)infos[0]);
        }
        return null;
    }

    private static void doFixImpl(@NotNull PsiBlockStatement blockStatement) {
        if (blockStatement == null) {
            SingleStatementInBlockInspection.$$$reportNull$$$0(2);
        }
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement[] statements = codeBlock.getStatements();
        PsiStatement statement = statements[0];
        SingleStatementInBlockInspection.handleComments(blockStatement, codeBlock);
        String text2 = statement.getText();
        PsiReplacementUtil.replaceStatement(blockStatement, text2);
    }

    private static void handleComments(PsiBlockStatement blockStatement, PsiCodeBlock codeBlock) {
        PsiElement parent = blockStatement.getParent();
        assert (parent != null);
        PsiElement grandParent = parent.getParent();
        assert (grandParent != null);
        PsiElement sibling = codeBlock.getFirstChild();
        assert (sibling != null);
        for (sibling = sibling.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof PsiComment)) continue;
            grandParent.addBefore(sibling, parent);
        }
        PsiElement lastChild = blockStatement.getLastChild();
        if (lastChild instanceof PsiComment) {
            PsiElement nextSibling = parent.getNextSibling();
            grandParent.addAfter(lastChild, nextSibling);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/SingleStatementInBlockInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/SingleStatementInBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFixImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingleStatementInBlockFix
    extends InspectionGadgetsFix {
        private final String myKeywordText;

        private SingleStatementInBlockFix(String keywordText) {
            this.myKeywordText = keywordText;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("single.statement.in.block.quickfix", this.myKeywordText);
            if (string == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("single.statement.in.block.family.quickfix", new Object[0]);
            if (string == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement body;
            PsiElement startElement = descriptor.getStartElement();
            PsiElement startParent = startElement.getParent();
            if (startElement instanceof PsiLoopStatement) {
                body = ((PsiLoopStatement)startElement).getBody();
            } else if (startParent instanceof PsiLoopStatement) {
                body = ((PsiLoopStatement)startParent).getBody();
            } else if (startElement instanceof PsiKeyword) {
                assert (startParent instanceof PsiIfStatement);
                PsiIfStatement ifStatement = (PsiIfStatement)startParent;
                body = ((PsiKeyword)startElement).getTokenType() == JavaTokenType.IF_KEYWORD ? ifStatement.getThenBranch() : ifStatement.getElseBranch();
            } else if (PsiUtil.isJavaToken(startElement, JavaTokenType.RBRACE)) {
                assert (startParent instanceof PsiCodeBlock);
                body = startParent.getParent();
            } else {
                return;
            }
            assert (body instanceof PsiBlockStatement);
            SingleStatementInBlockInspection.doFixImpl((PsiBlockStatement)body);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/SingleStatementInBlockInspection$SingleStatementInBlockFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class SingleStatementInBlockVisitor
    extends ControlFlowStatementVisitorBase {
        private SingleStatementInBlockVisitor() {
        }

        @Override
        @Contract(value="null->false")
        protected boolean isApplicable(PsiStatement body) {
            if (body instanceof PsiBlockStatement) {
                PsiFile file;
                PsiCodeBlock codeBlock = ((PsiBlockStatement)body).getCodeBlock();
                if (PsiUtilCore.hasErrorElementChild(codeBlock)) {
                    return false;
                }
                PsiStatement[] statements = codeBlock.getStatements();
                if (!(statements.length != 1 || statements[0] instanceof PsiDeclarationStatement || SingleStatementInBlockVisitor.isDanglingElseProblem(statements[0], body) || FileTypeUtils.isInServerPageFile(file = body.getContainingFile()))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        @Nullable
        protected Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement body) {
            PsiStatement statement;
            PsiCodeBlock codeBlock;
            PsiStatement[] statements;
            if (body instanceof PsiBlockStatement && (statements = (codeBlock = ((PsiBlockStatement)body).getCodeBlock()).getStatements()).length == 1 && ((statement = statements[0]) instanceof PsiLoopStatement || statement instanceof PsiIfStatement)) {
                return Pair.create(codeBlock.getLBrace(), codeBlock.getRBrace());
            }
            return null;
        }

        private static boolean isDanglingElseProblem(@Nullable PsiStatement statement, @NotNull PsiStatement outerStatement) {
            if (outerStatement == null) {
                SingleStatementInBlockVisitor.$$$reportNull$$$0(0);
            }
            return SingleStatementInBlockVisitor.hasShortIf(statement) && SingleStatementInBlockVisitor.hasPotentialDanglingElse(outerStatement);
        }

        private static boolean hasShortIf(@Nullable PsiStatement statement) {
            if (statement instanceof PsiIfStatement) {
                PsiStatement elseBranch = ((PsiIfStatement)statement).getElseBranch();
                return elseBranch == null || SingleStatementInBlockVisitor.hasShortIf(elseBranch);
            }
            if (statement instanceof PsiLabeledStatement) {
                return SingleStatementInBlockVisitor.hasShortIf(((PsiLabeledStatement)statement).getStatement());
            }
            if (statement instanceof PsiWhileStatement || statement instanceof PsiForStatement || statement instanceof PsiForeachStatement) {
                return SingleStatementInBlockVisitor.hasShortIf(((PsiLoopStatement)statement).getBody());
            }
            return false;
        }

        private static boolean hasPotentialDanglingElse(@NotNull PsiStatement statement) {
            PsiElement parent;
            if (statement == null) {
                SingleStatementInBlockVisitor.$$$reportNull$$$0(1);
            }
            if ((parent = statement.getParent()) instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                if (ifStatement.getThenBranch() == statement && ifStatement.getElseBranch() != null) {
                    return true;
                }
                return SingleStatementInBlockVisitor.hasPotentialDanglingElse(ifStatement);
            }
            if (parent instanceof PsiLabeledStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiForeachStatement) {
                return SingleStatementInBlockVisitor.hasPotentialDanglingElse((PsiStatement)parent);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/SingleStatementInBlockInspection$SingleStatementInBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDanglingElseProblem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasPotentialDanglingElse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

