/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ThrowableInterner {
    private static final WeakInterner<Throwable> myTraceInterner = new WeakInterner<Throwable>(new TObjectHashingStrategy<Throwable>(){

        public int computeHashCode(Throwable throwable) {
            String message = throwable.getMessage();
            if (message != null) {
                return message.hashCode();
            }
            Object[] backtrace = ThrowableInterner.getBacktrace(throwable);
            if (backtrace != null) {
                Object[] stack = (Object[])ContainerUtil.find(backtrace, FilteringIterator.instanceOf(Object[].class));
                return Arrays.hashCode(stack);
            }
            return Arrays.hashCode(throwable.getStackTrace());
        }

        public boolean equals(Throwable o1, Throwable o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (!Comparing.equal(o1.getClass(), o2.getClass())) {
                return false;
            }
            if (!Comparing.equal(o1.getMessage(), o2.getMessage())) {
                return false;
            }
            if (!this.equals(o1.getCause(), o2.getCause())) {
                return false;
            }
            Object[] backtrace1 = ThrowableInterner.getBacktrace(o1);
            Object[] backtrace2 = ThrowableInterner.getBacktrace(o2);
            if (backtrace1 != null && backtrace2 != null) {
                return Arrays.deepEquals(backtrace1, backtrace2);
            }
            return Arrays.equals(o1.getStackTrace(), o2.getStackTrace());
        }
    });
    private static final Field BACKTRACE_FIELD = ReflectionUtil.getDeclaredField(Throwable.class, "backtrace");
    private static final int BACKTRACE_FIELD_OFFSET;
    private static final int UNKNOWN = -1;
    private static final int LUCKILY_NOT_NEEDED = -2;

    private static Object[] getBacktrace(@NotNull Throwable throwable) {
        Object backtrace;
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(0);
        }
        try {
            backtrace = BACKTRACE_FIELD != null ? BACKTRACE_FIELD.get(throwable) : (BACKTRACE_FIELD_OFFSET == -1 ? null : AtomicFieldUpdater.getUnsafe().getObject(throwable, BACKTRACE_FIELD_OFFSET));
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return backtrace instanceof Object[] && ((Object[])backtrace).length == 5 ? (Object[])backtrace : null;
    }

    @NotNull
    public static Throwable intern(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(1);
        }
        Throwable throwable2 = ThrowableInterner.getBacktrace(throwable) == null ? throwable : myTraceInterner.intern(throwable);
        if (throwable2 == null) {
            ThrowableInterner.$$$reportNull$$$0(2);
        }
        return throwable2;
    }

    static {
        if (BACKTRACE_FIELD != null) {
            BACKTRACE_FIELD_OFFSET = -2;
        } else if ((SystemInfo.isOracleJvm || SystemInfo.isJetBrainsJvm) && SystemInfo.isJavaVersionAtLeast("1.7")) {
            Field firstField = Throwable.class.getDeclaredFields()[1];
            long firstFieldOffset = AtomicFieldUpdater.getUnsafe().objectFieldOffset(firstField);
            int n = firstFieldOffset == 12L ? 8 : (firstFieldOffset == 16L ? 12 : (BACKTRACE_FIELD_OFFSET = firstFieldOffset == 24L ? 16 : -1));
            if (BACKTRACE_FIELD_OFFSET == -1 || !firstField.getName().equals("detailMessage") || !(AtomicFieldUpdater.getUnsafe().getObject(new Throwable(), BACKTRACE_FIELD_OFFSET) instanceof Object[])) {
                throw new RuntimeException("Unknown layout: " + firstField + ";" + firstFieldOffset + ". Please specify -Didea.disposer.debug=off in idea.properties to suppress");
            }
        } else {
            BACKTRACE_FIELD_OFFSET = -1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/objectTree/ThrowableInterner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/objectTree/ThrowableInterner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBacktrace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

