/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsDeclarationLocalInspection;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsGraphAnnotator;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantThrowsDeclarationInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.unneededThrows.RedundantThrows");
    public boolean IGNORE_ENTRY_POINTS = false;
    private final RedundantThrowsDeclarationLocalInspection myLocalInspection = new RedundantThrowsDeclarationLocalInspection(this);

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.redundant.throws.display.name", new Object[0]);
        if (string == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore exceptions thrown by entry points methods", this, "IGNORE_ENTRY_POINTS");
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(5);
        }
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isSyntheticJSP()) {
                return null;
            }
            if (this.IGNORE_ENTRY_POINTS && refMethod.isEntry()) {
                return null;
            }
            PsiClass[] unThrown = refMethod.getUnThrownExceptions();
            if (unThrown == null) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
            if (psiMethod == null) {
                return null;
            }
            PsiClassType[] throwsList = psiMethod.getThrowsList().getReferencedTypes();
            PsiJavaCodeReferenceElement[] throwsRefs = psiMethod.getThrowsList().getReferenceElements();
            ArrayList<ProblemDescriptor> problems = null;
            PsiManager psiManager = psiMethod.getManager();
            for (int i = 0; i < throwsList.length; ++i) {
                PsiClassType throwsType = throwsList[i];
                String throwsClassName = throwsType.getClassName();
                PsiJavaCodeReferenceElement throwsRef = throwsRefs[i];
                if (ExceptionUtil.isUncheckedException(throwsType) || RedundantThrowsDeclarationInspection.declaredInRemotableMethod(psiMethod, throwsType)) continue;
                for (PsiClass s : unThrown) {
                    PsiClass throwsResolvedType = throwsType.resolve();
                    if (!psiManager.areElementsEquivalent(s, throwsResolvedType)) continue;
                    if (problems == null) {
                        problems = new ArrayList<ProblemDescriptor>(1);
                    }
                    if (refMethod.isAbstract() || refMethod.getOwnerClass().isInterface()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message("inspection.redundant.throws.problem.descriptor", "<code>#ref</code>"), new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    if (!refMethod.getDerivedMethods().isEmpty()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message("inspection.redundant.throws.problem.descriptor1", "<code>#ref</code>"), new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message("inspection.redundant.throws.problem.descriptor2", "<code>#ref</code>"), new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                }
            }
            if (problems != null) {
                return problems.toArray(new CommonProblemDescriptor[problems.size()]);
            }
        }
        return null;
    }

    private static boolean declaredInRemotableMethod(PsiMethod psiMethod, PsiClassType throwsType) {
        if (!throwsType.equalsToText("java.rmi.RemoteException")) {
            return false;
        }
        PsiClass aClass = psiMethod.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiClass remote = JavaPsiFacade.getInstance(aClass.getProject()).findClass("java.rmi.Remote", GlobalSearchScope.allScope(aClass.getProject()));
        return remote != null && aClass.isInheritor(remote, true);
    }

    @Override
    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(6);
        }
        if (globalContext == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(8);
        }
        manager.iterate(new RefJavaVisitor(){

            @Override
            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processor.getDescriptions(refEntity) != null) {
                    refEntity.accept(new RefJavaVisitor(){

                        @Override
                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                @Override
                                public boolean process(PsiMethod derivedMethod) {
                                    processor.ignoreElement(refMethod);
                                    return true;
                                }
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$1$1", "visitMethod"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$1", "visitElement"));
            }
        });
        return false;
    }

    @Override
    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new MyQuickFix(null, hint);
    }

    @Override
    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(9);
        }
        return fix instanceof MyQuickFix ? ((MyQuickFix)fix).myHint : null;
    }

    @Override
    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(10);
        }
        return new RedundantThrowsGraphAnnotator(refManager);
    }

    @Override
    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return this.myLocalInspection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private final String myHint;

        public MyQuickFix(ProblemDescriptionsProcessor processor, String hint) {
            this.myProcessor = processor;
            this.myHint = hint;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.throws.remove.quickfix", new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (this.myProcessor != null) {
                RefMethod refMethod;
                CommonProblemDescriptor[] problems;
                RefElement refElement = (RefElement)this.myProcessor.getElement(descriptor);
                if (refElement instanceof RefMethod && refElement.isValid() && (problems = this.myProcessor.getDescriptions(refMethod = (RefMethod)refElement)) != null) {
                    this.removeExcessiveThrows(refMethod, null, problems);
                }
            } else {
                PsiMethod psiMethod = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiMethod.class);
                if (psiMethod != null) {
                    this.removeExcessiveThrows(null, psiMethod, new CommonProblemDescriptor[]{descriptor});
                }
            }
        }

        private void removeExcessiveThrows(@Nullable RefMethod refMethod, @Nullable PsiModifierListOwner element, CommonProblemDescriptor[] problems) {
            try {
                PsiMethod psiMethod;
                if (element == null) {
                    LOG.assertTrue(refMethod != null);
                    psiMethod = (PsiMethod)refMethod.getElement();
                } else {
                    psiMethod = (PsiMethod)element;
                }
                if (psiMethod == null) {
                    return;
                }
                Project project = psiMethod.getProject();
                PsiManager psiManager = PsiManager.getInstance(project);
                ArrayList<PsiJavaCodeReferenceElement> refsToDelete = new ArrayList<PsiJavaCodeReferenceElement>();
                block2: for (CommonProblemDescriptor problem : problems) {
                    PsiClassType[] classTypes;
                    PsiElement psiElement = ((ProblemDescriptor)problem).getPsiElement();
                    if (psiElement instanceof PsiJavaCodeReferenceElement) {
                        PsiJavaCodeReferenceElement classRef = (PsiJavaCodeReferenceElement)psiElement;
                        PsiClassType psiType = JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory().createType(classRef);
                        MyQuickFix.removeException(refMethod, psiType, refsToDelete, psiMethod);
                        continue;
                    }
                    PsiReferenceList throwsList = psiMethod.getThrowsList();
                    for (PsiClassType classType : classTypes = throwsList.getReferencedTypes()) {
                        String text2 = classType.getClassName();
                        if (!Comparing.strEqual(this.myHint, text2)) continue;
                        MyQuickFix.removeException(refMethod, classType, refsToDelete, psiMethod);
                        continue block2;
                    }
                }
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(refsToDelete)) {
                    return;
                }
                WriteAction.run(() -> {
                    for (PsiJavaCodeReferenceElement aRefsToDelete : refsToDelete) {
                        if (!aRefsToDelete.isValid()) continue;
                        aRefsToDelete.delete();
                    }
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        private static void removeException(RefMethod refMethod, PsiType exceptionType, List<PsiJavaCodeReferenceElement> refsToDelete, PsiMethod psiMethod) {
            PsiManager psiManager = psiMethod.getManager();
            PsiJavaCodeReferenceElement[] refs = psiMethod.getThrowsList().getReferenceElements();
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiClassType refType = JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory().createType(ref);
                if (!exceptionType.isAssignableFrom(refType)) continue;
                refsToDelete.add(ref);
            }
            if (refMethod != null) {
                for (RefMethod refDerived : refMethod.getDerivedMethods()) {
                    PsiModifierListOwner method = refDerived.getElement();
                    if (method == null) continue;
                    MyQuickFix.removeException(refDerived, exceptionType, refsToDelete, (PsiMethod)method);
                }
            } else {
                Query<PsiMethod> query = OverridingMethodsSearch.search(psiMethod);
                query.forEach(m -> {
                    MyQuickFix.removeException(null, exceptionType, refsToDelete, m);
                    return true;
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

